/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-28 at 20:40:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.clouddebugger.v2.model;

/**
 * A CloudWorkspaceId is a unique identifier for a cloud workspace. A cloud workspace is a place
 * associated with a repo where modified files can be stored before they are committed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Debugger API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CloudWorkspaceId extends com.google.api.client.json.GenericJson {

  /**
   * The unique name of the workspace within the repo. This is the name chosen by the client in the
   * Source API's CreateWorkspace method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ID of the repo containing the workspace.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepoId repoId;

  /**
   * The unique name of the workspace within the repo. This is the name chosen by the client in the
   * Source API's CreateWorkspace method.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The unique name of the workspace within the repo. This is the name chosen by the client in the
   * Source API's CreateWorkspace method.
   * @param name name or {@code null} for none
   */
  public CloudWorkspaceId setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ID of the repo containing the workspace.
   * @return value or {@code null} for none
   */
  public RepoId getRepoId() {
    return repoId;
  }

  /**
   * The ID of the repo containing the workspace.
   * @param repoId repoId or {@code null} for none
   */
  public CloudWorkspaceId setRepoId(RepoId repoId) {
    this.repoId = repoId;
    return this;
  }

  @Override
  public CloudWorkspaceId set(String fieldName, Object value) {
    return (CloudWorkspaceId) super.set(fieldName, value);
  }

  @Override
  public CloudWorkspaceId clone() {
    return (CloudWorkspaceId) super.clone();
  }

}
