/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-28 at 20:40:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.clouddebugger.v2.model;

/**
 * Response for listing active breakpoints.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Debugger API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListActiveBreakpointsResponse extends com.google.api.client.json.GenericJson {

  /**
   * List of all active breakpoints. The fields `id` and `location` are guaranteed to be set on each
   * breakpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Breakpoint> breakpoints;

  /**
   * A wait token that can be used in the next method call to block until the list of breakpoints
   * changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextWaitToken;

  /**
   * The `wait_expired` field is set to true by the server when the request times out and the field
   * `success_on_timeout` is set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean waitExpired;

  /**
   * List of all active breakpoints. The fields `id` and `location` are guaranteed to be set on each
   * breakpoint.
   * @return value or {@code null} for none
   */
  public java.util.List<Breakpoint> getBreakpoints() {
    return breakpoints;
  }

  /**
   * List of all active breakpoints. The fields `id` and `location` are guaranteed to be set on each
   * breakpoint.
   * @param breakpoints breakpoints or {@code null} for none
   */
  public ListActiveBreakpointsResponse setBreakpoints(java.util.List<Breakpoint> breakpoints) {
    this.breakpoints = breakpoints;
    return this;
  }

  /**
   * A wait token that can be used in the next method call to block until the list of breakpoints
   * changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextWaitToken() {
    return nextWaitToken;
  }

  /**
   * A wait token that can be used in the next method call to block until the list of breakpoints
   * changes.
   * @param nextWaitToken nextWaitToken or {@code null} for none
   */
  public ListActiveBreakpointsResponse setNextWaitToken(java.lang.String nextWaitToken) {
    this.nextWaitToken = nextWaitToken;
    return this;
  }

  /**
   * The `wait_expired` field is set to true by the server when the request times out and the field
   * `success_on_timeout` is set to true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWaitExpired() {
    return waitExpired;
  }

  /**
   * The `wait_expired` field is set to true by the server when the request times out and the field
   * `success_on_timeout` is set to true.
   * @param waitExpired waitExpired or {@code null} for none
   */
  public ListActiveBreakpointsResponse setWaitExpired(java.lang.Boolean waitExpired) {
    this.waitExpired = waitExpired;
    return this;
  }

  @Override
  public ListActiveBreakpointsResponse set(String fieldName, Object value) {
    return (ListActiveBreakpointsResponse) super.set(fieldName, value);
  }

  @Override
  public ListActiveBreakpointsResponse clone() {
    return (ListActiveBreakpointsResponse) super.clone();
  }

}
