/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-28 at 20:40:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.clouddebugger.v2.model;

/**
 * Represents a stack frame context.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Debugger API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StackFrame extends com.google.api.client.json.GenericJson {

  /**
   * Set of arguments passed to this function. Note that this might not be populated for all stack
   * frames.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Variable> arguments;

  /**
   * Demangled function name at the call site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String function;

  /**
   * Set of local variables at the stack frame location. Note that this might not be populated for
   * all stack frames.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Variable> locals;

  /**
   * Source location of the call site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SourceLocation location;

  /**
   * Set of arguments passed to this function. Note that this might not be populated for all stack
   * frames.
   * @return value or {@code null} for none
   */
  public java.util.List<Variable> getArguments() {
    return arguments;
  }

  /**
   * Set of arguments passed to this function. Note that this might not be populated for all stack
   * frames.
   * @param arguments arguments or {@code null} for none
   */
  public StackFrame setArguments(java.util.List<Variable> arguments) {
    this.arguments = arguments;
    return this;
  }

  /**
   * Demangled function name at the call site.
   * @return value or {@code null} for none
   */
  public java.lang.String getFunction() {
    return function;
  }

  /**
   * Demangled function name at the call site.
   * @param function function or {@code null} for none
   */
  public StackFrame setFunction(java.lang.String function) {
    this.function = function;
    return this;
  }

  /**
   * Set of local variables at the stack frame location. Note that this might not be populated for
   * all stack frames.
   * @return value or {@code null} for none
   */
  public java.util.List<Variable> getLocals() {
    return locals;
  }

  /**
   * Set of local variables at the stack frame location. Note that this might not be populated for
   * all stack frames.
   * @param locals locals or {@code null} for none
   */
  public StackFrame setLocals(java.util.List<Variable> locals) {
    this.locals = locals;
    return this;
  }

  /**
   * Source location of the call site.
   * @return value or {@code null} for none
   */
  public SourceLocation getLocation() {
    return location;
  }

  /**
   * Source location of the call site.
   * @param location location or {@code null} for none
   */
  public StackFrame setLocation(SourceLocation location) {
    this.location = location;
    return this;
  }

  @Override
  public StackFrame set(String fieldName, Object value) {
    return (StackFrame) super.set(fieldName, value);
  }

  @Override
  public StackFrame clone() {
    return (StackFrame) super.clone();
  }

}
