/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.clouddebugger.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.clouddebugger.v2.ClouddebuggerRequest;
import com.google.api.services.clouddebugger.v2.ClouddebuggerRequestInitializer;
import com.google.api.services.clouddebugger.v2.model.Breakpoint;
import com.google.api.services.clouddebugger.v2.model.Empty;
import com.google.api.services.clouddebugger.v2.model.GetBreakpointResponse;
import com.google.api.services.clouddebugger.v2.model.ListActiveBreakpointsResponse;
import com.google.api.services.clouddebugger.v2.model.ListBreakpointsResponse;
import com.google.api.services.clouddebugger.v2.model.ListDebuggeesResponse;
import com.google.api.services.clouddebugger.v2.model.RegisterDebuggeeRequest;
import com.google.api.services.clouddebugger.v2.model.RegisterDebuggeeResponse;
import com.google.api.services.clouddebugger.v2.model.SetBreakpointResponse;
import com.google.api.services.clouddebugger.v2.model.UpdateActiveBreakpointRequest;
import com.google.api.services.clouddebugger.v2.model.UpdateActiveBreakpointResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clouddebugger
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://clouddebugger.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://clouddebugger.googleapis.com/";

    public Clouddebugger(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Clouddebugger(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Controller controller() {
        return new Controller();
    }

    public Debugger debugger() {
        return new Debugger();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google Cloud Debugger API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://clouddebugger.googleapis.com/", Clouddebugger.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Clouddebugger build() {
            return new Clouddebugger(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setClouddebuggerRequestInitializer(ClouddebuggerRequestInitializer clouddebuggerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)clouddebuggerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Debugger {
        public Debuggees debuggees() {
            return new Debuggees();
        }

        public class Debuggees {
            public List list() throws IOException {
                List list = new List();
                Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Breakpoints breakpoints() {
                return new Breakpoints();
            }

            public class Breakpoints {
                public Delete delete(String string, String string2) throws IOException {
                    Delete delete = new Delete(string, string2);
                    Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2) throws IOException {
                    Get get = new Get(string, string2);
                    Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Set set(String string, Breakpoint breakpoint) throws IOException {
                    Set set = new Set(string, breakpoint);
                    Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)set);
                    return set;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Set
                extends ClouddebuggerRequest<SetBreakpointResponse> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints/set";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String clientVersion;

                    protected Set(String string, Breakpoint breakpoint) {
                        super(Clouddebugger.this, "POST", REST_PATH, (Object)breakpoint, SetBreakpointResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter debuggeeId must be specified.");
                    }

                    public Set set$Xgafv(String string) {
                        return (Set)super.set$Xgafv(string);
                    }

                    public Set setAccessToken(String string) {
                        return (Set)super.setAccessToken(string);
                    }

                    public Set setAlt(String string) {
                        return (Set)super.setAlt(string);
                    }

                    public Set setBearerToken(String string) {
                        return (Set)super.setBearerToken(string);
                    }

                    public Set setCallback(String string) {
                        return (Set)super.setCallback(string);
                    }

                    public Set setFields(String string) {
                        return (Set)super.setFields(string);
                    }

                    public Set setKey(String string) {
                        return (Set)super.setKey(string);
                    }

                    public Set setOauthToken(String string) {
                        return (Set)super.setOauthToken(string);
                    }

                    public Set setPp(Boolean bl) {
                        return (Set)super.setPp(bl);
                    }

                    public Set setPrettyPrint(Boolean bl) {
                        return (Set)super.setPrettyPrint(bl);
                    }

                    public Set setQuotaUser(String string) {
                        return (Set)super.setQuotaUser(string);
                    }

                    public Set setUploadType(String string) {
                        return (Set)super.setUploadType(string);
                    }

                    public Set setUploadProtocol(String string) {
                        return (Set)super.setUploadProtocol(string);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Set setDebuggeeId(String string) {
                        this.debuggeeId = string;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public Set setClientVersion(String string) {
                        this.clientVersion = string;
                        return this;
                    }

                    @Override
                    public Set set(String string, Object object) {
                        return (Set)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ClouddebuggerRequest<ListBreakpointsResponse> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints";
                    @Key
                    private String debuggeeId;
                    @Key
                    private Boolean includeAllUsers;
                    @Key
                    private Boolean includeInactive;
                    @Key(value="action.value")
                    private String actionValue;
                    @Key
                    private Boolean stripResults;
                    @Key
                    private String waitToken;
                    @Key
                    private String clientVersion;

                    protected List(String string) {
                        super(Clouddebugger.this, "GET", REST_PATH, null, ListBreakpointsResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter debuggeeId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public List setDebuggeeId(String string) {
                        this.debuggeeId = string;
                        return this;
                    }

                    public Boolean getIncludeAllUsers() {
                        return this.includeAllUsers;
                    }

                    public List setIncludeAllUsers(Boolean bl) {
                        this.includeAllUsers = bl;
                        return this;
                    }

                    public Boolean getIncludeInactive() {
                        return this.includeInactive;
                    }

                    public List setIncludeInactive(Boolean bl) {
                        this.includeInactive = bl;
                        return this;
                    }

                    public String getActionValue() {
                        return this.actionValue;
                    }

                    public List setActionValue(String string) {
                        this.actionValue = string;
                        return this;
                    }

                    public Boolean getStripResults() {
                        return this.stripResults;
                    }

                    public List setStripResults(Boolean bl) {
                        this.stripResults = bl;
                        return this;
                    }

                    public String getWaitToken() {
                        return this.waitToken;
                    }

                    public List setWaitToken(String string) {
                        this.waitToken = string;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public List setClientVersion(String string) {
                        this.clientVersion = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ClouddebuggerRequest<GetBreakpointResponse> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String breakpointId;
                    @Key
                    private String clientVersion;

                    protected Get(String string, String string2) {
                        super(Clouddebugger.this, "GET", REST_PATH, null, GetBreakpointResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter debuggeeId must be specified.");
                        this.breakpointId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter breakpointId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Get setDebuggeeId(String string) {
                        this.debuggeeId = string;
                        return this;
                    }

                    public String getBreakpointId() {
                        return this.breakpointId;
                    }

                    public Get setBreakpointId(String string) {
                        this.breakpointId = string;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public Get setClientVersion(String string) {
                        this.clientVersion = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends ClouddebuggerRequest<Empty> {
                    private static final String REST_PATH = "v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String breakpointId;
                    @Key
                    private String clientVersion;

                    protected Delete(String string, String string2) {
                        super(Clouddebugger.this, "DELETE", REST_PATH, null, Empty.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter debuggeeId must be specified.");
                        this.breakpointId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter breakpointId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Delete setDebuggeeId(String string) {
                        this.debuggeeId = string;
                        return this;
                    }

                    public String getBreakpointId() {
                        return this.breakpointId;
                    }

                    public Delete setBreakpointId(String string) {
                        this.breakpointId = string;
                        return this;
                    }

                    public String getClientVersion() {
                        return this.clientVersion;
                    }

                    public Delete setClientVersion(String string) {
                        this.clientVersion = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ClouddebuggerRequest<ListDebuggeesResponse> {
                private static final String REST_PATH = "v2/debugger/debuggees";
                @Key
                private String project;
                @Key
                private Boolean includeInactive;
                @Key
                private String clientVersion;

                protected List() {
                    super(Clouddebugger.this, "GET", REST_PATH, null, ListDebuggeesResponse.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String string) {
                    this.project = string;
                    return this;
                }

                public Boolean getIncludeInactive() {
                    return this.includeInactive;
                }

                public List setIncludeInactive(Boolean bl) {
                    this.includeInactive = bl;
                    return this;
                }

                public String getClientVersion() {
                    return this.clientVersion;
                }

                public List setClientVersion(String string) {
                    this.clientVersion = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }
    }

    public class Controller {
        public Debuggees debuggees() {
            return new Debuggees();
        }

        public class Debuggees {
            public Register register(RegisterDebuggeeRequest registerDebuggeeRequest) throws IOException {
                Register register = new Register(registerDebuggeeRequest);
                Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)register);
                return register;
            }

            public Breakpoints breakpoints() {
                return new Breakpoints();
            }

            public class Breakpoints {
                public List list(String string) throws IOException {
                    List list = new List(string);
                    Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Update update(String string, String string2, UpdateActiveBreakpointRequest updateActiveBreakpointRequest) throws IOException {
                    Update update = new Update(string, string2, updateActiveBreakpointRequest);
                    Clouddebugger.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends ClouddebuggerRequest<UpdateActiveBreakpointResponse> {
                    private static final String REST_PATH = "v2/controller/debuggees/{debuggeeId}/breakpoints/{id}";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String id;

                    protected Update(String string, String string2, UpdateActiveBreakpointRequest updateActiveBreakpointRequest) {
                        super(Clouddebugger.this, "PUT", REST_PATH, (Object)updateActiveBreakpointRequest, UpdateActiveBreakpointResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter debuggeeId must be specified.");
                        this.id = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter id must be specified.");
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setBearerToken(String string) {
                        return (Update)super.setBearerToken(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPp(Boolean bl) {
                        return (Update)super.setPp(bl);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public Update setDebuggeeId(String string) {
                        this.debuggeeId = string;
                        return this;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Update setId(String string) {
                        this.id = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ClouddebuggerRequest<ListActiveBreakpointsResponse> {
                    private static final String REST_PATH = "v2/controller/debuggees/{debuggeeId}/breakpoints";
                    @Key
                    private String debuggeeId;
                    @Key
                    private String waitToken;
                    @Key
                    private Boolean successOnTimeout;

                    protected List(String string) {
                        super(Clouddebugger.this, "GET", REST_PATH, null, ListActiveBreakpointsResponse.class);
                        this.debuggeeId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter debuggeeId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getDebuggeeId() {
                        return this.debuggeeId;
                    }

                    public List setDebuggeeId(String string) {
                        this.debuggeeId = string;
                        return this;
                    }

                    public String getWaitToken() {
                        return this.waitToken;
                    }

                    public List setWaitToken(String string) {
                        this.waitToken = string;
                        return this;
                    }

                    public Boolean getSuccessOnTimeout() {
                        return this.successOnTimeout;
                    }

                    public List setSuccessOnTimeout(Boolean bl) {
                        this.successOnTimeout = bl;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Register
            extends ClouddebuggerRequest<RegisterDebuggeeResponse> {
                private static final String REST_PATH = "v2/controller/debuggees/register";

                protected Register(RegisterDebuggeeRequest registerDebuggeeRequest) {
                    super(Clouddebugger.this, "POST", REST_PATH, (Object)registerDebuggeeRequest, RegisterDebuggeeResponse.class);
                }

                public Register set$Xgafv(String string) {
                    return (Register)super.set$Xgafv(string);
                }

                public Register setAccessToken(String string) {
                    return (Register)super.setAccessToken(string);
                }

                public Register setAlt(String string) {
                    return (Register)super.setAlt(string);
                }

                public Register setBearerToken(String string) {
                    return (Register)super.setBearerToken(string);
                }

                public Register setCallback(String string) {
                    return (Register)super.setCallback(string);
                }

                public Register setFields(String string) {
                    return (Register)super.setFields(string);
                }

                public Register setKey(String string) {
                    return (Register)super.setKey(string);
                }

                public Register setOauthToken(String string) {
                    return (Register)super.setOauthToken(string);
                }

                public Register setPp(Boolean bl) {
                    return (Register)super.setPp(bl);
                }

                public Register setPrettyPrint(Boolean bl) {
                    return (Register)super.setPrettyPrint(bl);
                }

                public Register setQuotaUser(String string) {
                    return (Register)super.setQuotaUser(string);
                }

                public Register setUploadType(String string) {
                    return (Register)super.setUploadType(string);
                }

                public Register setUploadProtocol(String string) {
                    return (Register)super.setUploadProtocol(string);
                }

                @Override
                public Register set(String string, Object object) {
                    return (Register)super.set(string, object);
                }
            }
        }
    }
}

