/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The request for creating an IdpCredential with its associated payload. An InboundSamlSsoProfile
 * can own up to 2 credentials.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AddIdpCredentialRequest extends com.google.api.client.json.GenericJson {

  /**
   * PEM encoded x509 certificate containing the public key for verifying IdP signatures.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pemData;

  /**
   * PEM encoded x509 certificate containing the public key for verifying IdP signatures.
   * @return value or {@code null} for none
   */
  public java.lang.String getPemData() {
    return pemData;
  }

  /**
   * PEM encoded x509 certificate containing the public key for verifying IdP signatures.
   * @param pemData pemData or {@code null} for none
   */
  public AddIdpCredentialRequest setPemData(java.lang.String pemData) {
    this.pemData = pemData;
    return this;
  }

  @Override
  public AddIdpCredentialRequest set(String fieldName, Object value) {
    return (AddIdpCredentialRequest) super.set(fieldName, value);
  }

  @Override
  public AddIdpCredentialRequest clone() {
    return (AddIdpCredentialRequest) super.clone();
  }

}
