/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Dynamic group metadata like queries and status.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicGroupMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Memberships will be the union of all queries. Only one entry with USER resource is currently
   * supported. Customers can create up to 500 dynamic groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DynamicGroupQuery> queries;

  /**
   * Output only. Status of the dynamic group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DynamicGroupStatus status;

  /**
   * Memberships will be the union of all queries. Only one entry with USER resource is currently
   * supported. Customers can create up to 500 dynamic groups.
   * @return value or {@code null} for none
   */
  public java.util.List<DynamicGroupQuery> getQueries() {
    return queries;
  }

  /**
   * Memberships will be the union of all queries. Only one entry with USER resource is currently
   * supported. Customers can create up to 500 dynamic groups.
   * @param queries queries or {@code null} for none
   */
  public DynamicGroupMetadata setQueries(java.util.List<DynamicGroupQuery> queries) {
    this.queries = queries;
    return this;
  }

  /**
   * Output only. Status of the dynamic group.
   * @return value or {@code null} for none
   */
  public DynamicGroupStatus getStatus() {
    return status;
  }

  /**
   * Output only. Status of the dynamic group.
   * @param status status or {@code null} for none
   */
  public DynamicGroupMetadata setStatus(DynamicGroupStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public DynamicGroupMetadata set(String fieldName, Object value) {
    return (DynamicGroupMetadata) super.set(fieldName, value);
  }

  @Override
  public DynamicGroupMetadata clone() {
    return (DynamicGroupMetadata) super.clone();
  }

}
