/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The current status of a dynamic group along with timestamp.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicGroupStatus extends com.google.api.client.json.GenericJson {

  /**
   * Status of the dynamic group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * The latest time at which the dynamic group is guaranteed to be in the given status. If status
   * is `UP_TO_DATE`, the latest time at which the dynamic group was confirmed to be up-to-date. If
   * status is `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String statusTime;

  /**
   * Status of the dynamic group.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the dynamic group.
   * @param status status or {@code null} for none
   */
  public DynamicGroupStatus setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * The latest time at which the dynamic group is guaranteed to be in the given status. If status
   * is `UP_TO_DATE`, the latest time at which the dynamic group was confirmed to be up-to-date. If
   * status is `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
   * @return value or {@code null} for none
   */
  public String getStatusTime() {
    return statusTime;
  }

  /**
   * The latest time at which the dynamic group is guaranteed to be in the given status. If status
   * is `UP_TO_DATE`, the latest time at which the dynamic group was confirmed to be up-to-date. If
   * status is `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
   * @param statusTime statusTime or {@code null} for none
   */
  public DynamicGroupStatus setStatusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

  @Override
  public DynamicGroupStatus set(String fieldName, Object value) {
    return (DynamicGroupStatus) super.set(fieldName, value);
  }

  @Override
  public DynamicGroupStatus clone() {
    return (DynamicGroupStatus) super.clone();
  }

}
