/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The response message for MembershipsService.GetMembershipGraph.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetMembershipGraphResponse extends com.google.api.client.json.GenericJson {

  /**
   * The membership graph's path information represented as an adjacency list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MembershipAdjacencyList> adjacencyList;

  /**
   * The resources representing each group in the adjacency list. Each group in this list can be
   * correlated to a 'group' of the MembershipAdjacencyList using the 'name' of the Group resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Group> groups;

  /**
   * The membership graph's path information represented as an adjacency list.
   * @return value or {@code null} for none
   */
  public java.util.List<MembershipAdjacencyList> getAdjacencyList() {
    return adjacencyList;
  }

  /**
   * The membership graph's path information represented as an adjacency list.
   * @param adjacencyList adjacencyList or {@code null} for none
   */
  public GetMembershipGraphResponse setAdjacencyList(java.util.List<MembershipAdjacencyList> adjacencyList) {
    this.adjacencyList = adjacencyList;
    return this;
  }

  /**
   * The resources representing each group in the adjacency list. Each group in this list can be
   * correlated to a 'group' of the MembershipAdjacencyList using the 'name' of the Group resource.
   * @return value or {@code null} for none
   */
  public java.util.List<Group> getGroups() {
    return groups;
  }

  /**
   * The resources representing each group in the adjacency list. Each group in this list can be
   * correlated to a 'group' of the MembershipAdjacencyList using the 'name' of the Group resource.
   * @param groups groups or {@code null} for none
   */
  public GetMembershipGraphResponse setGroups(java.util.List<Group> groups) {
    this.groups = groups;
    return this;
  }

  @Override
  public GetMembershipGraphResponse set(String fieldName, Object value) {
    return (GetMembershipGraphResponse) super.set(fieldName, value);
  }

  @Override
  public GetMembershipGraphResponse clone() {
    return (GetMembershipGraphResponse) super.clone();
  }

}
