/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Contains information about browser profiles reported by the [Endpoint Verification
 * extension](https://chromewebstore.google.com/detail/endpoint-
 * verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1BrowserAttributes extends com.google.api.client.json.GenericJson {

  /**
   * Represents the current state of the [Chrome browser
   * attributes](https://cloud.google.com/access-context-manager/docs/browser-attributes) sent by
   * the [Endpoint Verification extension](https://chromewebstore.google.com/detail/endpoint-
   * verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCloudidentityDevicesV1BrowserInfo chromeBrowserInfo;

  /**
   * Chrome profile ID that is exposed by the Chrome API. It is unique for each device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String chromeProfileId;

  /**
   * Timestamp in milliseconds since the Unix epoch when the profile/gcm id was last synced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastProfileSyncTime;

  /**
   * Represents the current state of the [Chrome browser
   * attributes](https://cloud.google.com/access-context-manager/docs/browser-attributes) sent by
   * the [Endpoint Verification extension](https://chromewebstore.google.com/detail/endpoint-
   * verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
   * @return value or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo getChromeBrowserInfo() {
    return chromeBrowserInfo;
  }

  /**
   * Represents the current state of the [Chrome browser
   * attributes](https://cloud.google.com/access-context-manager/docs/browser-attributes) sent by
   * the [Endpoint Verification extension](https://chromewebstore.google.com/detail/endpoint-
   * verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
   * @param chromeBrowserInfo chromeBrowserInfo or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserAttributes setChromeBrowserInfo(GoogleAppsCloudidentityDevicesV1BrowserInfo chromeBrowserInfo) {
    this.chromeBrowserInfo = chromeBrowserInfo;
    return this;
  }

  /**
   * Chrome profile ID that is exposed by the Chrome API. It is unique for each device.
   * @return value or {@code null} for none
   */
  public java.lang.String getChromeProfileId() {
    return chromeProfileId;
  }

  /**
   * Chrome profile ID that is exposed by the Chrome API. It is unique for each device.
   * @param chromeProfileId chromeProfileId or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserAttributes setChromeProfileId(java.lang.String chromeProfileId) {
    this.chromeProfileId = chromeProfileId;
    return this;
  }

  /**
   * Timestamp in milliseconds since the Unix epoch when the profile/gcm id was last synced.
   * @return value or {@code null} for none
   */
  public String getLastProfileSyncTime() {
    return lastProfileSyncTime;
  }

  /**
   * Timestamp in milliseconds since the Unix epoch when the profile/gcm id was last synced.
   * @param lastProfileSyncTime lastProfileSyncTime or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserAttributes setLastProfileSyncTime(String lastProfileSyncTime) {
    this.lastProfileSyncTime = lastProfileSyncTime;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1BrowserAttributes set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1BrowserAttributes) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1BrowserAttributes clone() {
    return (GoogleAppsCloudidentityDevicesV1BrowserAttributes) super.clone();
  }

}
