/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Browser-specific fields reported by the [Endpoint Verification
 * extension](https://chromewebstore.google.com/detail/endpoint-
 * verification/callobklhcbilhphinckomhgkigmfocg?pli=1).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1BrowserInfo extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Browser's management state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String browserManagementState;

  /**
   * Version of the request initiating browser. E.g. `91.0.4442.4`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String browserVersion;

  /**
   * Current state of [built-in DNS
   * client](https://chromeenterprise.google/policies/#BuiltInDnsClientEnabled).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isBuiltInDnsClientEnabled;

  /**
   * Current state of [bulk data
   * analysis](https://chromeenterprise.google/policies/#OnBulkDataEntryEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isBulkDataEntryAnalysisEnabled;

  /**
   * Current state of [Chrome
   * Cleanup](https://chromeenterprise.google/policies/#ChromeCleanupEnabled).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isChromeCleanupEnabled;

  /**
   * Current state of [Chrome Remote Desktop
   * app](https://chromeenterprise.google/policies/#URLBlocklist).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isChromeRemoteDesktopAppBlocked;

  /**
   * Current state of [file download
   * analysis](https://chromeenterprise.google/policies/#OnFileDownloadedEnterpriseConnector). Set
   * to true if provider list from Chrome is non-empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isFileDownloadAnalysisEnabled;

  /**
   * Current state of [file upload
   * analysis](https://chromeenterprise.google/policies/#OnFileAttachedEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isFileUploadAnalysisEnabled;

  /**
   * Current state of [real-time URL
   * check](https://chromeenterprise.google/policies/#EnterpriseRealTimeUrlCheckMode). Set to true
   * if provider list from Chrome is non-empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRealtimeUrlCheckEnabled;

  /**
   * Current state of [security event
   * analysis](https://chromeenterprise.google/policies/#OnSecurityEventEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isSecurityEventAnalysisEnabled;

  /**
   * Current state of [site
   * isolation](https://chromeenterprise.google/policies/?policy=IsolateOrigins).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isSiteIsolationEnabled;

  /**
   * Current state of [third-party
   * blocking](https://chromeenterprise.google/policies/#ThirdPartyBlockingEnabled).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isThirdPartyBlockingEnabled;

  /**
   * Current state of [password protection
   * trigger](https://chromeenterprise.google/policies/#PasswordProtectionWarningTrigger).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String passwordProtectionWarningTrigger;

  /**
   * Current state of [Safe Browsing protection
   * level](https://chromeenterprise.google/policies/#SafeBrowsingProtectionLevel).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String safeBrowsingProtectionLevel;

  /**
   * Output only. Browser's management state.
   * @return value or {@code null} for none
   */
  public java.lang.String getBrowserManagementState() {
    return browserManagementState;
  }

  /**
   * Output only. Browser's management state.
   * @param browserManagementState browserManagementState or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setBrowserManagementState(java.lang.String browserManagementState) {
    this.browserManagementState = browserManagementState;
    return this;
  }

  /**
   * Version of the request initiating browser. E.g. `91.0.4442.4`.
   * @return value or {@code null} for none
   */
  public java.lang.String getBrowserVersion() {
    return browserVersion;
  }

  /**
   * Version of the request initiating browser. E.g. `91.0.4442.4`.
   * @param browserVersion browserVersion or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setBrowserVersion(java.lang.String browserVersion) {
    this.browserVersion = browserVersion;
    return this;
  }

  /**
   * Current state of [built-in DNS
   * client](https://chromeenterprise.google/policies/#BuiltInDnsClientEnabled).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsBuiltInDnsClientEnabled() {
    return isBuiltInDnsClientEnabled;
  }

  /**
   * Current state of [built-in DNS
   * client](https://chromeenterprise.google/policies/#BuiltInDnsClientEnabled).
   * @param isBuiltInDnsClientEnabled isBuiltInDnsClientEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsBuiltInDnsClientEnabled(java.lang.Boolean isBuiltInDnsClientEnabled) {
    this.isBuiltInDnsClientEnabled = isBuiltInDnsClientEnabled;
    return this;
  }

  /**
   * Current state of [bulk data
   * analysis](https://chromeenterprise.google/policies/#OnBulkDataEntryEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsBulkDataEntryAnalysisEnabled() {
    return isBulkDataEntryAnalysisEnabled;
  }

  /**
   * Current state of [bulk data
   * analysis](https://chromeenterprise.google/policies/#OnBulkDataEntryEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * @param isBulkDataEntryAnalysisEnabled isBulkDataEntryAnalysisEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsBulkDataEntryAnalysisEnabled(java.lang.Boolean isBulkDataEntryAnalysisEnabled) {
    this.isBulkDataEntryAnalysisEnabled = isBulkDataEntryAnalysisEnabled;
    return this;
  }

  /**
   * Current state of [Chrome
   * Cleanup](https://chromeenterprise.google/policies/#ChromeCleanupEnabled).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsChromeCleanupEnabled() {
    return isChromeCleanupEnabled;
  }

  /**
   * Current state of [Chrome
   * Cleanup](https://chromeenterprise.google/policies/#ChromeCleanupEnabled).
   * @param isChromeCleanupEnabled isChromeCleanupEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsChromeCleanupEnabled(java.lang.Boolean isChromeCleanupEnabled) {
    this.isChromeCleanupEnabled = isChromeCleanupEnabled;
    return this;
  }

  /**
   * Current state of [Chrome Remote Desktop
   * app](https://chromeenterprise.google/policies/#URLBlocklist).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsChromeRemoteDesktopAppBlocked() {
    return isChromeRemoteDesktopAppBlocked;
  }

  /**
   * Current state of [Chrome Remote Desktop
   * app](https://chromeenterprise.google/policies/#URLBlocklist).
   * @param isChromeRemoteDesktopAppBlocked isChromeRemoteDesktopAppBlocked or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsChromeRemoteDesktopAppBlocked(java.lang.Boolean isChromeRemoteDesktopAppBlocked) {
    this.isChromeRemoteDesktopAppBlocked = isChromeRemoteDesktopAppBlocked;
    return this;
  }

  /**
   * Current state of [file download
   * analysis](https://chromeenterprise.google/policies/#OnFileDownloadedEnterpriseConnector). Set
   * to true if provider list from Chrome is non-empty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsFileDownloadAnalysisEnabled() {
    return isFileDownloadAnalysisEnabled;
  }

  /**
   * Current state of [file download
   * analysis](https://chromeenterprise.google/policies/#OnFileDownloadedEnterpriseConnector). Set
   * to true if provider list from Chrome is non-empty.
   * @param isFileDownloadAnalysisEnabled isFileDownloadAnalysisEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsFileDownloadAnalysisEnabled(java.lang.Boolean isFileDownloadAnalysisEnabled) {
    this.isFileDownloadAnalysisEnabled = isFileDownloadAnalysisEnabled;
    return this;
  }

  /**
   * Current state of [file upload
   * analysis](https://chromeenterprise.google/policies/#OnFileAttachedEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsFileUploadAnalysisEnabled() {
    return isFileUploadAnalysisEnabled;
  }

  /**
   * Current state of [file upload
   * analysis](https://chromeenterprise.google/policies/#OnFileAttachedEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * @param isFileUploadAnalysisEnabled isFileUploadAnalysisEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsFileUploadAnalysisEnabled(java.lang.Boolean isFileUploadAnalysisEnabled) {
    this.isFileUploadAnalysisEnabled = isFileUploadAnalysisEnabled;
    return this;
  }

  /**
   * Current state of [real-time URL
   * check](https://chromeenterprise.google/policies/#EnterpriseRealTimeUrlCheckMode). Set to true
   * if provider list from Chrome is non-empty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRealtimeUrlCheckEnabled() {
    return isRealtimeUrlCheckEnabled;
  }

  /**
   * Current state of [real-time URL
   * check](https://chromeenterprise.google/policies/#EnterpriseRealTimeUrlCheckMode). Set to true
   * if provider list from Chrome is non-empty.
   * @param isRealtimeUrlCheckEnabled isRealtimeUrlCheckEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsRealtimeUrlCheckEnabled(java.lang.Boolean isRealtimeUrlCheckEnabled) {
    this.isRealtimeUrlCheckEnabled = isRealtimeUrlCheckEnabled;
    return this;
  }

  /**
   * Current state of [security event
   * analysis](https://chromeenterprise.google/policies/#OnSecurityEventEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsSecurityEventAnalysisEnabled() {
    return isSecurityEventAnalysisEnabled;
  }

  /**
   * Current state of [security event
   * analysis](https://chromeenterprise.google/policies/#OnSecurityEventEnterpriseConnector). Set to
   * true if provider list from Chrome is non-empty.
   * @param isSecurityEventAnalysisEnabled isSecurityEventAnalysisEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsSecurityEventAnalysisEnabled(java.lang.Boolean isSecurityEventAnalysisEnabled) {
    this.isSecurityEventAnalysisEnabled = isSecurityEventAnalysisEnabled;
    return this;
  }

  /**
   * Current state of [site
   * isolation](https://chromeenterprise.google/policies/?policy=IsolateOrigins).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsSiteIsolationEnabled() {
    return isSiteIsolationEnabled;
  }

  /**
   * Current state of [site
   * isolation](https://chromeenterprise.google/policies/?policy=IsolateOrigins).
   * @param isSiteIsolationEnabled isSiteIsolationEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsSiteIsolationEnabled(java.lang.Boolean isSiteIsolationEnabled) {
    this.isSiteIsolationEnabled = isSiteIsolationEnabled;
    return this;
  }

  /**
   * Current state of [third-party
   * blocking](https://chromeenterprise.google/policies/#ThirdPartyBlockingEnabled).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsThirdPartyBlockingEnabled() {
    return isThirdPartyBlockingEnabled;
  }

  /**
   * Current state of [third-party
   * blocking](https://chromeenterprise.google/policies/#ThirdPartyBlockingEnabled).
   * @param isThirdPartyBlockingEnabled isThirdPartyBlockingEnabled or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setIsThirdPartyBlockingEnabled(java.lang.Boolean isThirdPartyBlockingEnabled) {
    this.isThirdPartyBlockingEnabled = isThirdPartyBlockingEnabled;
    return this;
  }

  /**
   * Current state of [password protection
   * trigger](https://chromeenterprise.google/policies/#PasswordProtectionWarningTrigger).
   * @return value or {@code null} for none
   */
  public java.lang.String getPasswordProtectionWarningTrigger() {
    return passwordProtectionWarningTrigger;
  }

  /**
   * Current state of [password protection
   * trigger](https://chromeenterprise.google/policies/#PasswordProtectionWarningTrigger).
   * @param passwordProtectionWarningTrigger passwordProtectionWarningTrigger or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setPasswordProtectionWarningTrigger(java.lang.String passwordProtectionWarningTrigger) {
    this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
    return this;
  }

  /**
   * Current state of [Safe Browsing protection
   * level](https://chromeenterprise.google/policies/#SafeBrowsingProtectionLevel).
   * @return value or {@code null} for none
   */
  public java.lang.String getSafeBrowsingProtectionLevel() {
    return safeBrowsingProtectionLevel;
  }

  /**
   * Current state of [Safe Browsing protection
   * level](https://chromeenterprise.google/policies/#SafeBrowsingProtectionLevel).
   * @param safeBrowsingProtectionLevel safeBrowsingProtectionLevel or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1BrowserInfo setSafeBrowsingProtectionLevel(java.lang.String safeBrowsingProtectionLevel) {
    this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1BrowserInfo set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1BrowserInfo) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1BrowserInfo clone() {
    return (GoogleAppsCloudidentityDevicesV1BrowserInfo) super.clone();
  }

}
