/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Stores information about a certificate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1CertificateAttributes extends com.google.api.client.json.GenericJson {

  /**
   * The X.509 extension for CertificateTemplate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsCloudidentityDevicesV1CertificateTemplate certificateTemplate;

  /**
   * The encoded certificate fingerprint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The name of the issuer of this certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuer;

  /**
   * Serial number of the certificate, Example: "123456789".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serialNumber;

  /**
   * The subject name of this certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subject;

  /**
   * The certificate thumbprint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbprint;

  /**
   * Output only. Validation state of this certificate.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String validationState;

  /**
   * Certificate not valid at or after this timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String validityExpirationTime;

  /**
   * Certificate not valid before this timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String validityStartTime;

  /**
   * The X.509 extension for CertificateTemplate.
   * @return value or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateTemplate getCertificateTemplate() {
    return certificateTemplate;
  }

  /**
   * The X.509 extension for CertificateTemplate.
   * @param certificateTemplate certificateTemplate or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setCertificateTemplate(GoogleAppsCloudidentityDevicesV1CertificateTemplate certificateTemplate) {
    this.certificateTemplate = certificateTemplate;
    return this;
  }

  /**
   * The encoded certificate fingerprint.
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * The encoded certificate fingerprint.
   * @param fingerprint fingerprint or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * The name of the issuer of this certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuer() {
    return issuer;
  }

  /**
   * The name of the issuer of this certificate.
   * @param issuer issuer or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setIssuer(java.lang.String issuer) {
    this.issuer = issuer;
    return this;
  }

  /**
   * Serial number of the certificate, Example: "123456789".
   * @return value or {@code null} for none
   */
  public java.lang.String getSerialNumber() {
    return serialNumber;
  }

  /**
   * Serial number of the certificate, Example: "123456789".
   * @param serialNumber serialNumber or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setSerialNumber(java.lang.String serialNumber) {
    this.serialNumber = serialNumber;
    return this;
  }

  /**
   * The subject name of this certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubject() {
    return subject;
  }

  /**
   * The subject name of this certificate.
   * @param subject subject or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setSubject(java.lang.String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * The certificate thumbprint.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbprint() {
    return thumbprint;
  }

  /**
   * The certificate thumbprint.
   * @param thumbprint thumbprint or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setThumbprint(java.lang.String thumbprint) {
    this.thumbprint = thumbprint;
    return this;
  }

  /**
   * Output only. Validation state of this certificate.
   * @return value or {@code null} for none
   */
  public java.lang.String getValidationState() {
    return validationState;
  }

  /**
   * Output only. Validation state of this certificate.
   * @param validationState validationState or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setValidationState(java.lang.String validationState) {
    this.validationState = validationState;
    return this;
  }

  /**
   * Certificate not valid at or after this timestamp.
   * @return value or {@code null} for none
   */
  public String getValidityExpirationTime() {
    return validityExpirationTime;
  }

  /**
   * Certificate not valid at or after this timestamp.
   * @param validityExpirationTime validityExpirationTime or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setValidityExpirationTime(String validityExpirationTime) {
    this.validityExpirationTime = validityExpirationTime;
    return this;
  }

  /**
   * Certificate not valid before this timestamp.
   * @return value or {@code null} for none
   */
  public String getValidityStartTime() {
    return validityStartTime;
  }

  /**
   * Certificate not valid before this timestamp.
   * @param validityStartTime validityStartTime or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes setValidityStartTime(String validityStartTime) {
    this.validityStartTime = validityStartTime;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1CertificateAttributes) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1CertificateAttributes clone() {
    return (GoogleAppsCloudidentityDevicesV1CertificateAttributes) super.clone();
  }

}
