/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * CertificateTemplate (v3 Extension in X.509).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1CertificateTemplate extends com.google.api.client.json.GenericJson {

  /**
   * The template id of the template. Example:
   * "1.3.6.1.4.1.311.21.8.15608621.11768144.5720724.16068415.6889630.81.2472537.7784047".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The Major version of the template. Example: 100.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer majorVersion;

  /**
   * The minor version of the template. Example: 12.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minorVersion;

  /**
   * The template id of the template. Example:
   * "1.3.6.1.4.1.311.21.8.15608621.11768144.5720724.16068415.6889630.81.2472537.7784047".
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The template id of the template. Example:
   * "1.3.6.1.4.1.311.21.8.15608621.11768144.5720724.16068415.6889630.81.2472537.7784047".
   * @param id id or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateTemplate setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The Major version of the template. Example: 100.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMajorVersion() {
    return majorVersion;
  }

  /**
   * The Major version of the template. Example: 100.
   * @param majorVersion majorVersion or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateTemplate setMajorVersion(java.lang.Integer majorVersion) {
    this.majorVersion = majorVersion;
    return this;
  }

  /**
   * The minor version of the template. Example: 12.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinorVersion() {
    return minorVersion;
  }

  /**
   * The minor version of the template. Example: 12.
   * @param minorVersion minorVersion or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1CertificateTemplate setMinorVersion(java.lang.Integer minorVersion) {
    this.minorVersion = minorVersion;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1CertificateTemplate set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1CertificateTemplate) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1CertificateTemplate clone() {
    return (GoogleAppsCloudidentityDevicesV1CertificateTemplate) super.clone();
  }

}
