/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Resource representing the [Endpoint Verification-specific
 * attributes](https://cloud.google.com/endpoint-verification/docs/device-information) of a device.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes extends com.google.api.client.json.GenericJson {

  /**
   * [Additional signals](https://cloud.google.com/endpoint-verification/docs/device-information)
   * reported by Endpoint Verification. It includes the following attributes: * Non-configurable
   * attributes: hotfixes, av_installed, av_enabled, windows_domain_name,
   * is_os_native_firewall_enabled, and is_secure_boot_enabled. * [Configurable
   * attributes](https://cloud.google.com/endpoint-verification/docs/collect-config-attributes):
   * file, folder, and binary attributes; registry entries; and properties in a plist.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> additionalSignals;

  /**
   * Details of browser profiles reported by Endpoint Verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCloudidentityDevicesV1BrowserAttributes> browserAttributes;

  static {
    // hack to force ProGuard to consider GoogleAppsCloudidentityDevicesV1BrowserAttributes used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsCloudidentityDevicesV1BrowserAttributes.class);
  }

  /**
   * Details of certificates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCloudidentityDevicesV1CertificateAttributes> certificateAttributes;

  static {
    // hack to force ProGuard to consider GoogleAppsCloudidentityDevicesV1CertificateAttributes used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsCloudidentityDevicesV1CertificateAttributes.class);
  }

  /**
   * [Additional signals](https://cloud.google.com/endpoint-verification/docs/device-information)
   * reported by Endpoint Verification. It includes the following attributes: * Non-configurable
   * attributes: hotfixes, av_installed, av_enabled, windows_domain_name,
   * is_os_native_firewall_enabled, and is_secure_boot_enabled. * [Configurable
   * attributes](https://cloud.google.com/endpoint-verification/docs/collect-config-attributes):
   * file, folder, and binary attributes; registry entries; and properties in a plist.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getAdditionalSignals() {
    return additionalSignals;
  }

  /**
   * [Additional signals](https://cloud.google.com/endpoint-verification/docs/device-information)
   * reported by Endpoint Verification. It includes the following attributes: * Non-configurable
   * attributes: hotfixes, av_installed, av_enabled, windows_domain_name,
   * is_os_native_firewall_enabled, and is_secure_boot_enabled. * [Configurable
   * attributes](https://cloud.google.com/endpoint-verification/docs/collect-config-attributes):
   * file, folder, and binary attributes; registry entries; and properties in a plist.
   * @param additionalSignals additionalSignals or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes setAdditionalSignals(java.util.Map<String, java.lang.Object> additionalSignals) {
    this.additionalSignals = additionalSignals;
    return this;
  }

  /**
   * Details of browser profiles reported by Endpoint Verification.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCloudidentityDevicesV1BrowserAttributes> getBrowserAttributes() {
    return browserAttributes;
  }

  /**
   * Details of browser profiles reported by Endpoint Verification.
   * @param browserAttributes browserAttributes or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes setBrowserAttributes(java.util.List<GoogleAppsCloudidentityDevicesV1BrowserAttributes> browserAttributes) {
    this.browserAttributes = browserAttributes;
    return this;
  }

  /**
   * Details of certificates.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCloudidentityDevicesV1CertificateAttributes> getCertificateAttributes() {
    return certificateAttributes;
  }

  /**
   * Details of certificates.
   * @param certificateAttributes certificateAttributes or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes setCertificateAttributes(java.util.List<GoogleAppsCloudidentityDevicesV1CertificateAttributes> certificateAttributes) {
    this.certificateAttributes = certificateAttributes;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes clone() {
    return (GoogleAppsCloudidentityDevicesV1EndpointVerificationSpecificAttributes) super.clone();
  }

}
