/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Response message that is returned in ListClientStates.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1ListClientStatesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Client states meeting the list restrictions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsCloudidentityDevicesV1ClientState> clientStates;

  static {
    // hack to force ProGuard to consider GoogleAppsCloudidentityDevicesV1ClientState used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsCloudidentityDevicesV1ClientState.class);
  }

  /**
   * Token to retrieve the next page of results. Empty if there are no more results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Client states meeting the list restrictions.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsCloudidentityDevicesV1ClientState> getClientStates() {
    return clientStates;
  }

  /**
   * Client states meeting the list restrictions.
   * @param clientStates clientStates or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1ListClientStatesResponse setClientStates(java.util.List<GoogleAppsCloudidentityDevicesV1ClientState> clientStates) {
    this.clientStates = clientStates;
    return this;
  }

  /**
   * Token to retrieve the next page of results. Empty if there are no more results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token to retrieve the next page of results. Empty if there are no more results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1ListClientStatesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1ListClientStatesResponse set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1ListClientStatesResponse) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1ListClientStatesResponse clone() {
    return (GoogleAppsCloudidentityDevicesV1ListClientStatesResponse) super.clone();
  }

}
