/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Response containing resource names of the DeviceUsers associated with the caller's credentials.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse extends com.google.api.client.json.GenericJson {

  /**
   * The customer resource name that may be passed back to other Devices API methods such as List,
   * Get, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customer;

  /**
   * [Resource names](https://cloud.google.com/apis/design/resource_names) of the DeviceUsers in the
   * format: `devices/{device}/deviceUsers/{user_resource}`, where device is the unique ID assigned
   * to a Device and user_resource is the unique user ID
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> names;

  /**
   * Token to retrieve the next page of results. Empty if there are no more results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The customer resource name that may be passed back to other Devices API methods such as List,
   * Get, etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomer() {
    return customer;
  }

  /**
   * The customer resource name that may be passed back to other Devices API methods such as List,
   * Get, etc.
   * @param customer customer or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse setCustomer(java.lang.String customer) {
    this.customer = customer;
    return this;
  }

  /**
   * [Resource names](https://cloud.google.com/apis/design/resource_names) of the DeviceUsers in the
   * format: `devices/{device}/deviceUsers/{user_resource}`, where device is the unique ID assigned
   * to a Device and user_resource is the unique user ID
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNames() {
    return names;
  }

  /**
   * [Resource names](https://cloud.google.com/apis/design/resource_names) of the DeviceUsers in the
   * format: `devices/{device}/deviceUsers/{user_resource}`, where device is the unique ID assigned
   * to a Device and user_resource is the unique user ID
   * @param names names or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse setNames(java.util.List<java.lang.String> names) {
    this.names = names;
    return this;
  }

  /**
   * Token to retrieve the next page of results. Empty if there are no more results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token to retrieve the next page of results. Empty if there are no more results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse clone() {
    return (GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse) super.clone();
  }

}
