/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Request message for wiping all data on the device.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsCloudidentityDevicesV1WipeDeviceRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. [Resource name](https://cloud.google.com/apis/design/resource_names) of the customer.
   * If you're using this API for your own organization, use `customers/my_customer` If you're using
   * this API to manage another organization, use `customers/{customer}`, where customer is the
   * customer to whom the device belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customer;

  /**
   * Optional. Specifies if a user is able to factory reset a device after a Device Wipe. On iOS,
   * this is called "Activation Lock", while on Android, this is known as "Factory Reset
   * Protection". If true, this protection will be removed from the device, so that a user can
   * successfully factory reset. If false, the setting is untouched on the device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean removeResetLock;

  /**
   * Optional. [Resource name](https://cloud.google.com/apis/design/resource_names) of the customer.
   * If you're using this API for your own organization, use `customers/my_customer` If you're using
   * this API to manage another organization, use `customers/{customer}`, where customer is the
   * customer to whom the device belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomer() {
    return customer;
  }

  /**
   * Optional. [Resource name](https://cloud.google.com/apis/design/resource_names) of the customer.
   * If you're using this API for your own organization, use `customers/my_customer` If you're using
   * this API to manage another organization, use `customers/{customer}`, where customer is the
   * customer to whom the device belongs.
   * @param customer customer or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1WipeDeviceRequest setCustomer(java.lang.String customer) {
    this.customer = customer;
    return this;
  }

  /**
   * Optional. Specifies if a user is able to factory reset a device after a Device Wipe. On iOS,
   * this is called "Activation Lock", while on Android, this is known as "Factory Reset
   * Protection". If true, this protection will be removed from the device, so that a user can
   * successfully factory reset. If false, the setting is untouched on the device.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRemoveResetLock() {
    return removeResetLock;
  }

  /**
   * Optional. Specifies if a user is able to factory reset a device after a Device Wipe. On iOS,
   * this is called "Activation Lock", while on Android, this is known as "Factory Reset
   * Protection". If true, this protection will be removed from the device, so that a user can
   * successfully factory reset. If false, the setting is untouched on the device.
   * @param removeResetLock removeResetLock or {@code null} for none
   */
  public GoogleAppsCloudidentityDevicesV1WipeDeviceRequest setRemoveResetLock(java.lang.Boolean removeResetLock) {
    this.removeResetLock = removeResetLock;
    return this;
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1WipeDeviceRequest set(String fieldName, Object value) {
    return (GoogleAppsCloudidentityDevicesV1WipeDeviceRequest) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsCloudidentityDevicesV1WipeDeviceRequest clone() {
    return (GoogleAppsCloudidentityDevicesV1WipeDeviceRequest) super.clone();
  }

}
