/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * A [SAML 2.0](https://www.oasis-open.org/standards#samlv2.0) federation between a Google
 * enterprise customer and a SAML identity provider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InboundSamlSsoProfile extends com.google.api.client.json.GenericJson {

  /**
   * Immutable. The customer. For example: `customers/C0123abc`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customer;

  /**
   * Human-readable name of the SAML SSO profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * SAML identity provider configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SamlIdpConfig idpConfig;

  /**
   * Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the SAML
   * SSO profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * SAML service provider configuration for this SAML SSO profile. These are the service provider
   * details provided by Google that should be configured on the corresponding identity provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SamlSpConfig spConfig;

  /**
   * Immutable. The customer. For example: `customers/C0123abc`.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomer() {
    return customer;
  }

  /**
   * Immutable. The customer. For example: `customers/C0123abc`.
   * @param customer customer or {@code null} for none
   */
  public InboundSamlSsoProfile setCustomer(java.lang.String customer) {
    this.customer = customer;
    return this;
  }

  /**
   * Human-readable name of the SAML SSO profile.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Human-readable name of the SAML SSO profile.
   * @param displayName displayName or {@code null} for none
   */
  public InboundSamlSsoProfile setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * SAML identity provider configuration.
   * @return value or {@code null} for none
   */
  public SamlIdpConfig getIdpConfig() {
    return idpConfig;
  }

  /**
   * SAML identity provider configuration.
   * @param idpConfig idpConfig or {@code null} for none
   */
  public InboundSamlSsoProfile setIdpConfig(SamlIdpConfig idpConfig) {
    this.idpConfig = idpConfig;
    return this;
  }

  /**
   * Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the SAML
   * SSO profile.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the SAML
   * SSO profile.
   * @param name name or {@code null} for none
   */
  public InboundSamlSsoProfile setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * SAML service provider configuration for this SAML SSO profile. These are the service provider
   * details provided by Google that should be configured on the corresponding identity provider.
   * @return value or {@code null} for none
   */
  public SamlSpConfig getSpConfig() {
    return spConfig;
  }

  /**
   * SAML service provider configuration for this SAML SSO profile. These are the service provider
   * details provided by Google that should be configured on the corresponding identity provider.
   * @param spConfig spConfig or {@code null} for none
   */
  public InboundSamlSsoProfile setSpConfig(SamlSpConfig spConfig) {
    this.spConfig = spConfig;
    return this;
  }

  @Override
  public InboundSamlSsoProfile set(String fieldName, Object value) {
    return (InboundSamlSsoProfile) super.set(fieldName, value);
  }

  @Override
  public InboundSamlSsoProfile clone() {
    return (InboundSamlSsoProfile) super.clone();
  }

}
