/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Targets with "set" SSO assignments and their respective assignments.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InboundSsoAssignment extends com.google.api.client.json.GenericJson {

  /**
   * Immutable. The customer. For example: `customers/C0123abc`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customer;

  /**
   * Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the
   * Inbound SSO Assignment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Must be zero (which is the default value so it can be omitted) for assignments with
   * `target_org_unit` set and must be greater-than-or-equal-to one for assignments with
   * `target_group` set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rank;

  /**
   * SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SamlSsoInfo samlSsoInfo;

  /**
   * Assertions about users assigned to an IdP will always be accepted from that IdP. This controls
   * whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended
   * configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SignInBehavior signInBehavior;

  /**
   * Inbound SSO behavior.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ssoMode;

  /**
   * Immutable. Must be of the form `groups/{group}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetGroup;

  /**
   * Immutable. Must be of the form `orgUnits/{org_unit}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetOrgUnit;

  /**
   * Immutable. The customer. For example: `customers/C0123abc`.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomer() {
    return customer;
  }

  /**
   * Immutable. The customer. For example: `customers/C0123abc`.
   * @param customer customer or {@code null} for none
   */
  public InboundSsoAssignment setCustomer(java.lang.String customer) {
    this.customer = customer;
    return this;
  }

  /**
   * Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the
   * Inbound SSO Assignment.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the
   * Inbound SSO Assignment.
   * @param name name or {@code null} for none
   */
  public InboundSsoAssignment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Must be zero (which is the default value so it can be omitted) for assignments with
   * `target_org_unit` set and must be greater-than-or-equal-to one for assignments with
   * `target_group` set.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRank() {
    return rank;
  }

  /**
   * Must be zero (which is the default value so it can be omitted) for assignments with
   * `target_org_unit` set and must be greater-than-or-equal-to one for assignments with
   * `target_group` set.
   * @param rank rank or {@code null} for none
   */
  public InboundSsoAssignment setRank(java.lang.Integer rank) {
    this.rank = rank;
    return this;
  }

  /**
   * SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
   * @return value or {@code null} for none
   */
  public SamlSsoInfo getSamlSsoInfo() {
    return samlSsoInfo;
  }

  /**
   * SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
   * @param samlSsoInfo samlSsoInfo or {@code null} for none
   */
  public InboundSsoAssignment setSamlSsoInfo(SamlSsoInfo samlSsoInfo) {
    this.samlSsoInfo = samlSsoInfo;
    return this;
  }

  /**
   * Assertions about users assigned to an IdP will always be accepted from that IdP. This controls
   * whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended
   * configuration.
   * @return value or {@code null} for none
   */
  public SignInBehavior getSignInBehavior() {
    return signInBehavior;
  }

  /**
   * Assertions about users assigned to an IdP will always be accepted from that IdP. This controls
   * whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended
   * configuration.
   * @param signInBehavior signInBehavior or {@code null} for none
   */
  public InboundSsoAssignment setSignInBehavior(SignInBehavior signInBehavior) {
    this.signInBehavior = signInBehavior;
    return this;
  }

  /**
   * Inbound SSO behavior.
   * @return value or {@code null} for none
   */
  public java.lang.String getSsoMode() {
    return ssoMode;
  }

  /**
   * Inbound SSO behavior.
   * @param ssoMode ssoMode or {@code null} for none
   */
  public InboundSsoAssignment setSsoMode(java.lang.String ssoMode) {
    this.ssoMode = ssoMode;
    return this;
  }

  /**
   * Immutable. Must be of the form `groups/{group}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetGroup() {
    return targetGroup;
  }

  /**
   * Immutable. Must be of the form `groups/{group}`.
   * @param targetGroup targetGroup or {@code null} for none
   */
  public InboundSsoAssignment setTargetGroup(java.lang.String targetGroup) {
    this.targetGroup = targetGroup;
    return this;
  }

  /**
   * Immutable. Must be of the form `orgUnits/{org_unit}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetOrgUnit() {
    return targetOrgUnit;
  }

  /**
   * Immutable. Must be of the form `orgUnits/{org_unit}`.
   * @param targetOrgUnit targetOrgUnit or {@code null} for none
   */
  public InboundSsoAssignment setTargetOrgUnit(java.lang.String targetOrgUnit) {
    this.targetOrgUnit = targetOrgUnit;
    return this;
  }

  @Override
  public InboundSsoAssignment set(String fieldName, Object value) {
    return (InboundSsoAssignment) super.set(fieldName, value);
  }

  @Override
  public InboundSsoAssignment clone() {
    return (InboundSsoAssignment) super.clone();
  }

}
