/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The response message for MembershipsService.ListMemberships.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListMembershipsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The `Membership`s under the specified `parent`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Membership> memberships;

  /**
   * A continuation token to retrieve the next page of results, or empty if there are no more
   * results available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The `Membership`s under the specified `parent`.
   * @return value or {@code null} for none
   */
  public java.util.List<Membership> getMemberships() {
    return memberships;
  }

  /**
   * The `Membership`s under the specified `parent`.
   * @param memberships memberships or {@code null} for none
   */
  public ListMembershipsResponse setMemberships(java.util.List<Membership> memberships) {
    this.memberships = memberships;
    return this;
  }

  /**
   * A continuation token to retrieve the next page of results, or empty if there are no more
   * results available.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A continuation token to retrieve the next page of results, or empty if there are no more
   * results available.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListMembershipsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListMembershipsResponse set(String fieldName, Object value) {
    return (ListMembershipsResponse) super.set(fieldName, value);
  }

  @Override
  public ListMembershipsResponse clone() {
    return (ListMembershipsResponse) super.clone();
  }

}
