/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * Message containing membership relation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MembershipRelation extends com.google.api.client.json.GenericJson {

  /**
   * An extended description to help users determine the purpose of a `Group`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The display name of the `Group`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall
   * be of the form `groups/{group_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String group;

  /**
   * The `EntityKey` of the `Group`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EntityKey groupKey;

  /**
   * One or more label entries that apply to the Group. Currently supported labels contain a key
   * with an empty value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Membership`.
   * Shall be of the form `groups/{group_id}/memberships/{membership_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String membership;

  /**
   * The `MembershipRole`s that apply to the `Membership`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MembershipRole> roles;

  /**
   * An extended description to help users determine the purpose of a `Group`.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An extended description to help users determine the purpose of a `Group`.
   * @param description description or {@code null} for none
   */
  public MembershipRelation setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The display name of the `Group`.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The display name of the `Group`.
   * @param displayName displayName or {@code null} for none
   */
  public MembershipRelation setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall
   * be of the form `groups/{group_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroup() {
    return group;
  }

  /**
   * The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall
   * be of the form `groups/{group_id}`.
   * @param group group or {@code null} for none
   */
  public MembershipRelation setGroup(java.lang.String group) {
    this.group = group;
    return this;
  }

  /**
   * The `EntityKey` of the `Group`.
   * @return value or {@code null} for none
   */
  public EntityKey getGroupKey() {
    return groupKey;
  }

  /**
   * The `EntityKey` of the `Group`.
   * @param groupKey groupKey or {@code null} for none
   */
  public MembershipRelation setGroupKey(EntityKey groupKey) {
    this.groupKey = groupKey;
    return this;
  }

  /**
   * One or more label entries that apply to the Group. Currently supported labels contain a key
   * with an empty value.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * One or more label entries that apply to the Group. Currently supported labels contain a key
   * with an empty value.
   * @param labels labels or {@code null} for none
   */
  public MembershipRelation setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Membership`.
   * Shall be of the form `groups/{group_id}/memberships/{membership_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getMembership() {
    return membership;
  }

  /**
   * The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Membership`.
   * Shall be of the form `groups/{group_id}/memberships/{membership_id}`.
   * @param membership membership or {@code null} for none
   */
  public MembershipRelation setMembership(java.lang.String membership) {
    this.membership = membership;
    return this;
  }

  /**
   * The `MembershipRole`s that apply to the `Membership`.
   * @return value or {@code null} for none
   */
  public java.util.List<MembershipRole> getRoles() {
    return roles;
  }

  /**
   * The `MembershipRole`s that apply to the `Membership`.
   * @param roles roles or {@code null} for none
   */
  public MembershipRelation setRoles(java.util.List<MembershipRole> roles) {
    this.roles = roles;
    return this;
  }

  @Override
  public MembershipRelation set(String fieldName, Object value) {
    return (MembershipRelation) super.set(fieldName, value);
  }

  @Override
  public MembershipRelation clone() {
    return (MembershipRelation) super.clone();
  }

}
