/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The request message for MembershipsService.ModifyMembershipRoles.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModifyMembershipRolesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The `MembershipRole`s to be added. Adding or removing roles in the same request as updating
   * roles is not supported. Must not be set if `update_roles_params` is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MembershipRole> addRoles;

  static {
    // hack to force ProGuard to consider MembershipRole used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MembershipRole.class);
  }

  /**
   * The `name`s of the `MembershipRole`s to be removed. Adding or removing roles in the same
   * request as updating roles is not supported. It is not possible to remove the `MEMBER`
   * `MembershipRole`. If you wish to delete a `Membership`, call
   * MembershipsService.DeleteMembership instead. Must not contain `MEMBER`. Must not be set if
   * `update_roles_params` is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> removeRoles;

  /**
   * The `MembershipRole`s to be updated. Updating roles in the same request as adding or removing
   * roles is not supported. Must not be set if either `add_roles` or `remove_roles` is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UpdateMembershipRolesParams> updateRolesParams;

  /**
   * The `MembershipRole`s to be added. Adding or removing roles in the same request as updating
   * roles is not supported. Must not be set if `update_roles_params` is set.
   * @return value or {@code null} for none
   */
  public java.util.List<MembershipRole> getAddRoles() {
    return addRoles;
  }

  /**
   * The `MembershipRole`s to be added. Adding or removing roles in the same request as updating
   * roles is not supported. Must not be set if `update_roles_params` is set.
   * @param addRoles addRoles or {@code null} for none
   */
  public ModifyMembershipRolesRequest setAddRoles(java.util.List<MembershipRole> addRoles) {
    this.addRoles = addRoles;
    return this;
  }

  /**
   * The `name`s of the `MembershipRole`s to be removed. Adding or removing roles in the same
   * request as updating roles is not supported. It is not possible to remove the `MEMBER`
   * `MembershipRole`. If you wish to delete a `Membership`, call
   * MembershipsService.DeleteMembership instead. Must not contain `MEMBER`. Must not be set if
   * `update_roles_params` is set.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRemoveRoles() {
    return removeRoles;
  }

  /**
   * The `name`s of the `MembershipRole`s to be removed. Adding or removing roles in the same
   * request as updating roles is not supported. It is not possible to remove the `MEMBER`
   * `MembershipRole`. If you wish to delete a `Membership`, call
   * MembershipsService.DeleteMembership instead. Must not contain `MEMBER`. Must not be set if
   * `update_roles_params` is set.
   * @param removeRoles removeRoles or {@code null} for none
   */
  public ModifyMembershipRolesRequest setRemoveRoles(java.util.List<java.lang.String> removeRoles) {
    this.removeRoles = removeRoles;
    return this;
  }

  /**
   * The `MembershipRole`s to be updated. Updating roles in the same request as adding or removing
   * roles is not supported. Must not be set if either `add_roles` or `remove_roles` is set.
   * @return value or {@code null} for none
   */
  public java.util.List<UpdateMembershipRolesParams> getUpdateRolesParams() {
    return updateRolesParams;
  }

  /**
   * The `MembershipRole`s to be updated. Updating roles in the same request as adding or removing
   * roles is not supported. Must not be set if either `add_roles` or `remove_roles` is set.
   * @param updateRolesParams updateRolesParams or {@code null} for none
   */
  public ModifyMembershipRolesRequest setUpdateRolesParams(java.util.List<UpdateMembershipRolesParams> updateRolesParams) {
    this.updateRolesParams = updateRolesParams;
    return this;
  }

  @Override
  public ModifyMembershipRolesRequest set(String fieldName, Object value) {
    return (ModifyMembershipRolesRequest) super.set(fieldName, value);
  }

  @Override
  public ModifyMembershipRolesRequest clone() {
    return (ModifyMembershipRolesRequest) super.clone();
  }

}
