/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * SAML IDP (identity provider) configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SamlIdpConfig extends com.google.api.client.json.GenericJson {

  /**
   * The **Change Password URL** of the identity provider. Users will be sent to this URL when
   * changing their passwords at `myaccount.google.com`. This takes precedence over the change
   * password URL configured at customer-level. Must use `HTTPS`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String changePasswordUri;

  /**
   * Required. The SAML **Entity ID** of the identity provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String entityId;

  /**
   * The **Logout Redirect URL** (sign-out page URL) of the identity provider. When a user clicks
   * the sign-out link on a Google page, they will be redirected to this URL. This is a pure
   * redirect with no attached SAML `LogoutRequest` i.e. SAML single logout is not supported. Must
   * use `HTTPS`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String logoutRedirectUri;

  /**
   * Required. The `SingleSignOnService` endpoint location (sign-in page URL) of the identity
   * provider. This is the URL where the `AuthnRequest` will be sent. Must use `HTTPS`. Assumed to
   * accept the `HTTP-Redirect` binding.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String singleSignOnServiceUri;

  /**
   * The **Change Password URL** of the identity provider. Users will be sent to this URL when
   * changing their passwords at `myaccount.google.com`. This takes precedence over the change
   * password URL configured at customer-level. Must use `HTTPS`.
   * @return value or {@code null} for none
   */
  public java.lang.String getChangePasswordUri() {
    return changePasswordUri;
  }

  /**
   * The **Change Password URL** of the identity provider. Users will be sent to this URL when
   * changing their passwords at `myaccount.google.com`. This takes precedence over the change
   * password URL configured at customer-level. Must use `HTTPS`.
   * @param changePasswordUri changePasswordUri or {@code null} for none
   */
  public SamlIdpConfig setChangePasswordUri(java.lang.String changePasswordUri) {
    this.changePasswordUri = changePasswordUri;
    return this;
  }

  /**
   * Required. The SAML **Entity ID** of the identity provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getEntityId() {
    return entityId;
  }

  /**
   * Required. The SAML **Entity ID** of the identity provider.
   * @param entityId entityId or {@code null} for none
   */
  public SamlIdpConfig setEntityId(java.lang.String entityId) {
    this.entityId = entityId;
    return this;
  }

  /**
   * The **Logout Redirect URL** (sign-out page URL) of the identity provider. When a user clicks
   * the sign-out link on a Google page, they will be redirected to this URL. This is a pure
   * redirect with no attached SAML `LogoutRequest` i.e. SAML single logout is not supported. Must
   * use `HTTPS`.
   * @return value or {@code null} for none
   */
  public java.lang.String getLogoutRedirectUri() {
    return logoutRedirectUri;
  }

  /**
   * The **Logout Redirect URL** (sign-out page URL) of the identity provider. When a user clicks
   * the sign-out link on a Google page, they will be redirected to this URL. This is a pure
   * redirect with no attached SAML `LogoutRequest` i.e. SAML single logout is not supported. Must
   * use `HTTPS`.
   * @param logoutRedirectUri logoutRedirectUri or {@code null} for none
   */
  public SamlIdpConfig setLogoutRedirectUri(java.lang.String logoutRedirectUri) {
    this.logoutRedirectUri = logoutRedirectUri;
    return this;
  }

  /**
   * Required. The `SingleSignOnService` endpoint location (sign-in page URL) of the identity
   * provider. This is the URL where the `AuthnRequest` will be sent. Must use `HTTPS`. Assumed to
   * accept the `HTTP-Redirect` binding.
   * @return value or {@code null} for none
   */
  public java.lang.String getSingleSignOnServiceUri() {
    return singleSignOnServiceUri;
  }

  /**
   * Required. The `SingleSignOnService` endpoint location (sign-in page URL) of the identity
   * provider. This is the URL where the `AuthnRequest` will be sent. Must use `HTTPS`. Assumed to
   * accept the `HTTP-Redirect` binding.
   * @param singleSignOnServiceUri singleSignOnServiceUri or {@code null} for none
   */
  public SamlIdpConfig setSingleSignOnServiceUri(java.lang.String singleSignOnServiceUri) {
    this.singleSignOnServiceUri = singleSignOnServiceUri;
    return this;
  }

  @Override
  public SamlIdpConfig set(String fieldName, Object value) {
    return (SamlIdpConfig) super.set(fieldName, value);
  }

  @Override
  public SamlIdpConfig clone() {
    return (SamlIdpConfig) super.clone();
  }

}
