/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The definition of security settings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecuritySettings extends com.google.api.client.json.GenericJson {

  /**
   * The Member Restriction value
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MemberRestriction memberRestriction;

  /**
   * Output only. The resource name of the security settings. Shall be of the form
   * `groups/{group_id}/securitySettings`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The Member Restriction value
   * @return value or {@code null} for none
   */
  public MemberRestriction getMemberRestriction() {
    return memberRestriction;
  }

  /**
   * The Member Restriction value
   * @param memberRestriction memberRestriction or {@code null} for none
   */
  public SecuritySettings setMemberRestriction(MemberRestriction memberRestriction) {
    this.memberRestriction = memberRestriction;
    return this;
  }

  /**
   * Output only. The resource name of the security settings. Shall be of the form
   * `groups/{group_id}/securitySettings`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the security settings. Shall be of the form
   * `groups/{group_id}/securitySettings`.
   * @param name name or {@code null} for none
   */
  public SecuritySettings setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public SecuritySettings set(String fieldName, Object value) {
    return (SecuritySettings) super.set(fieldName, value);
  }

  @Override
  public SecuritySettings clone() {
    return (SecuritySettings) super.clone();
  }

}
