/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudidentity.v1.model;

/**
 * The `UserInvitation` resource represents an email that can be sent to an unmanaged user account
 * inviting them to join the customer's Google Workspace or Cloud Identity account. An unmanaged
 * account shares an email address domain with the Google Workspace or Cloud Identity account but is
 * not managed by it yet. If the user accepts the `UserInvitation`, the user account will become
 * managed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Identity API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserInvitation extends com.google.api.client.json.GenericJson {

  /**
   * Number of invitation emails sent to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long mailsSentCount;

  /**
   * Shall be of the form `customers/{customer}/userinvitations/{user_email_address}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * State of the `UserInvitation`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Time when the `UserInvitation` was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Number of invitation emails sent to the user.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMailsSentCount() {
    return mailsSentCount;
  }

  /**
   * Number of invitation emails sent to the user.
   * @param mailsSentCount mailsSentCount or {@code null} for none
   */
  public UserInvitation setMailsSentCount(java.lang.Long mailsSentCount) {
    this.mailsSentCount = mailsSentCount;
    return this;
  }

  /**
   * Shall be of the form `customers/{customer}/userinvitations/{user_email_address}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Shall be of the form `customers/{customer}/userinvitations/{user_email_address}`.
   * @param name name or {@code null} for none
   */
  public UserInvitation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * State of the `UserInvitation`.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * State of the `UserInvitation`.
   * @param state state or {@code null} for none
   */
  public UserInvitation setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Time when the `UserInvitation` was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Time when the `UserInvitation` was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public UserInvitation setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public UserInvitation set(String fieldName, Object value) {
    return (UserInvitation) super.set(fieldName, value);
  }

  @Override
  public UserInvitation clone() {
    return (UserInvitation) super.clone();
  }

}
