/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudidentity.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudidentity.v1.CloudIdentityRequest;
import com.google.api.services.cloudidentity.v1.CloudIdentityRequestInitializer;
import com.google.api.services.cloudidentity.v1.model.AddIdpCredentialRequest;
import com.google.api.services.cloudidentity.v1.model.CancelUserInvitationRequest;
import com.google.api.services.cloudidentity.v1.model.CheckTransitiveMembershipResponse;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1ApproveDeviceUserRequest;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1BlockDeviceUserRequest;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1CancelWipeDeviceRequest;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserRequest;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1ClientState;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1Device;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1DeviceUser;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1ListClientStatesResponse;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1ListDeviceUsersResponse;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1ListDevicesResponse;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1WipeDeviceRequest;
import com.google.api.services.cloudidentity.v1.model.GoogleAppsCloudidentityDevicesV1WipeDeviceUserRequest;
import com.google.api.services.cloudidentity.v1.model.Group;
import com.google.api.services.cloudidentity.v1.model.IdpCredential;
import com.google.api.services.cloudidentity.v1.model.InboundOidcSsoProfile;
import com.google.api.services.cloudidentity.v1.model.InboundSamlSsoProfile;
import com.google.api.services.cloudidentity.v1.model.InboundSsoAssignment;
import com.google.api.services.cloudidentity.v1.model.IsInvitableUserResponse;
import com.google.api.services.cloudidentity.v1.model.ListGroupsResponse;
import com.google.api.services.cloudidentity.v1.model.ListIdpCredentialsResponse;
import com.google.api.services.cloudidentity.v1.model.ListInboundOidcSsoProfilesResponse;
import com.google.api.services.cloudidentity.v1.model.ListInboundSamlSsoProfilesResponse;
import com.google.api.services.cloudidentity.v1.model.ListInboundSsoAssignmentsResponse;
import com.google.api.services.cloudidentity.v1.model.ListMembershipsResponse;
import com.google.api.services.cloudidentity.v1.model.ListPoliciesResponse;
import com.google.api.services.cloudidentity.v1.model.ListUserInvitationsResponse;
import com.google.api.services.cloudidentity.v1.model.LookupGroupNameResponse;
import com.google.api.services.cloudidentity.v1.model.LookupMembershipNameResponse;
import com.google.api.services.cloudidentity.v1.model.Membership;
import com.google.api.services.cloudidentity.v1.model.ModifyMembershipRolesRequest;
import com.google.api.services.cloudidentity.v1.model.ModifyMembershipRolesResponse;
import com.google.api.services.cloudidentity.v1.model.Operation;
import com.google.api.services.cloudidentity.v1.model.Policy;
import com.google.api.services.cloudidentity.v1.model.SearchDirectGroupsResponse;
import com.google.api.services.cloudidentity.v1.model.SearchGroupsResponse;
import com.google.api.services.cloudidentity.v1.model.SearchTransitiveGroupsResponse;
import com.google.api.services.cloudidentity.v1.model.SearchTransitiveMembershipsResponse;
import com.google.api.services.cloudidentity.v1.model.SecuritySettings;
import com.google.api.services.cloudidentity.v1.model.SendUserInvitationRequest;
import com.google.api.services.cloudidentity.v1.model.UserInvitation;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudIdentity
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudidentity.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://cloudidentity.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudidentity.googleapis.com/";

    public CloudIdentity(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudIdentity(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Customers customers() {
        return new Customers();
    }

    public Devices devices() {
        return new Devices();
    }

    public Groups groups() {
        return new Groups();
    }

    public InboundOidcSsoProfiles inboundOidcSsoProfiles() {
        return new InboundOidcSsoProfiles();
    }

    public InboundSamlSsoProfiles inboundSamlSsoProfiles() {
        return new InboundSamlSsoProfiles();
    }

    public InboundSsoAssignments inboundSsoAssignments() {
        return new InboundSsoAssignments();
    }

    public Policies policies() {
        return new Policies();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Identity API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudIdentity.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://cloudidentity.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudIdentity.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudIdentity.DEFAULT_BATCH_PATH);
        }

        public CloudIdentity build() {
            return new CloudIdentity(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudIdentityRequestInitializer(CloudIdentityRequestInitializer cloudidentityRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudidentityRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Policies {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends CloudIdentityRequest<ListPoliciesResponse> {
            private static final String REST_PATH = "v1/policies";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudIdentity.this, "GET", REST_PATH, null, ListPoliciesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudIdentityRequest<Policy> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, Policy.class);
                this.NAME_PATTERN = Pattern.compile("^policies/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^policies/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class InboundSsoAssignments {
        public Create create(InboundSsoAssignment content) throws IOException {
            Create result = new Create(content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, InboundSsoAssignment content) throws IOException {
            Patch result = new Patch(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, InboundSsoAssignment content) {
                super(CloudIdentity.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^inboundSsoAssignments/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSsoAssignments/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSsoAssignments/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudIdentityRequest<ListInboundSsoAssignmentsResponse> {
            private static final String REST_PATH = "v1/inboundSsoAssignments";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudIdentity.this, "GET", REST_PATH, null, ListInboundSsoAssignmentsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudIdentityRequest<InboundSsoAssignment> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, InboundSsoAssignment.class);
                this.NAME_PATTERN = Pattern.compile("^inboundSsoAssignments/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSsoAssignments/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSsoAssignments/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^inboundSsoAssignments/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSsoAssignments/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSsoAssignments/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/inboundSsoAssignments";

            protected Create(InboundSsoAssignment content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class InboundSamlSsoProfiles {
        public Create create(InboundSamlSsoProfile content) throws IOException {
            Create result = new Create(content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, InboundSamlSsoProfile content) throws IOException {
            Patch result = new Patch(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public IdpCredentials idpCredentials() {
            return new IdpCredentials();
        }

        public class IdpCredentials {
            public Add add(String parent, AddIdpCredentialRequest content) throws IOException {
                Add result = new Add(parent, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudIdentityRequest<ListIdpCredentialsResponse> {
                private static final String REST_PATH = "v1/{+parent}/idpCredentials";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, ListIdpCredentialsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudIdentityRequest<IdpCredential> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, IdpCredential.class);
                    this.NAME_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+/idpCredentials/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+/idpCredentials/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+/idpCredentials/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+/idpCredentials/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+/idpCredentials/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+/idpCredentials/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Add
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/idpCredentials:add";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Add(String parent, AddIdpCredentialRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                    }
                }

                public Add set$Xgafv(String $Xgafv) {
                    return (Add)super.set$Xgafv($Xgafv);
                }

                public Add setAccessToken(String accessToken) {
                    return (Add)super.setAccessToken(accessToken);
                }

                public Add setAlt(String alt) {
                    return (Add)super.setAlt(alt);
                }

                public Add setCallback(String callback) {
                    return (Add)super.setCallback(callback);
                }

                public Add setFields(String fields) {
                    return (Add)super.setFields(fields);
                }

                public Add setKey(String key) {
                    return (Add)super.setKey(key);
                }

                public Add setOauthToken(String oauthToken) {
                    return (Add)super.setOauthToken(oauthToken);
                }

                public Add setPrettyPrint(Boolean prettyPrint) {
                    return (Add)super.setPrettyPrint(prettyPrint);
                }

                public Add setQuotaUser(String quotaUser) {
                    return (Add)super.setQuotaUser(quotaUser);
                }

                public Add setUploadType(String uploadType) {
                    return (Add)super.setUploadType(uploadType);
                }

                public Add setUploadProtocol(String uploadProtocol) {
                    return (Add)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Add setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Add set(String parameterName, Object value) {
                    return (Add)super.set(parameterName, value);
                }
            }
        }

        public class Patch
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, InboundSamlSsoProfile content) {
                super(CloudIdentity.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudIdentityRequest<ListInboundSamlSsoProfilesResponse> {
            private static final String REST_PATH = "v1/inboundSamlSsoProfiles";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudIdentity.this, "GET", REST_PATH, null, ListInboundSamlSsoProfilesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudIdentityRequest<InboundSamlSsoProfile> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, InboundSamlSsoProfile.class);
                this.NAME_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^inboundSamlSsoProfiles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundSamlSsoProfiles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/inboundSamlSsoProfiles";

            protected Create(InboundSamlSsoProfile content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class InboundOidcSsoProfiles {
        public Create create(InboundOidcSsoProfile content) throws IOException {
            Create result = new Create(content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, InboundOidcSsoProfile content) throws IOException {
            Patch result = new Patch(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, InboundOidcSsoProfile content) {
                super(CloudIdentity.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^inboundOidcSsoProfiles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundOidcSsoProfiles/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundOidcSsoProfiles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudIdentityRequest<ListInboundOidcSsoProfilesResponse> {
            private static final String REST_PATH = "v1/inboundOidcSsoProfiles";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudIdentity.this, "GET", REST_PATH, null, ListInboundOidcSsoProfilesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudIdentityRequest<InboundOidcSsoProfile> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, InboundOidcSsoProfile.class);
                this.NAME_PATTERN = Pattern.compile("^inboundOidcSsoProfiles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundOidcSsoProfiles/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundOidcSsoProfiles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^inboundOidcSsoProfiles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundOidcSsoProfiles/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^inboundOidcSsoProfiles/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/inboundOidcSsoProfiles";

            protected Create(InboundOidcSsoProfile content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Groups {
        public Create create(Group content) throws IOException {
            Create result = new Create(content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSecuritySettings getSecuritySettings(String name) throws IOException {
            GetSecuritySettings result = new GetSecuritySettings(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Lookup lookup() throws IOException {
            Lookup result = new Lookup();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String name, Group content) throws IOException {
            Patch result = new Patch(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search() throws IOException {
            Search result = new Search();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateSecuritySettings updateSecuritySettings(String name, SecuritySettings content) throws IOException {
            UpdateSecuritySettings result = new UpdateSecuritySettings(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Memberships memberships() {
            return new Memberships();
        }

        public class Memberships {
            public CheckTransitiveMembership checkTransitiveMembership(String parent) throws IOException {
                CheckTransitiveMembership result = new CheckTransitiveMembership(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String parent, Membership content) throws IOException {
                Create result = new Create(parent, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetMembershipGraph getMembershipGraph(String parent) throws IOException {
                GetMembershipGraph result = new GetMembershipGraph(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Lookup lookup(String parent) throws IOException {
                Lookup result = new Lookup(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ModifyMembershipRoles modifyMembershipRoles(String name, ModifyMembershipRolesRequest content) throws IOException {
                ModifyMembershipRoles result = new ModifyMembershipRoles(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SearchDirectGroups searchDirectGroups(String parent) throws IOException {
                SearchDirectGroups result = new SearchDirectGroups(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SearchTransitiveGroups searchTransitiveGroups(String parent) throws IOException {
                SearchTransitiveGroups result = new SearchTransitiveGroups(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SearchTransitiveMemberships searchTransitiveMemberships(String parent) throws IOException {
                SearchTransitiveMemberships result = new SearchTransitiveMemberships(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class SearchTransitiveMemberships
            extends CloudIdentityRequest<SearchTransitiveMembershipsResponse> {
                private static final String REST_PATH = "v1/{+parent}/memberships:searchTransitiveMemberships";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected SearchTransitiveMemberships(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, SearchTransitiveMembershipsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public SearchTransitiveMemberships set$Xgafv(String $Xgafv) {
                    return (SearchTransitiveMemberships)super.set$Xgafv($Xgafv);
                }

                public SearchTransitiveMemberships setAccessToken(String accessToken) {
                    return (SearchTransitiveMemberships)super.setAccessToken(accessToken);
                }

                public SearchTransitiveMemberships setAlt(String alt) {
                    return (SearchTransitiveMemberships)super.setAlt(alt);
                }

                public SearchTransitiveMemberships setCallback(String callback) {
                    return (SearchTransitiveMemberships)super.setCallback(callback);
                }

                public SearchTransitiveMemberships setFields(String fields) {
                    return (SearchTransitiveMemberships)super.setFields(fields);
                }

                public SearchTransitiveMemberships setKey(String key) {
                    return (SearchTransitiveMemberships)super.setKey(key);
                }

                public SearchTransitiveMemberships setOauthToken(String oauthToken) {
                    return (SearchTransitiveMemberships)super.setOauthToken(oauthToken);
                }

                public SearchTransitiveMemberships setPrettyPrint(Boolean prettyPrint) {
                    return (SearchTransitiveMemberships)super.setPrettyPrint(prettyPrint);
                }

                public SearchTransitiveMemberships setQuotaUser(String quotaUser) {
                    return (SearchTransitiveMemberships)super.setQuotaUser(quotaUser);
                }

                public SearchTransitiveMemberships setUploadType(String uploadType) {
                    return (SearchTransitiveMemberships)super.setUploadType(uploadType);
                }

                public SearchTransitiveMemberships setUploadProtocol(String uploadProtocol) {
                    return (SearchTransitiveMemberships)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public SearchTransitiveMemberships setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public SearchTransitiveMemberships setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public SearchTransitiveMemberships setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public SearchTransitiveMemberships set(String parameterName, Object value) {
                    return (SearchTransitiveMemberships)super.set(parameterName, value);
                }
            }

            public class SearchTransitiveGroups
            extends CloudIdentityRequest<SearchTransitiveGroupsResponse> {
                private static final String REST_PATH = "v1/{+parent}/memberships:searchTransitiveGroups";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String query;

                protected SearchTransitiveGroups(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, SearchTransitiveGroupsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public SearchTransitiveGroups set$Xgafv(String $Xgafv) {
                    return (SearchTransitiveGroups)super.set$Xgafv($Xgafv);
                }

                public SearchTransitiveGroups setAccessToken(String accessToken) {
                    return (SearchTransitiveGroups)super.setAccessToken(accessToken);
                }

                public SearchTransitiveGroups setAlt(String alt) {
                    return (SearchTransitiveGroups)super.setAlt(alt);
                }

                public SearchTransitiveGroups setCallback(String callback) {
                    return (SearchTransitiveGroups)super.setCallback(callback);
                }

                public SearchTransitiveGroups setFields(String fields) {
                    return (SearchTransitiveGroups)super.setFields(fields);
                }

                public SearchTransitiveGroups setKey(String key) {
                    return (SearchTransitiveGroups)super.setKey(key);
                }

                public SearchTransitiveGroups setOauthToken(String oauthToken) {
                    return (SearchTransitiveGroups)super.setOauthToken(oauthToken);
                }

                public SearchTransitiveGroups setPrettyPrint(Boolean prettyPrint) {
                    return (SearchTransitiveGroups)super.setPrettyPrint(prettyPrint);
                }

                public SearchTransitiveGroups setQuotaUser(String quotaUser) {
                    return (SearchTransitiveGroups)super.setQuotaUser(quotaUser);
                }

                public SearchTransitiveGroups setUploadType(String uploadType) {
                    return (SearchTransitiveGroups)super.setUploadType(uploadType);
                }

                public SearchTransitiveGroups setUploadProtocol(String uploadProtocol) {
                    return (SearchTransitiveGroups)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public SearchTransitiveGroups setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public SearchTransitiveGroups setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public SearchTransitiveGroups setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public SearchTransitiveGroups setQuery(String query) {
                    this.query = query;
                    return this;
                }

                @Override
                public SearchTransitiveGroups set(String parameterName, Object value) {
                    return (SearchTransitiveGroups)super.set(parameterName, value);
                }
            }

            public class SearchDirectGroups
            extends CloudIdentityRequest<SearchDirectGroupsResponse> {
                private static final String REST_PATH = "v1/{+parent}/memberships:searchDirectGroups";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String query;

                protected SearchDirectGroups(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, SearchDirectGroupsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public SearchDirectGroups set$Xgafv(String $Xgafv) {
                    return (SearchDirectGroups)super.set$Xgafv($Xgafv);
                }

                public SearchDirectGroups setAccessToken(String accessToken) {
                    return (SearchDirectGroups)super.setAccessToken(accessToken);
                }

                public SearchDirectGroups setAlt(String alt) {
                    return (SearchDirectGroups)super.setAlt(alt);
                }

                public SearchDirectGroups setCallback(String callback) {
                    return (SearchDirectGroups)super.setCallback(callback);
                }

                public SearchDirectGroups setFields(String fields) {
                    return (SearchDirectGroups)super.setFields(fields);
                }

                public SearchDirectGroups setKey(String key) {
                    return (SearchDirectGroups)super.setKey(key);
                }

                public SearchDirectGroups setOauthToken(String oauthToken) {
                    return (SearchDirectGroups)super.setOauthToken(oauthToken);
                }

                public SearchDirectGroups setPrettyPrint(Boolean prettyPrint) {
                    return (SearchDirectGroups)super.setPrettyPrint(prettyPrint);
                }

                public SearchDirectGroups setQuotaUser(String quotaUser) {
                    return (SearchDirectGroups)super.setQuotaUser(quotaUser);
                }

                public SearchDirectGroups setUploadType(String uploadType) {
                    return (SearchDirectGroups)super.setUploadType(uploadType);
                }

                public SearchDirectGroups setUploadProtocol(String uploadProtocol) {
                    return (SearchDirectGroups)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public SearchDirectGroups setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public SearchDirectGroups setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public SearchDirectGroups setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public SearchDirectGroups setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public SearchDirectGroups setQuery(String query) {
                    this.query = query;
                    return this;
                }

                @Override
                public SearchDirectGroups set(String parameterName, Object value) {
                    return (SearchDirectGroups)super.set(parameterName, value);
                }
            }

            public class ModifyMembershipRoles
            extends CloudIdentityRequest<ModifyMembershipRolesResponse> {
                private static final String REST_PATH = "v1/{+name}:modifyMembershipRoles";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected ModifyMembershipRoles(String name, ModifyMembershipRolesRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, ModifyMembershipRolesResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^groups/[^/]+/memberships/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/memberships/[^/]+$");
                    }
                }

                public ModifyMembershipRoles set$Xgafv(String $Xgafv) {
                    return (ModifyMembershipRoles)super.set$Xgafv($Xgafv);
                }

                public ModifyMembershipRoles setAccessToken(String accessToken) {
                    return (ModifyMembershipRoles)super.setAccessToken(accessToken);
                }

                public ModifyMembershipRoles setAlt(String alt) {
                    return (ModifyMembershipRoles)super.setAlt(alt);
                }

                public ModifyMembershipRoles setCallback(String callback) {
                    return (ModifyMembershipRoles)super.setCallback(callback);
                }

                public ModifyMembershipRoles setFields(String fields) {
                    return (ModifyMembershipRoles)super.setFields(fields);
                }

                public ModifyMembershipRoles setKey(String key) {
                    return (ModifyMembershipRoles)super.setKey(key);
                }

                public ModifyMembershipRoles setOauthToken(String oauthToken) {
                    return (ModifyMembershipRoles)super.setOauthToken(oauthToken);
                }

                public ModifyMembershipRoles setPrettyPrint(Boolean prettyPrint) {
                    return (ModifyMembershipRoles)super.setPrettyPrint(prettyPrint);
                }

                public ModifyMembershipRoles setQuotaUser(String quotaUser) {
                    return (ModifyMembershipRoles)super.setQuotaUser(quotaUser);
                }

                public ModifyMembershipRoles setUploadType(String uploadType) {
                    return (ModifyMembershipRoles)super.setUploadType(uploadType);
                }

                public ModifyMembershipRoles setUploadProtocol(String uploadProtocol) {
                    return (ModifyMembershipRoles)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public ModifyMembershipRoles setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/memberships/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public ModifyMembershipRoles set(String parameterName, Object value) {
                    return (ModifyMembershipRoles)super.set(parameterName, value);
                }
            }

            public class Lookup
            extends CloudIdentityRequest<LookupMembershipNameResponse> {
                private static final String REST_PATH = "v1/{+parent}/memberships:lookup";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="memberKey.id")
                private String memberKeyId;
                @Key(value="memberKey.namespace")
                private String memberKeyNamespace;

                protected Lookup(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, LookupMembershipNameResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Lookup set$Xgafv(String $Xgafv) {
                    return (Lookup)super.set$Xgafv($Xgafv);
                }

                public Lookup setAccessToken(String accessToken) {
                    return (Lookup)super.setAccessToken(accessToken);
                }

                public Lookup setAlt(String alt) {
                    return (Lookup)super.setAlt(alt);
                }

                public Lookup setCallback(String callback) {
                    return (Lookup)super.setCallback(callback);
                }

                public Lookup setFields(String fields) {
                    return (Lookup)super.setFields(fields);
                }

                public Lookup setKey(String key) {
                    return (Lookup)super.setKey(key);
                }

                public Lookup setOauthToken(String oauthToken) {
                    return (Lookup)super.setOauthToken(oauthToken);
                }

                public Lookup setPrettyPrint(Boolean prettyPrint) {
                    return (Lookup)super.setPrettyPrint(prettyPrint);
                }

                public Lookup setQuotaUser(String quotaUser) {
                    return (Lookup)super.setQuotaUser(quotaUser);
                }

                public Lookup setUploadType(String uploadType) {
                    return (Lookup)super.setUploadType(uploadType);
                }

                public Lookup setUploadProtocol(String uploadProtocol) {
                    return (Lookup)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Lookup setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getMemberKeyId() {
                    return this.memberKeyId;
                }

                public Lookup setMemberKeyId(String memberKeyId) {
                    this.memberKeyId = memberKeyId;
                    return this;
                }

                public String getMemberKeyNamespace() {
                    return this.memberKeyNamespace;
                }

                public Lookup setMemberKeyNamespace(String memberKeyNamespace) {
                    this.memberKeyNamespace = memberKeyNamespace;
                    return this;
                }

                @Override
                public Lookup set(String parameterName, Object value) {
                    return (Lookup)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudIdentityRequest<ListMembershipsResponse> {
                private static final String REST_PATH = "v1/{+parent}/memberships";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected List(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, ListMembershipsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetMembershipGraph
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/memberships:getMembershipGraph";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String query;

                protected GetMembershipGraph(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetMembershipGraph set$Xgafv(String $Xgafv) {
                    return (GetMembershipGraph)super.set$Xgafv($Xgafv);
                }

                public GetMembershipGraph setAccessToken(String accessToken) {
                    return (GetMembershipGraph)super.setAccessToken(accessToken);
                }

                public GetMembershipGraph setAlt(String alt) {
                    return (GetMembershipGraph)super.setAlt(alt);
                }

                public GetMembershipGraph setCallback(String callback) {
                    return (GetMembershipGraph)super.setCallback(callback);
                }

                public GetMembershipGraph setFields(String fields) {
                    return (GetMembershipGraph)super.setFields(fields);
                }

                public GetMembershipGraph setKey(String key) {
                    return (GetMembershipGraph)super.setKey(key);
                }

                public GetMembershipGraph setOauthToken(String oauthToken) {
                    return (GetMembershipGraph)super.setOauthToken(oauthToken);
                }

                public GetMembershipGraph setPrettyPrint(Boolean prettyPrint) {
                    return (GetMembershipGraph)super.setPrettyPrint(prettyPrint);
                }

                public GetMembershipGraph setQuotaUser(String quotaUser) {
                    return (GetMembershipGraph)super.setQuotaUser(quotaUser);
                }

                public GetMembershipGraph setUploadType(String uploadType) {
                    return (GetMembershipGraph)super.setUploadType(uploadType);
                }

                public GetMembershipGraph setUploadProtocol(String uploadProtocol) {
                    return (GetMembershipGraph)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public GetMembershipGraph setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public GetMembershipGraph setQuery(String query) {
                    this.query = query;
                    return this;
                }

                @Override
                public GetMembershipGraph set(String parameterName, Object value) {
                    return (GetMembershipGraph)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudIdentityRequest<Membership> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, Membership.class);
                    this.NAME_PATTERN = Pattern.compile("^groups/[^/]+/memberships/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/memberships/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/memberships/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^groups/[^/]+/memberships/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/memberships/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/memberships/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/memberships";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, Membership content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class CheckTransitiveMembership
            extends CloudIdentityRequest<CheckTransitiveMembershipResponse> {
                private static final String REST_PATH = "v1/{+parent}/memberships:checkTransitiveMembership";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String query;

                protected CheckTransitiveMembership(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, CheckTransitiveMembershipResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^groups/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public CheckTransitiveMembership set$Xgafv(String $Xgafv) {
                    return (CheckTransitiveMembership)super.set$Xgafv($Xgafv);
                }

                public CheckTransitiveMembership setAccessToken(String accessToken) {
                    return (CheckTransitiveMembership)super.setAccessToken(accessToken);
                }

                public CheckTransitiveMembership setAlt(String alt) {
                    return (CheckTransitiveMembership)super.setAlt(alt);
                }

                public CheckTransitiveMembership setCallback(String callback) {
                    return (CheckTransitiveMembership)super.setCallback(callback);
                }

                public CheckTransitiveMembership setFields(String fields) {
                    return (CheckTransitiveMembership)super.setFields(fields);
                }

                public CheckTransitiveMembership setKey(String key) {
                    return (CheckTransitiveMembership)super.setKey(key);
                }

                public CheckTransitiveMembership setOauthToken(String oauthToken) {
                    return (CheckTransitiveMembership)super.setOauthToken(oauthToken);
                }

                public CheckTransitiveMembership setPrettyPrint(Boolean prettyPrint) {
                    return (CheckTransitiveMembership)super.setPrettyPrint(prettyPrint);
                }

                public CheckTransitiveMembership setQuotaUser(String quotaUser) {
                    return (CheckTransitiveMembership)super.setQuotaUser(quotaUser);
                }

                public CheckTransitiveMembership setUploadType(String uploadType) {
                    return (CheckTransitiveMembership)super.setUploadType(uploadType);
                }

                public CheckTransitiveMembership setUploadProtocol(String uploadProtocol) {
                    return (CheckTransitiveMembership)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public CheckTransitiveMembership setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^groups/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public CheckTransitiveMembership setQuery(String query) {
                    this.query = query;
                    return this;
                }

                @Override
                public CheckTransitiveMembership set(String parameterName, Object value) {
                    return (CheckTransitiveMembership)super.set(parameterName, value);
                }
            }
        }

        public class UpdateSecuritySettings
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateSecuritySettings(String name, SecuritySettings content) {
                super(CloudIdentity.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^groups/[^/]+/securitySettings$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/securitySettings$");
                }
            }

            public UpdateSecuritySettings set$Xgafv(String $Xgafv) {
                return (UpdateSecuritySettings)super.set$Xgafv($Xgafv);
            }

            public UpdateSecuritySettings setAccessToken(String accessToken) {
                return (UpdateSecuritySettings)super.setAccessToken(accessToken);
            }

            public UpdateSecuritySettings setAlt(String alt) {
                return (UpdateSecuritySettings)super.setAlt(alt);
            }

            public UpdateSecuritySettings setCallback(String callback) {
                return (UpdateSecuritySettings)super.setCallback(callback);
            }

            public UpdateSecuritySettings setFields(String fields) {
                return (UpdateSecuritySettings)super.setFields(fields);
            }

            public UpdateSecuritySettings setKey(String key) {
                return (UpdateSecuritySettings)super.setKey(key);
            }

            public UpdateSecuritySettings setOauthToken(String oauthToken) {
                return (UpdateSecuritySettings)super.setOauthToken(oauthToken);
            }

            public UpdateSecuritySettings setPrettyPrint(Boolean prettyPrint) {
                return (UpdateSecuritySettings)super.setPrettyPrint(prettyPrint);
            }

            public UpdateSecuritySettings setQuotaUser(String quotaUser) {
                return (UpdateSecuritySettings)super.setQuotaUser(quotaUser);
            }

            public UpdateSecuritySettings setUploadType(String uploadType) {
                return (UpdateSecuritySettings)super.setUploadType(uploadType);
            }

            public UpdateSecuritySettings setUploadProtocol(String uploadProtocol) {
                return (UpdateSecuritySettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateSecuritySettings setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/securitySettings$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateSecuritySettings setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateSecuritySettings set(String parameterName, Object value) {
                return (UpdateSecuritySettings)super.set(parameterName, value);
            }
        }

        public class Search
        extends CloudIdentityRequest<SearchGroupsResponse> {
            private static final String REST_PATH = "v1/groups:search";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String query;
            @Key
            private String view;

            protected Search() {
                super(CloudIdentity.this, "GET", REST_PATH, null, SearchGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public Search setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Search setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class Patch
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected Patch(String name, Group content) {
                super(CloudIdentity.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^groups/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Patch setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Lookup
        extends CloudIdentityRequest<LookupGroupNameResponse> {
            private static final String REST_PATH = "v1/groups:lookup";
            @Key(value="groupKey.id")
            private String groupKeyId;
            @Key(value="groupKey.namespace")
            private String groupKeyNamespace;

            protected Lookup() {
                super(CloudIdentity.this, "GET", REST_PATH, null, LookupGroupNameResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Lookup set$Xgafv(String $Xgafv) {
                return (Lookup)super.set$Xgafv($Xgafv);
            }

            public Lookup setAccessToken(String accessToken) {
                return (Lookup)super.setAccessToken(accessToken);
            }

            public Lookup setAlt(String alt) {
                return (Lookup)super.setAlt(alt);
            }

            public Lookup setCallback(String callback) {
                return (Lookup)super.setCallback(callback);
            }

            public Lookup setFields(String fields) {
                return (Lookup)super.setFields(fields);
            }

            public Lookup setKey(String key) {
                return (Lookup)super.setKey(key);
            }

            public Lookup setOauthToken(String oauthToken) {
                return (Lookup)super.setOauthToken(oauthToken);
            }

            public Lookup setPrettyPrint(Boolean prettyPrint) {
                return (Lookup)super.setPrettyPrint(prettyPrint);
            }

            public Lookup setQuotaUser(String quotaUser) {
                return (Lookup)super.setQuotaUser(quotaUser);
            }

            public Lookup setUploadType(String uploadType) {
                return (Lookup)super.setUploadType(uploadType);
            }

            public Lookup setUploadProtocol(String uploadProtocol) {
                return (Lookup)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKeyId() {
                return this.groupKeyId;
            }

            public Lookup setGroupKeyId(String groupKeyId) {
                this.groupKeyId = groupKeyId;
                return this;
            }

            public String getGroupKeyNamespace() {
                return this.groupKeyNamespace;
            }

            public Lookup setGroupKeyNamespace(String groupKeyNamespace) {
                this.groupKeyNamespace = groupKeyNamespace;
                return this;
            }

            @Override
            public Lookup set(String parameterName, Object value) {
                return (Lookup)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudIdentityRequest<ListGroupsResponse> {
            private static final String REST_PATH = "v1/groups";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String parent;
            @Key
            private String view;

            protected List() {
                super(CloudIdentity.this, "GET", REST_PATH, null, ListGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetSecuritySettings
        extends CloudIdentityRequest<SecuritySettings> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String readMask;

            protected GetSecuritySettings(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, SecuritySettings.class);
                this.NAME_PATTERN = Pattern.compile("^groups/[^/]+/securitySettings$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/securitySettings$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSecuritySettings set$Xgafv(String $Xgafv) {
                return (GetSecuritySettings)super.set$Xgafv($Xgafv);
            }

            public GetSecuritySettings setAccessToken(String accessToken) {
                return (GetSecuritySettings)super.setAccessToken(accessToken);
            }

            public GetSecuritySettings setAlt(String alt) {
                return (GetSecuritySettings)super.setAlt(alt);
            }

            public GetSecuritySettings setCallback(String callback) {
                return (GetSecuritySettings)super.setCallback(callback);
            }

            public GetSecuritySettings setFields(String fields) {
                return (GetSecuritySettings)super.setFields(fields);
            }

            public GetSecuritySettings setKey(String key) {
                return (GetSecuritySettings)super.setKey(key);
            }

            public GetSecuritySettings setOauthToken(String oauthToken) {
                return (GetSecuritySettings)super.setOauthToken(oauthToken);
            }

            public GetSecuritySettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSecuritySettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSecuritySettings setQuotaUser(String quotaUser) {
                return (GetSecuritySettings)super.setQuotaUser(quotaUser);
            }

            public GetSecuritySettings setUploadType(String uploadType) {
                return (GetSecuritySettings)super.setUploadType(uploadType);
            }

            public GetSecuritySettings setUploadProtocol(String uploadProtocol) {
                return (GetSecuritySettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetSecuritySettings setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+/securitySettings$");
                }
                this.name = name;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public GetSecuritySettings setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public GetSecuritySettings set(String parameterName, Object value) {
                return (GetSecuritySettings)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudIdentityRequest<Group> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, Group.class);
                this.NAME_PATTERN = Pattern.compile("^groups/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^groups/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^groups/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/groups";
            @Key
            private String initialGroupConfig;

            protected Create(Group content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getInitialGroupConfig() {
                return this.initialGroupConfig;
            }

            public Create setInitialGroupConfig(String initialGroupConfig) {
                this.initialGroupConfig = initialGroupConfig;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Devices {
        public CancelWipe cancelWipe(String name, GoogleAppsCloudidentityDevicesV1CancelWipeDeviceRequest content) throws IOException {
            CancelWipe result = new CancelWipe(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(GoogleAppsCloudidentityDevicesV1Device content) throws IOException {
            Create result = new Create(content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Wipe wipe(String name, GoogleAppsCloudidentityDevicesV1WipeDeviceRequest content) throws IOException {
            Wipe result = new Wipe(name, content);
            CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeviceUsers deviceUsers() {
            return new DeviceUsers();
        }

        public class DeviceUsers {
            public Approve approve(String name, GoogleAppsCloudidentityDevicesV1ApproveDeviceUserRequest content) throws IOException {
                Approve result = new Approve(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Block block(String name, GoogleAppsCloudidentityDevicesV1BlockDeviceUserRequest content) throws IOException {
                Block result = new Block(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public CancelWipe cancelWipe(String name, GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserRequest content) throws IOException {
                CancelWipe result = new CancelWipe(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Lookup lookup(String parent) throws IOException {
                Lookup result = new Lookup(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Wipe wipe(String name, GoogleAppsCloudidentityDevicesV1WipeDeviceUserRequest content) throws IOException {
                Wipe result = new Wipe(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ClientStates clientStates() {
                return new ClientStates();
            }

            public class ClientStates {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, GoogleAppsCloudidentityDevicesV1ClientState content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends CloudIdentityRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String customer;
                    @Key
                    private String updateMask;

                    protected Patch(String name, GoogleAppsCloudidentityDevicesV1ClientState content) {
                        super(CloudIdentity.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudIdentity.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudIdentity.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getCustomer() {
                        return this.customer;
                    }

                    public Patch setCustomer(String customer) {
                        this.customer = customer;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1ListClientStatesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/clientStates";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String customer;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1ListClientStatesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudIdentity.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudIdentity.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getCustomer() {
                        return this.customer;
                    }

                    public List setCustomer(String customer) {
                        this.customer = customer;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1ClientState> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String customer;

                    protected Get(String name) {
                        super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1ClientState.class);
                        this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudIdentity.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudIdentity.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getCustomer() {
                        return this.customer;
                    }

                    public Get setCustomer(String customer) {
                        this.customer = customer;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Wipe
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:wipe";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Wipe(String name, GoogleAppsCloudidentityDevicesV1WipeDeviceUserRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                }

                public Wipe set$Xgafv(String $Xgafv) {
                    return (Wipe)super.set$Xgafv($Xgafv);
                }

                public Wipe setAccessToken(String accessToken) {
                    return (Wipe)super.setAccessToken(accessToken);
                }

                public Wipe setAlt(String alt) {
                    return (Wipe)super.setAlt(alt);
                }

                public Wipe setCallback(String callback) {
                    return (Wipe)super.setCallback(callback);
                }

                public Wipe setFields(String fields) {
                    return (Wipe)super.setFields(fields);
                }

                public Wipe setKey(String key) {
                    return (Wipe)super.setKey(key);
                }

                public Wipe setOauthToken(String oauthToken) {
                    return (Wipe)super.setOauthToken(oauthToken);
                }

                public Wipe setPrettyPrint(Boolean prettyPrint) {
                    return (Wipe)super.setPrettyPrint(prettyPrint);
                }

                public Wipe setQuotaUser(String quotaUser) {
                    return (Wipe)super.setQuotaUser(quotaUser);
                }

                public Wipe setUploadType(String uploadType) {
                    return (Wipe)super.setUploadType(uploadType);
                }

                public Wipe setUploadProtocol(String uploadProtocol) {
                    return (Wipe)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Wipe setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Wipe set(String parameterName, Object value) {
                    return (Wipe)super.set(parameterName, value);
                }
            }

            public class Lookup
            extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse> {
                private static final String REST_PATH = "v1/{+parent}:lookup";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String androidId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String rawResourceId;
                @Key
                private String userId;

                protected Lookup(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1LookupSelfDeviceUsersResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^devices/[^/]+/deviceUsers$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Lookup set$Xgafv(String $Xgafv) {
                    return (Lookup)super.set$Xgafv($Xgafv);
                }

                public Lookup setAccessToken(String accessToken) {
                    return (Lookup)super.setAccessToken(accessToken);
                }

                public Lookup setAlt(String alt) {
                    return (Lookup)super.setAlt(alt);
                }

                public Lookup setCallback(String callback) {
                    return (Lookup)super.setCallback(callback);
                }

                public Lookup setFields(String fields) {
                    return (Lookup)super.setFields(fields);
                }

                public Lookup setKey(String key) {
                    return (Lookup)super.setKey(key);
                }

                public Lookup setOauthToken(String oauthToken) {
                    return (Lookup)super.setOauthToken(oauthToken);
                }

                public Lookup setPrettyPrint(Boolean prettyPrint) {
                    return (Lookup)super.setPrettyPrint(prettyPrint);
                }

                public Lookup setQuotaUser(String quotaUser) {
                    return (Lookup)super.setQuotaUser(quotaUser);
                }

                public Lookup setUploadType(String uploadType) {
                    return (Lookup)super.setUploadType(uploadType);
                }

                public Lookup setUploadProtocol(String uploadProtocol) {
                    return (Lookup)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Lookup setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^devices/[^/]+/deviceUsers$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getAndroidId() {
                    return this.androidId;
                }

                public Lookup setAndroidId(String androidId) {
                    this.androidId = androidId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public Lookup setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public Lookup setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getRawResourceId() {
                    return this.rawResourceId;
                }

                public Lookup setRawResourceId(String rawResourceId) {
                    this.rawResourceId = rawResourceId;
                    return this;
                }

                public String getUserId() {
                    return this.userId;
                }

                public Lookup setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                @Override
                public Lookup set(String parameterName, Object value) {
                    return (Lookup)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1ListDeviceUsersResponse> {
                private static final String REST_PATH = "v1/{+parent}/deviceUsers";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String customer;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1ListDeviceUsersResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^devices/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^devices/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^devices/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1DeviceUser> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String customer;

                protected Get(String name) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1DeviceUser.class);
                    this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String customer;

                protected Delete(String name) {
                    super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class CancelWipe
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:cancelWipe";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected CancelWipe(String name, GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                }

                public CancelWipe set$Xgafv(String $Xgafv) {
                    return (CancelWipe)super.set$Xgafv($Xgafv);
                }

                public CancelWipe setAccessToken(String accessToken) {
                    return (CancelWipe)super.setAccessToken(accessToken);
                }

                public CancelWipe setAlt(String alt) {
                    return (CancelWipe)super.setAlt(alt);
                }

                public CancelWipe setCallback(String callback) {
                    return (CancelWipe)super.setCallback(callback);
                }

                public CancelWipe setFields(String fields) {
                    return (CancelWipe)super.setFields(fields);
                }

                public CancelWipe setKey(String key) {
                    return (CancelWipe)super.setKey(key);
                }

                public CancelWipe setOauthToken(String oauthToken) {
                    return (CancelWipe)super.setOauthToken(oauthToken);
                }

                public CancelWipe setPrettyPrint(Boolean prettyPrint) {
                    return (CancelWipe)super.setPrettyPrint(prettyPrint);
                }

                public CancelWipe setQuotaUser(String quotaUser) {
                    return (CancelWipe)super.setQuotaUser(quotaUser);
                }

                public CancelWipe setUploadType(String uploadType) {
                    return (CancelWipe)super.setUploadType(uploadType);
                }

                public CancelWipe setUploadProtocol(String uploadProtocol) {
                    return (CancelWipe)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public CancelWipe setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public CancelWipe set(String parameterName, Object value) {
                    return (CancelWipe)super.set(parameterName, value);
                }
            }

            public class Block
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:block";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Block(String name, GoogleAppsCloudidentityDevicesV1BlockDeviceUserRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                }

                public Block set$Xgafv(String $Xgafv) {
                    return (Block)super.set$Xgafv($Xgafv);
                }

                public Block setAccessToken(String accessToken) {
                    return (Block)super.setAccessToken(accessToken);
                }

                public Block setAlt(String alt) {
                    return (Block)super.setAlt(alt);
                }

                public Block setCallback(String callback) {
                    return (Block)super.setCallback(callback);
                }

                public Block setFields(String fields) {
                    return (Block)super.setFields(fields);
                }

                public Block setKey(String key) {
                    return (Block)super.setKey(key);
                }

                public Block setOauthToken(String oauthToken) {
                    return (Block)super.setOauthToken(oauthToken);
                }

                public Block setPrettyPrint(Boolean prettyPrint) {
                    return (Block)super.setPrettyPrint(prettyPrint);
                }

                public Block setQuotaUser(String quotaUser) {
                    return (Block)super.setQuotaUser(quotaUser);
                }

                public Block setUploadType(String uploadType) {
                    return (Block)super.setUploadType(uploadType);
                }

                public Block setUploadProtocol(String uploadProtocol) {
                    return (Block)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Block setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Block set(String parameterName, Object value) {
                    return (Block)super.set(parameterName, value);
                }
            }

            public class Approve
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:approve";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Approve(String name, GoogleAppsCloudidentityDevicesV1ApproveDeviceUserRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^devices/[^/]+/deviceUsers/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                }

                public Approve set$Xgafv(String $Xgafv) {
                    return (Approve)super.set$Xgafv($Xgafv);
                }

                public Approve setAccessToken(String accessToken) {
                    return (Approve)super.setAccessToken(accessToken);
                }

                public Approve setAlt(String alt) {
                    return (Approve)super.setAlt(alt);
                }

                public Approve setCallback(String callback) {
                    return (Approve)super.setCallback(callback);
                }

                public Approve setFields(String fields) {
                    return (Approve)super.setFields(fields);
                }

                public Approve setKey(String key) {
                    return (Approve)super.setKey(key);
                }

                public Approve setOauthToken(String oauthToken) {
                    return (Approve)super.setOauthToken(oauthToken);
                }

                public Approve setPrettyPrint(Boolean prettyPrint) {
                    return (Approve)super.setPrettyPrint(prettyPrint);
                }

                public Approve setQuotaUser(String quotaUser) {
                    return (Approve)super.setQuotaUser(quotaUser);
                }

                public Approve setUploadType(String uploadType) {
                    return (Approve)super.setUploadType(uploadType);
                }

                public Approve setUploadProtocol(String uploadProtocol) {
                    return (Approve)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Approve setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+/deviceUsers/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Approve set(String parameterName, Object value) {
                    return (Approve)super.set(parameterName, value);
                }
            }
        }

        public class Wipe
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:wipe";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Wipe(String name, GoogleAppsCloudidentityDevicesV1WipeDeviceRequest content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^devices/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
            }

            public Wipe set$Xgafv(String $Xgafv) {
                return (Wipe)super.set$Xgafv($Xgafv);
            }

            public Wipe setAccessToken(String accessToken) {
                return (Wipe)super.setAccessToken(accessToken);
            }

            public Wipe setAlt(String alt) {
                return (Wipe)super.setAlt(alt);
            }

            public Wipe setCallback(String callback) {
                return (Wipe)super.setCallback(callback);
            }

            public Wipe setFields(String fields) {
                return (Wipe)super.setFields(fields);
            }

            public Wipe setKey(String key) {
                return (Wipe)super.setKey(key);
            }

            public Wipe setOauthToken(String oauthToken) {
                return (Wipe)super.setOauthToken(oauthToken);
            }

            public Wipe setPrettyPrint(Boolean prettyPrint) {
                return (Wipe)super.setPrettyPrint(prettyPrint);
            }

            public Wipe setQuotaUser(String quotaUser) {
                return (Wipe)super.setQuotaUser(quotaUser);
            }

            public Wipe setUploadType(String uploadType) {
                return (Wipe)super.setUploadType(uploadType);
            }

            public Wipe setUploadProtocol(String uploadProtocol) {
                return (Wipe)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Wipe setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Wipe set(String parameterName, Object value) {
                return (Wipe)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1ListDevicesResponse> {
            private static final String REST_PATH = "v1/devices";
            @Key
            private String customer;
            @Key
            private String filter;
            @Key
            private String orderBy;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String view;

            protected List() {
                super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1ListDevicesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudIdentityRequest<GoogleAppsCloudidentityDevicesV1Device> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String customer;

            protected Get(String name) {
                super(CloudIdentity.this, "GET", REST_PATH, null, GoogleAppsCloudidentityDevicesV1Device.class);
                this.NAME_PATTERN = Pattern.compile("^devices/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String customer;

            protected Delete(String name) {
                super(CloudIdentity.this, "DELETE", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^devices/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/devices";
            @Key
            private String customer;

            protected Create(GoogleAppsCloudidentityDevicesV1Device content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Create setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class CancelWipe
        extends CloudIdentityRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:cancelWipe";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected CancelWipe(String name, GoogleAppsCloudidentityDevicesV1CancelWipeDeviceRequest content) {
                super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^devices/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
            }

            public CancelWipe set$Xgafv(String $Xgafv) {
                return (CancelWipe)super.set$Xgafv($Xgafv);
            }

            public CancelWipe setAccessToken(String accessToken) {
                return (CancelWipe)super.setAccessToken(accessToken);
            }

            public CancelWipe setAlt(String alt) {
                return (CancelWipe)super.setAlt(alt);
            }

            public CancelWipe setCallback(String callback) {
                return (CancelWipe)super.setCallback(callback);
            }

            public CancelWipe setFields(String fields) {
                return (CancelWipe)super.setFields(fields);
            }

            public CancelWipe setKey(String key) {
                return (CancelWipe)super.setKey(key);
            }

            public CancelWipe setOauthToken(String oauthToken) {
                return (CancelWipe)super.setOauthToken(oauthToken);
            }

            public CancelWipe setPrettyPrint(Boolean prettyPrint) {
                return (CancelWipe)super.setPrettyPrint(prettyPrint);
            }

            public CancelWipe setQuotaUser(String quotaUser) {
                return (CancelWipe)super.setQuotaUser(quotaUser);
            }

            public CancelWipe setUploadType(String uploadType) {
                return (CancelWipe)super.setUploadType(uploadType);
            }

            public CancelWipe setUploadProtocol(String uploadProtocol) {
                return (CancelWipe)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public CancelWipe setName(String name) {
                if (!CloudIdentity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^devices/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public CancelWipe set(String parameterName, Object value) {
                return (CancelWipe)super.set(parameterName, value);
            }
        }
    }

    public class Customers {
        public Userinvitations userinvitations() {
            return new Userinvitations();
        }

        public class Userinvitations {
            public Cancel cancel(String name, CancelUserInvitationRequest content) throws IOException {
                Cancel result = new Cancel(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public IsInvitableUser isInvitableUser(String name) throws IOException {
                IsInvitableUser result = new IsInvitableUser(name);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Send send(String name, SendUserInvitationRequest content) throws IOException {
                Send result = new Send(name, content);
                CloudIdentity.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Send
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:send";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Send(String name, SendUserInvitationRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/userinvitations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                }

                public Send set$Xgafv(String $Xgafv) {
                    return (Send)super.set$Xgafv($Xgafv);
                }

                public Send setAccessToken(String accessToken) {
                    return (Send)super.setAccessToken(accessToken);
                }

                public Send setAlt(String alt) {
                    return (Send)super.setAlt(alt);
                }

                public Send setCallback(String callback) {
                    return (Send)super.setCallback(callback);
                }

                public Send setFields(String fields) {
                    return (Send)super.setFields(fields);
                }

                public Send setKey(String key) {
                    return (Send)super.setKey(key);
                }

                public Send setOauthToken(String oauthToken) {
                    return (Send)super.setOauthToken(oauthToken);
                }

                public Send setPrettyPrint(Boolean prettyPrint) {
                    return (Send)super.setPrettyPrint(prettyPrint);
                }

                public Send setQuotaUser(String quotaUser) {
                    return (Send)super.setQuotaUser(quotaUser);
                }

                public Send setUploadType(String uploadType) {
                    return (Send)super.setUploadType(uploadType);
                }

                public Send setUploadProtocol(String uploadProtocol) {
                    return (Send)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Send setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Send set(String parameterName, Object value) {
                    return (Send)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudIdentityRequest<ListUserInvitationsResponse> {
                private static final String REST_PATH = "v1/{+parent}/userinvitations";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private String orderBy;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, ListUserInvitationsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^customers/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class IsInvitableUser
            extends CloudIdentityRequest<IsInvitableUserResponse> {
                private static final String REST_PATH = "v1/{+name}:isInvitableUser";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected IsInvitableUser(String name) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, IsInvitableUserResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/userinvitations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public IsInvitableUser set$Xgafv(String $Xgafv) {
                    return (IsInvitableUser)super.set$Xgafv($Xgafv);
                }

                public IsInvitableUser setAccessToken(String accessToken) {
                    return (IsInvitableUser)super.setAccessToken(accessToken);
                }

                public IsInvitableUser setAlt(String alt) {
                    return (IsInvitableUser)super.setAlt(alt);
                }

                public IsInvitableUser setCallback(String callback) {
                    return (IsInvitableUser)super.setCallback(callback);
                }

                public IsInvitableUser setFields(String fields) {
                    return (IsInvitableUser)super.setFields(fields);
                }

                public IsInvitableUser setKey(String key) {
                    return (IsInvitableUser)super.setKey(key);
                }

                public IsInvitableUser setOauthToken(String oauthToken) {
                    return (IsInvitableUser)super.setOauthToken(oauthToken);
                }

                public IsInvitableUser setPrettyPrint(Boolean prettyPrint) {
                    return (IsInvitableUser)super.setPrettyPrint(prettyPrint);
                }

                public IsInvitableUser setQuotaUser(String quotaUser) {
                    return (IsInvitableUser)super.setQuotaUser(quotaUser);
                }

                public IsInvitableUser setUploadType(String uploadType) {
                    return (IsInvitableUser)super.setUploadType(uploadType);
                }

                public IsInvitableUser setUploadProtocol(String uploadProtocol) {
                    return (IsInvitableUser)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public IsInvitableUser setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public IsInvitableUser set(String parameterName, Object value) {
                    return (IsInvitableUser)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudIdentityRequest<UserInvitation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudIdentity.this, "GET", REST_PATH, null, UserInvitation.class);
                    this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/userinvitations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Cancel
            extends CloudIdentityRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:cancel";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Cancel(String name, CancelUserInvitationRequest content) {
                    super(CloudIdentity.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/userinvitations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                }

                public Cancel set$Xgafv(String $Xgafv) {
                    return (Cancel)super.set$Xgafv($Xgafv);
                }

                public Cancel setAccessToken(String accessToken) {
                    return (Cancel)super.setAccessToken(accessToken);
                }

                public Cancel setAlt(String alt) {
                    return (Cancel)super.setAlt(alt);
                }

                public Cancel setCallback(String callback) {
                    return (Cancel)super.setCallback(callback);
                }

                public Cancel setFields(String fields) {
                    return (Cancel)super.setFields(fields);
                }

                public Cancel setKey(String key) {
                    return (Cancel)super.setKey(key);
                }

                public Cancel setOauthToken(String oauthToken) {
                    return (Cancel)super.setOauthToken(oauthToken);
                }

                public Cancel setPrettyPrint(Boolean prettyPrint) {
                    return (Cancel)super.setPrettyPrint(prettyPrint);
                }

                public Cancel setQuotaUser(String quotaUser) {
                    return (Cancel)super.setQuotaUser(quotaUser);
                }

                public Cancel setUploadType(String uploadType) {
                    return (Cancel)super.setUploadType(uploadType);
                }

                public Cancel setUploadProtocol(String uploadProtocol) {
                    return (Cancel)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Cancel setName(String name) {
                    if (!CloudIdentity.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/userinvitations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Cancel set(String parameterName, Object value) {
                    return (Cancel)super.set(parameterName, value);
                }
            }
        }
    }
}

