/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1;

/**
 * Service definition for CloudKMS (v1).
 *
 * <p>
 * Manages keys and performs cryptographic operations in a central cloud service, for direct use by other cloud resources and applications.

 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/kms/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CloudKMSRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class CloudKMS extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.30.9 of the Cloud Key Management Service (KMS) API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://cloudkms.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public CloudKMS(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  CloudKMS(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code CloudKMS cloudkms = new CloudKMS(...);}
   *   {@code CloudKMS.Projects.List request = cloudkms.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code CloudKMS cloudkms = new CloudKMS(...);}
     *   {@code CloudKMS.Locations.List request = cloudkms.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Gets information about a location.
       *
       * Create a request for the method "locations.get".
       *
       * This request holds the parameters needed by the cloudkms server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Resource name for the location.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Location> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Gets information about a location.
         *
         * Create a request for the method "locations.get".
         *
         * This request holds the parameters needed by the the cloudkms server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name for the location.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name for the location. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name for the location.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name for the location. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists information about the supported locations for this service.
       *
       * Create a request for the method "locations.list".
       *
       * This request holds the parameters needed by the cloudkms server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The resource that owns the locations collection, if applicable.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ListLocationsResponse> {

        private static final String REST_PATH = "v1/{+name}/locations";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists information about the supported locations for this service.
         *
         * Create a request for the method "locations.list".
         *
         * This request holds the parameters needed by the the cloudkms server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource that owns the locations collection, if applicable.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.ListLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource that owns the locations collection, if applicable. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource that owns the locations collection, if applicable.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource that owns the locations collection, if applicable. */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** The standard list filter. */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** The standard list filter.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /** The standard list filter. */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /** The standard list page size. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The standard list page size.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The standard list page size. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /** The standard list page token. */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The standard list page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /** The standard list page token. */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the KeyRings collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code CloudKMS cloudkms = new CloudKMS(...);}
       *   {@code CloudKMS.KeyRings.List request = cloudkms.keyRings().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public KeyRings keyRings() {
        return new KeyRings();
      }

      /**
       * The "keyRings" collection of methods.
       */
      public class KeyRings {

        /**
         * Create a new KeyRing in a given Project and Location.
         *
         * Create a request for the method "keyRings.create".
         *
         * This request holds the parameters needed by the cloudkms server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The resource name of the location associated with the
        KeyRings, in the format
         *        `projects/locations`.
         * @param content the {@link com.google.api.services.cloudkms.v1.model.KeyRing}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.KeyRing content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.KeyRing> {

          private static final String REST_PATH = "v1/{+parent}/keyRings";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Create a new KeyRing in a given Project and Location.
           *
           * Create a request for the method "keyRings.create".
           *
           * This request holds the parameters needed by the the cloudkms server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The resource name of the location associated with the
        KeyRings, in the format
         *        `projects/locations`.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.KeyRing}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.KeyRing content) {
            super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.KeyRing.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the location associated with the KeyRings, in the format
           * `projects/locations`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The resource name of the location associated with the KeyRings, in the format
         `projects/locations`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The resource name of the location associated with the KeyRings, in the format
           * `projects/locations`.
           */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Required. It must be unique within a location and match the regular expression
           * `[a-zA-Z0-9_-]{1,63}`
           */
          @com.google.api.client.util.Key
          private java.lang.String keyRingId;

          /** Required. It must be unique within a location and match the regular expression
         `[a-zA-Z0-9_-]{1,63}`
           */
          public java.lang.String getKeyRingId() {
            return keyRingId;
          }

          /**
           * Required. It must be unique within a location and match the regular expression
           * `[a-zA-Z0-9_-]{1,63}`
           */
          public Create setKeyRingId(java.lang.String keyRingId) {
            this.keyRingId = keyRingId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Returns metadata for a given KeyRing.
         *
         * Create a request for the method "keyRings.get".
         *
         * This request holds the parameters needed by the cloudkms server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the KeyRing to get.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.KeyRing> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

          /**
           * Returns metadata for a given KeyRing.
           *
           * Create a request for the method "keyRings.get".
           *
           * This request holds the parameters needed by the the cloudkms server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The name of the KeyRing to get.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.KeyRing.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the KeyRing to get. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the KeyRing to get.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The name of the KeyRing to get. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
         * does not have a policy set.
         *
         * Create a request for the method "keyRings.getIamPolicy".
         *
         * This request holds the parameters needed by the cloudkms server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being requested.
        See the operation documentation for
         *        the appropriate value for this field.
         * @return the request
         */
        public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
          GetIamPolicy result = new GetIamPolicy(resource);
          initialize(result);
          return result;
        }

        public class GetIamPolicy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists
           * and does not have a policy set.
           *
           * Create a request for the method "keyRings.getIamPolicy".
           *
           * This request holds the parameters needed by the the cloudkms server.  After setting any
           * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being requested.
        See the operation documentation for
         *        the appropriate value for this field.
           * @since 1.13
           */
          protected GetIamPolicy(java.lang.String resource) {
            super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (GetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (GetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public GetIamPolicy setAlt(java.lang.String alt) {
            return (GetIamPolicy) super.setAlt(alt);
          }

          @Override
          public GetIamPolicy setCallback(java.lang.String callback) {
            return (GetIamPolicy) super.setCallback(callback);
          }

          @Override
          public GetIamPolicy setFields(java.lang.String fields) {
            return (GetIamPolicy) super.setFields(fields);
          }

          @Override
          public GetIamPolicy setKey(java.lang.String key) {
            return (GetIamPolicy) super.setKey(key);
          }

          @Override
          public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (GetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (GetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetIamPolicy setUploadType(java.lang.String uploadType) {
            return (GetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          public GetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          /**
           * Optional. The policy format version to be returned.
           *
           * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
           *
           * Requests for policies with any conditional bindings must specify version 3. Policies
           * without any conditional bindings may specify any valid value or leave the field unset.
           *
           * To learn which resources support conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          @com.google.api.client.util.Key("options.requestedPolicyVersion")
          private java.lang.Integer optionsRequestedPolicyVersion;

          /** Optional. The policy format version to be returned.

         Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.

         Requests for policies with any conditional bindings must specify version 3. Policies without any
         conditional bindings may specify any valid value or leave the field unset.

         To learn which resources support conditions in their IAM policies, see the [IAM
         documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public java.lang.Integer getOptionsRequestedPolicyVersion() {
            return optionsRequestedPolicyVersion;
          }

          /**
           * Optional. The policy format version to be returned.
           *
           * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
           *
           * Requests for policies with any conditional bindings must specify version 3. Policies
           * without any conditional bindings may specify any valid value or leave the field unset.
           *
           * To learn which resources support conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
            return this;
          }

          @Override
          public GetIamPolicy set(String parameterName, Object value) {
            return (GetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Lists KeyRings.
         *
         * Create a request for the method "keyRings.list".
         *
         * This request holds the parameters needed by the cloudkms server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The resource name of the location associated with the
        KeyRings, in the format
         *        `projects/locations`.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ListKeyRingsResponse> {

          private static final String REST_PATH = "v1/{+parent}/keyRings";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists KeyRings.
           *
           * Create a request for the method "keyRings.list".
           *
           * This request holds the parameters needed by the the cloudkms server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The resource name of the location associated with the
        KeyRings, in the format
         *        `projects/locations`.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.ListKeyRingsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The resource name of the location associated with the KeyRings, in the format
           * `projects/locations`.
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The resource name of the location associated with the KeyRings, in the format
         `projects/locations`.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The resource name of the location associated with the KeyRings, in the format
           * `projects/locations`.
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Optional. Only include resources that match the filter in the response. For more
           * information, see [Sorting and filtering list results](https://cloud.google.com/kms/docs
           * /sorting-and-filtering).
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. Only include resources that match the filter in the response. For more information, see
         [Sorting and filtering list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. Only include resources that match the filter in the response. For more
           * information, see [Sorting and filtering list results](https://cloud.google.com/kms/docs
           * /sorting-and-filtering).
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. Specify how the results should be sorted. If not specified, the results will
           * be sorted in the default order.  For more information, see [Sorting and filtering list
           * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
           */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** Optional. Specify how the results should be sorted. If not specified, the results will be sorted in
         the default order.  For more information, see [Sorting and filtering list
         results](https://cloud.google.com/kms/docs/sorting-and-filtering).
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /**
           * Optional. Specify how the results should be sorted. If not specified, the results will
           * be sorted in the default order.  For more information, see [Sorting and filtering list
           * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
           */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /**
           * Optional. Optional limit on the number of KeyRings to include in the response.  Further
           * KeyRings can subsequently be obtained by including the
           * ListKeyRingsResponse.next_page_token in a subsequent request.  If unspecified, the
           * server will pick an appropriate default.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. Optional limit on the number of KeyRings to include in the response.  Further KeyRings
         can subsequently be obtained by including the ListKeyRingsResponse.next_page_token in a subsequent
         request.  If unspecified, the server will pick an appropriate default.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * Optional. Optional limit on the number of KeyRings to include in the response.  Further
           * KeyRings can subsequently be obtained by including the
           * ListKeyRingsResponse.next_page_token in a subsequent request.  If unspecified, the
           * server will pick an appropriate default.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. Optional pagination token, returned earlier via
           * ListKeyRingsResponse.next_page_token.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. Optional pagination token, returned earlier via ListKeyRingsResponse.next_page_token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. Optional pagination token, returned earlier via
           * ListKeyRingsResponse.next_page_token.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy.
         *
         * Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "keyRings.setIamPolicy".
         *
         * This request holds the parameters needed by the cloudkms server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being specified.
        See the operation documentation for
         *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest}
         * @return the request
         */
        public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
          SetIamPolicy result = new SetIamPolicy(resource, content);
          initialize(result);
          return result;
        }

        public class SetIamPolicy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy.
           *
           * Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "keyRings.setIamPolicy".
           *
           * This request holds the parameters needed by the the cloudkms server.  After setting any
           * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being specified.
        See the operation documentation for
         *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest}
           * @since 1.13
           */
          protected SetIamPolicy(java.lang.String resource, com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest content) {
            super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
          }

          @Override
          public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (SetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetIamPolicy setAlt(java.lang.String alt) {
            return (SetIamPolicy) super.setAlt(alt);
          }

          @Override
          public SetIamPolicy setCallback(java.lang.String callback) {
            return (SetIamPolicy) super.setCallback(callback);
          }

          @Override
          public SetIamPolicy setFields(java.lang.String fields) {
            return (SetIamPolicy) super.setFields(fields);
          }

          @Override
          public SetIamPolicy setKey(java.lang.String key) {
            return (SetIamPolicy) super.setKey(key);
          }

          @Override
          public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetIamPolicy setUploadType(java.lang.String uploadType) {
            return (SetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          public SetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public SetIamPolicy set(String parameterName, Object value) {
            return (SetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist,
         * this will return an empty set of permissions, not a `NOT_FOUND` error.
         *
         * Note: This operation is designed to be used for building permission-aware UIs and command-line
         * tools, not for authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "keyRings.testIamPermissions".
         *
         * This request holds the parameters needed by the cloudkms server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested.
        See the operation
         *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest}
         * @return the request
         */
        public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
          TestIamPermissions result = new TestIamPermissions(resource, content);
          initialize(result);
          return result;
        }

        public class TestIamPermissions extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse> {

          private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not
           * exist, this will return an empty set of permissions, not a `NOT_FOUND` error.
           *
           * Note: This operation is designed to be used for building permission-aware UIs and command-line
           * tools, not for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "keyRings.testIamPermissions".
           *
           * This request holds the parameters needed by the the cloudkms server.  After setting any
           * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
           * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested.
        See the operation
         *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest}
           * @since 1.13
           */
          protected TestIamPermissions(java.lang.String resource, com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest content) {
            super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
          }

          @Override
          public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
            return (TestIamPermissions) super.set$Xgafv($Xgafv);
          }

          @Override
          public TestIamPermissions setAccessToken(java.lang.String accessToken) {
            return (TestIamPermissions) super.setAccessToken(accessToken);
          }

          @Override
          public TestIamPermissions setAlt(java.lang.String alt) {
            return (TestIamPermissions) super.setAlt(alt);
          }

          @Override
          public TestIamPermissions setCallback(java.lang.String callback) {
            return (TestIamPermissions) super.setCallback(callback);
          }

          @Override
          public TestIamPermissions setFields(java.lang.String fields) {
            return (TestIamPermissions) super.setFields(fields);
          }

          @Override
          public TestIamPermissions setKey(java.lang.String key) {
            return (TestIamPermissions) super.setKey(key);
          }

          @Override
          public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
            return (TestIamPermissions) super.setOauthToken(oauthToken);
          }

          @Override
          public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
            return (TestIamPermissions) super.setQuotaUser(quotaUser);
          }

          @Override
          public TestIamPermissions setUploadType(java.lang.String uploadType) {
            return (TestIamPermissions) super.setUploadType(uploadType);
          }

          @Override
          public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
            return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy detail is being requested. See the operation
         documentation for the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          public TestIamPermissions setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public TestIamPermissions set(String parameterName, Object value) {
            return (TestIamPermissions) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the CryptoKeys collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code CloudKMS cloudkms = new CloudKMS(...);}
         *   {@code CloudKMS.CryptoKeys.List request = cloudkms.cryptoKeys().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public CryptoKeys cryptoKeys() {
          return new CryptoKeys();
        }

        /**
         * The "cryptoKeys" collection of methods.
         */
        public class CryptoKeys {

          /**
           * Create a new CryptoKey within a KeyRing.
           *
           * CryptoKey.purpose and CryptoKey.version_template.algorithm are required.
           *
           * Create a request for the method "cryptoKeys.create".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The name of the KeyRing associated with the
          CryptoKeys.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKey}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.CryptoKey content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKey> {

            private static final String REST_PATH = "v1/{+parent}/cryptoKeys";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

            /**
             * Create a new CryptoKey within a KeyRing.
             *
             * CryptoKey.purpose and CryptoKey.version_template.algorithm are required.
             *
             * Create a request for the method "cryptoKeys.create".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The name of the KeyRing associated with the
          CryptoKeys.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKey}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.CryptoKey content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKey.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The name of the KeyRing associated with the CryptoKeys.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The name of the KeyRing associated with the CryptoKeys.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. The name of the KeyRing associated with the CryptoKeys.
             */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Required. It must be unique within a KeyRing and match the regular expression
             * `[a-zA-Z0-9_-]{1,63}`
             */
            @com.google.api.client.util.Key
            private java.lang.String cryptoKeyId;

            /** Required. It must be unique within a KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
             */
            public java.lang.String getCryptoKeyId() {
              return cryptoKeyId;
            }

            /**
             * Required. It must be unique within a KeyRing and match the regular expression
             * `[a-zA-Z0-9_-]{1,63}`
             */
            public Create setCryptoKeyId(java.lang.String cryptoKeyId) {
              this.cryptoKeyId = cryptoKeyId;
              return this;
            }

            /**
             * If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
             * You must manually call CreateCryptoKeyVersion or ImportCryptoKeyVersion before you
             * can use this CryptoKey.
             */
            @com.google.api.client.util.Key
            private java.lang.Boolean skipInitialVersionCreation;

            /** If set to true, the request will create a CryptoKey without any CryptoKeyVersions. You must
           manually call CreateCryptoKeyVersion or ImportCryptoKeyVersion before you can use this CryptoKey.
             */
            public java.lang.Boolean getSkipInitialVersionCreation() {
              return skipInitialVersionCreation;
            }

            /**
             * If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
             * You must manually call CreateCryptoKeyVersion or ImportCryptoKeyVersion before you
             * can use this CryptoKey.
             */
            public Create setSkipInitialVersionCreation(java.lang.Boolean skipInitialVersionCreation) {
              this.skipInitialVersionCreation = skipInitialVersionCreation;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Decrypts data that was protected by Encrypt. The CryptoKey.purpose must be ENCRYPT_DECRYPT.
           *
           * Create a request for the method "cryptoKeys.decrypt".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Decrypt#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the CryptoKey to use for decryption.
          The server will choose the
           *        appropriate version.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.DecryptRequest}
           * @return the request
           */
          public Decrypt decrypt(java.lang.String name, com.google.api.services.cloudkms.v1.model.DecryptRequest content) throws java.io.IOException {
            Decrypt result = new Decrypt(name, content);
            initialize(result);
            return result;
          }

          public class Decrypt extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.DecryptResponse> {

            private static final String REST_PATH = "v1/{+name}:decrypt";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Decrypts data that was protected by Encrypt. The CryptoKey.purpose must be ENCRYPT_DECRYPT.
             *
             * Create a request for the method "cryptoKeys.decrypt".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Decrypt#execute()} method to invoke the remote operation.
             * <p> {@link
             * Decrypt#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the CryptoKey to use for decryption.
          The server will choose the
           *        appropriate version.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.DecryptRequest}
             * @since 1.13
             */
            protected Decrypt(java.lang.String name, com.google.api.services.cloudkms.v1.model.DecryptRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.DecryptResponse.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public Decrypt set$Xgafv(java.lang.String $Xgafv) {
              return (Decrypt) super.set$Xgafv($Xgafv);
            }

            @Override
            public Decrypt setAccessToken(java.lang.String accessToken) {
              return (Decrypt) super.setAccessToken(accessToken);
            }

            @Override
            public Decrypt setAlt(java.lang.String alt) {
              return (Decrypt) super.setAlt(alt);
            }

            @Override
            public Decrypt setCallback(java.lang.String callback) {
              return (Decrypt) super.setCallback(callback);
            }

            @Override
            public Decrypt setFields(java.lang.String fields) {
              return (Decrypt) super.setFields(fields);
            }

            @Override
            public Decrypt setKey(java.lang.String key) {
              return (Decrypt) super.setKey(key);
            }

            @Override
            public Decrypt setOauthToken(java.lang.String oauthToken) {
              return (Decrypt) super.setOauthToken(oauthToken);
            }

            @Override
            public Decrypt setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Decrypt) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Decrypt setQuotaUser(java.lang.String quotaUser) {
              return (Decrypt) super.setQuotaUser(quotaUser);
            }

            @Override
            public Decrypt setUploadType(java.lang.String uploadType) {
              return (Decrypt) super.setUploadType(uploadType);
            }

            @Override
            public Decrypt setUploadProtocol(java.lang.String uploadProtocol) {
              return (Decrypt) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the CryptoKey to use for decryption. The server will
             * choose the appropriate version.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the CryptoKey to use for decryption. The server will choose the
           appropriate version.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the CryptoKey to use for decryption. The server will
             * choose the appropriate version.
             */
            public Decrypt setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Decrypt set(String parameterName, Object value) {
              return (Decrypt) super.set(parameterName, value);
            }
          }
          /**
           * Encrypts data, so that it can only be recovered by a call to Decrypt. The CryptoKey.purpose must
           * be ENCRYPT_DECRYPT.
           *
           * Create a request for the method "cryptoKeys.encrypt".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Encrypt#execute()} method to invoke the remote operation.
           *
           * @param name Required. The resource name of the CryptoKey or CryptoKeyVersion
          to use for encryption.
          If a
           *        CryptoKey is specified, the server will use its
          primary version.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.EncryptRequest}
           * @return the request
           */
          public Encrypt encrypt(java.lang.String name, com.google.api.services.cloudkms.v1.model.EncryptRequest content) throws java.io.IOException {
            Encrypt result = new Encrypt(name, content);
            initialize(result);
            return result;
          }

          public class Encrypt extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.EncryptResponse> {

            private static final String REST_PATH = "v1/{+name}:encrypt";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.*$");

            /**
             * Encrypts data, so that it can only be recovered by a call to Decrypt. The CryptoKey.purpose
             * must be ENCRYPT_DECRYPT.
             *
             * Create a request for the method "cryptoKeys.encrypt".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Encrypt#execute()} method to invoke the remote operation.
             * <p> {@link
             * Encrypt#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the CryptoKey or CryptoKeyVersion
          to use for encryption.
          If a
           *        CryptoKey is specified, the server will use its
          primary version.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.EncryptRequest}
             * @since 1.13
             */
            protected Encrypt(java.lang.String name, com.google.api.services.cloudkms.v1.model.EncryptRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.EncryptResponse.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.*$");
              }
            }

            @Override
            public Encrypt set$Xgafv(java.lang.String $Xgafv) {
              return (Encrypt) super.set$Xgafv($Xgafv);
            }

            @Override
            public Encrypt setAccessToken(java.lang.String accessToken) {
              return (Encrypt) super.setAccessToken(accessToken);
            }

            @Override
            public Encrypt setAlt(java.lang.String alt) {
              return (Encrypt) super.setAlt(alt);
            }

            @Override
            public Encrypt setCallback(java.lang.String callback) {
              return (Encrypt) super.setCallback(callback);
            }

            @Override
            public Encrypt setFields(java.lang.String fields) {
              return (Encrypt) super.setFields(fields);
            }

            @Override
            public Encrypt setKey(java.lang.String key) {
              return (Encrypt) super.setKey(key);
            }

            @Override
            public Encrypt setOauthToken(java.lang.String oauthToken) {
              return (Encrypt) super.setOauthToken(oauthToken);
            }

            @Override
            public Encrypt setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Encrypt) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Encrypt setQuotaUser(java.lang.String quotaUser) {
              return (Encrypt) super.setQuotaUser(quotaUser);
            }

            @Override
            public Encrypt setUploadType(java.lang.String uploadType) {
              return (Encrypt) super.setUploadType(uploadType);
            }

            @Override
            public Encrypt setUploadProtocol(java.lang.String uploadProtocol) {
              return (Encrypt) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the CryptoKey or CryptoKeyVersion to use for
             * encryption.
             *
             * If a CryptoKey is specified, the server will use its primary version.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the CryptoKey or CryptoKeyVersion to use for encryption.

           If a CryptoKey is specified, the server will use its primary version.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Required. The resource name of the CryptoKey or CryptoKeyVersion to use for
             * encryption.
             *
             * If a CryptoKey is specified, the server will use its primary version.
             */
            public Encrypt setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.*$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Encrypt set(String parameterName, Object value) {
              return (Encrypt) super.set(parameterName, value);
            }
          }
          /**
           * Returns metadata for a given CryptoKey, as well as its primary CryptoKeyVersion.
           *
           * Create a request for the method "cryptoKeys.get".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name Required. The name of the CryptoKey to get.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKey> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Returns metadata for a given CryptoKey, as well as its primary CryptoKeyVersion.
             *
             * Create a request for the method "cryptoKeys.get".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The name of the CryptoKey to get.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.CryptoKey.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The name of the CryptoKey to get. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The name of the CryptoKey to get.
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The name of the CryptoKey to get. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
           * does not have a policy set.
           *
           * Create a request for the method "cryptoKeys.getIamPolicy".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being requested.
          See the operation documentation for
           *        the appropriate value for this field.
           * @return the request
           */
          public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            initialize(result);
            return result;
          }

          public class GetIamPolicy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Gets the access control policy for a resource. Returns an empty policy if the resource exists
             * and does not have a policy set.
             *
             * Create a request for the method "cryptoKeys.getIamPolicy".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being requested.
          See the operation documentation for
           *        the appropriate value for this field.
             * @since 1.13
             */
            protected GetIamPolicy(java.lang.String resource) {
              super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (GetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (GetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public GetIamPolicy setAlt(java.lang.String alt) {
              return (GetIamPolicy) super.setAlt(alt);
            }

            @Override
            public GetIamPolicy setCallback(java.lang.String callback) {
              return (GetIamPolicy) super.setCallback(callback);
            }

            @Override
            public GetIamPolicy setFields(java.lang.String fields) {
              return (GetIamPolicy) super.setFields(fields);
            }

            @Override
            public GetIamPolicy setKey(java.lang.String key) {
              return (GetIamPolicy) super.setKey(key);
            }

            @Override
            public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (GetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (GetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetIamPolicy setUploadType(java.lang.String uploadType) {
              return (GetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            public GetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            /**
             * Optional. The policy format version to be returned.
             *
             * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
             *
             * Requests for policies with any conditional bindings must specify version 3. Policies
             * without any conditional bindings may specify any valid value or leave the field
             * unset.
             *
             * To learn which resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            @com.google.api.client.util.Key("options.requestedPolicyVersion")
            private java.lang.Integer optionsRequestedPolicyVersion;

            /** Optional. The policy format version to be returned.

           Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.

           Requests for policies with any conditional bindings must specify version 3. Policies without any
           conditional bindings may specify any valid value or leave the field unset.

           To learn which resources support conditions in their IAM policies, see the [IAM
           documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public java.lang.Integer getOptionsRequestedPolicyVersion() {
              return optionsRequestedPolicyVersion;
            }

            /**
             * Optional. The policy format version to be returned.
             *
             * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
             *
             * Requests for policies with any conditional bindings must specify version 3. Policies
             * without any conditional bindings may specify any valid value or leave the field
             * unset.
             *
             * To learn which resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
              this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
              return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
              return (GetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Lists CryptoKeys.
           *
           * Create a request for the method "cryptoKeys.list".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The resource name of the KeyRing to list, in the format
          `projects/locations/keyRings`.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ListCryptoKeysResponse> {

            private static final String REST_PATH = "v1/{+parent}/cryptoKeys";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

            /**
             * Lists CryptoKeys.
             *
             * Create a request for the method "cryptoKeys.list".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The resource name of the KeyRing to list, in the format
          `projects/locations/keyRings`.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.ListCryptoKeysResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the KeyRing to list, in the format
             * `projects/locations/keyRings`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The resource name of the KeyRing to list, in the format `projects/locations/keyRings`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. The resource name of the KeyRing to list, in the format
             * `projects/locations/keyRings`.
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Optional. Only include resources that match the filter in the response. For more
             * information, see [Sorting and filtering list
             * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Optional. Only include resources that match the filter in the response. For more information, see
           [Sorting and filtering list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Optional. Only include resources that match the filter in the response. For more
             * information, see [Sorting and filtering list
             * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Optional. Specify how the results should be sorted. If not specified, the results
             * will be sorted in the default order. For more information, see [Sorting and filtering
             * list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            @com.google.api.client.util.Key
            private java.lang.String orderBy;

            /** Optional. Specify how the results should be sorted. If not specified, the results will be sorted in
           the default order. For more information, see [Sorting and filtering list
           results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public java.lang.String getOrderBy() {
              return orderBy;
            }

            /**
             * Optional. Specify how the results should be sorted. If not specified, the results
             * will be sorted in the default order. For more information, see [Sorting and filtering
             * list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public List setOrderBy(java.lang.String orderBy) {
              this.orderBy = orderBy;
              return this;
            }

            /**
             * Optional. Optional limit on the number of CryptoKeys to include in the response.
             * Further CryptoKeys can subsequently be obtained by including the
             * ListCryptoKeysResponse.next_page_token in a subsequent request.  If unspecified, the
             * server will pick an appropriate default.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Optional. Optional limit on the number of CryptoKeys to include in the response.  Further
           CryptoKeys can subsequently be obtained by including the ListCryptoKeysResponse.next_page_token in
           a subsequent request.  If unspecified, the server will pick an appropriate default.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Optional. Optional limit on the number of CryptoKeys to include in the response.
             * Further CryptoKeys can subsequently be obtained by including the
             * ListCryptoKeysResponse.next_page_token in a subsequent request.  If unspecified, the
             * server will pick an appropriate default.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * Optional. Optional pagination token, returned earlier via
             * ListCryptoKeysResponse.next_page_token.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** Optional. Optional pagination token, returned earlier via ListCryptoKeysResponse.next_page_token.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * Optional. Optional pagination token, returned earlier via
             * ListCryptoKeysResponse.next_page_token.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            /** The fields of the primary version to include in the response. */
            @com.google.api.client.util.Key
            private java.lang.String versionView;

            /** The fields of the primary version to include in the response.
             */
            public java.lang.String getVersionView() {
              return versionView;
            }

            /** The fields of the primary version to include in the response. */
            public List setVersionView(java.lang.String versionView) {
              this.versionView = versionView;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Update a CryptoKey.
           *
           * Create a request for the method "cryptoKeys.patch".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           *
           * @param name Output only. The resource name for this CryptoKey in the format
           *        `projects/locations/keyRings/cryptoKeys`.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKey}
           * @return the request
           */
          public Patch patch(java.lang.String name, com.google.api.services.cloudkms.v1.model.CryptoKey content) throws java.io.IOException {
            Patch result = new Patch(name, content);
            initialize(result);
            return result;
          }

          public class Patch extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKey> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Update a CryptoKey.
             *
             * Create a request for the method "cryptoKeys.patch".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             * <p> {@link
             * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Output only. The resource name for this CryptoKey in the format
           *        `projects/locations/keyRings/cryptoKeys`.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKey}
             * @since 1.13
             */
            protected Patch(java.lang.String name, com.google.api.services.cloudkms.v1.model.CryptoKey content) {
              super(CloudKMS.this, "PATCH", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKey.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public Patch set$Xgafv(java.lang.String $Xgafv) {
              return (Patch) super.set$Xgafv($Xgafv);
            }

            @Override
            public Patch setAccessToken(java.lang.String accessToken) {
              return (Patch) super.setAccessToken(accessToken);
            }

            @Override
            public Patch setAlt(java.lang.String alt) {
              return (Patch) super.setAlt(alt);
            }

            @Override
            public Patch setCallback(java.lang.String callback) {
              return (Patch) super.setCallback(callback);
            }

            @Override
            public Patch setFields(java.lang.String fields) {
              return (Patch) super.setFields(fields);
            }

            @Override
            public Patch setKey(java.lang.String key) {
              return (Patch) super.setKey(key);
            }

            @Override
            public Patch setOauthToken(java.lang.String oauthToken) {
              return (Patch) super.setOauthToken(oauthToken);
            }

            @Override
            public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Patch) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Patch setQuotaUser(java.lang.String quotaUser) {
              return (Patch) super.setQuotaUser(quotaUser);
            }

            @Override
            public Patch setUploadType(java.lang.String uploadType) {
              return (Patch) super.setUploadType(uploadType);
            }

            @Override
            public Patch setUploadProtocol(java.lang.String uploadProtocol) {
              return (Patch) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Output only. The resource name for this CryptoKey in the format
             * `projects/locations/keyRings/cryptoKeys`.
             */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Output only. The resource name for this CryptoKey in the format
           `projects/locations/keyRings/cryptoKeys`.
             */
            public java.lang.String getName() {
              return name;
            }

            /**
             * Output only. The resource name for this CryptoKey in the format
             * `projects/locations/keyRings/cryptoKeys`.
             */
            public Patch setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.name = name;
              return this;
            }

            /** Required. List of fields to be updated in this request. */
            @com.google.api.client.util.Key
            private String updateMask;

            /** Required. List of fields to be updated in this request.
             */
            public String getUpdateMask() {
              return updateMask;
            }

            /** Required. List of fields to be updated in this request. */
            public Patch setUpdateMask(String updateMask) {
              this.updateMask = updateMask;
              return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
              return (Patch) super.set(parameterName, value);
            }
          }
          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy.
           *
           * Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "cryptoKeys.setIamPolicy".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being specified.
          See the operation documentation for
           *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest}
           * @return the request
           */
          public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            initialize(result);
            return result;
          }

          public class SetIamPolicy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Sets the access control policy on the specified resource. Replaces any existing policy.
             *
             * Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
             *
             * Create a request for the method "cryptoKeys.setIamPolicy".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being specified.
          See the operation documentation for
           *        the appropriate value for this field.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest}
             * @since 1.13
             */
            protected SetIamPolicy(java.lang.String resource, com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (SetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (SetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public SetIamPolicy setAlt(java.lang.String alt) {
              return (SetIamPolicy) super.setAlt(alt);
            }

            @Override
            public SetIamPolicy setCallback(java.lang.String callback) {
              return (SetIamPolicy) super.setCallback(callback);
            }

            @Override
            public SetIamPolicy setFields(java.lang.String fields) {
              return (SetIamPolicy) super.setFields(fields);
            }

            @Override
            public SetIamPolicy setKey(java.lang.String key) {
              return (SetIamPolicy) super.setKey(key);
            }

            @Override
            public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (SetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (SetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetIamPolicy setUploadType(java.lang.String uploadType) {
              return (SetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            public SetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
              return (SetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not exist,
           * this will return an empty set of permissions, not a `NOT_FOUND` error.
           *
           * Note: This operation is designed to be used for building permission-aware UIs and command-line
           * tools, not for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "cryptoKeys.testIamPermissions".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested.
          See the operation
           *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest}
           * @return the request
           */
          public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            initialize(result);
            return result;
          }

          public class TestIamPermissions extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse> {

            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Returns permissions that a caller has on the specified resource. If the resource does not
             * exist, this will return an empty set of permissions, not a `NOT_FOUND` error.
             *
             * Note: This operation is designed to be used for building permission-aware UIs and command-line
             * tools, not for authorization checking. This operation may "fail open" without warning.
             *
             * Create a request for the method "cryptoKeys.testIamPermissions".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
             * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy detail is being requested.
          See the operation
           *        documentation for the appropriate value for this field.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest}
             * @since 1.13
             */
            protected TestIamPermissions(java.lang.String resource, com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
              return (TestIamPermissions) super.set$Xgafv($Xgafv);
            }

            @Override
            public TestIamPermissions setAccessToken(java.lang.String accessToken) {
              return (TestIamPermissions) super.setAccessToken(accessToken);
            }

            @Override
            public TestIamPermissions setAlt(java.lang.String alt) {
              return (TestIamPermissions) super.setAlt(alt);
            }

            @Override
            public TestIamPermissions setCallback(java.lang.String callback) {
              return (TestIamPermissions) super.setCallback(callback);
            }

            @Override
            public TestIamPermissions setFields(java.lang.String fields) {
              return (TestIamPermissions) super.setFields(fields);
            }

            @Override
            public TestIamPermissions setKey(java.lang.String key) {
              return (TestIamPermissions) super.setKey(key);
            }

            @Override
            public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
              return (TestIamPermissions) super.setOauthToken(oauthToken);
            }

            @Override
            public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
              return (TestIamPermissions) super.setQuotaUser(quotaUser);
            }

            @Override
            public TestIamPermissions setUploadType(java.lang.String uploadType) {
              return (TestIamPermissions) super.setUploadType(uploadType);
            }

            @Override
            public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
              return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy detail is being requested. See the operation
           documentation for the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            public TestIamPermissions setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
              return (TestIamPermissions) super.set(parameterName, value);
            }
          }
          /**
           * Update the version of a CryptoKey that will be used in Encrypt.
           *
           * Returns an error if called on an asymmetric key.
           *
           * Create a request for the method "cryptoKeys.updatePrimaryVersion".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link UpdatePrimaryVersion#execute()} method to invoke the remote
           * operation.
           *
           * @param name Required. The resource name of the CryptoKey to update.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.UpdateCryptoKeyPrimaryVersionRequest}
           * @return the request
           */
          public UpdatePrimaryVersion updatePrimaryVersion(java.lang.String name, com.google.api.services.cloudkms.v1.model.UpdateCryptoKeyPrimaryVersionRequest content) throws java.io.IOException {
            UpdatePrimaryVersion result = new UpdatePrimaryVersion(name, content);
            initialize(result);
            return result;
          }

          public class UpdatePrimaryVersion extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKey> {

            private static final String REST_PATH = "v1/{+name}:updatePrimaryVersion";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

            /**
             * Update the version of a CryptoKey that will be used in Encrypt.
             *
             * Returns an error if called on an asymmetric key.
             *
             * Create a request for the method "cryptoKeys.updatePrimaryVersion".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link UpdatePrimaryVersion#execute()} method to invoke the
             * remote operation. <p> {@link UpdatePrimaryVersion#initialize(com.google.api.client.googleapis.s
             * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
             * after invoking the constructor. </p>
             *
             * @param name Required. The resource name of the CryptoKey to update.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.UpdateCryptoKeyPrimaryVersionRequest}
             * @since 1.13
             */
            protected UpdatePrimaryVersion(java.lang.String name, com.google.api.services.cloudkms.v1.model.UpdateCryptoKeyPrimaryVersionRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKey.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
            }

            @Override
            public UpdatePrimaryVersion set$Xgafv(java.lang.String $Xgafv) {
              return (UpdatePrimaryVersion) super.set$Xgafv($Xgafv);
            }

            @Override
            public UpdatePrimaryVersion setAccessToken(java.lang.String accessToken) {
              return (UpdatePrimaryVersion) super.setAccessToken(accessToken);
            }

            @Override
            public UpdatePrimaryVersion setAlt(java.lang.String alt) {
              return (UpdatePrimaryVersion) super.setAlt(alt);
            }

            @Override
            public UpdatePrimaryVersion setCallback(java.lang.String callback) {
              return (UpdatePrimaryVersion) super.setCallback(callback);
            }

            @Override
            public UpdatePrimaryVersion setFields(java.lang.String fields) {
              return (UpdatePrimaryVersion) super.setFields(fields);
            }

            @Override
            public UpdatePrimaryVersion setKey(java.lang.String key) {
              return (UpdatePrimaryVersion) super.setKey(key);
            }

            @Override
            public UpdatePrimaryVersion setOauthToken(java.lang.String oauthToken) {
              return (UpdatePrimaryVersion) super.setOauthToken(oauthToken);
            }

            @Override
            public UpdatePrimaryVersion setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (UpdatePrimaryVersion) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public UpdatePrimaryVersion setQuotaUser(java.lang.String quotaUser) {
              return (UpdatePrimaryVersion) super.setQuotaUser(quotaUser);
            }

            @Override
            public UpdatePrimaryVersion setUploadType(java.lang.String uploadType) {
              return (UpdatePrimaryVersion) super.setUploadType(uploadType);
            }

            @Override
            public UpdatePrimaryVersion setUploadProtocol(java.lang.String uploadProtocol) {
              return (UpdatePrimaryVersion) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The resource name of the CryptoKey to update. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The resource name of the CryptoKey to update.
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The resource name of the CryptoKey to update. */
            public UpdatePrimaryVersion setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public UpdatePrimaryVersion set(String parameterName, Object value) {
              return (UpdatePrimaryVersion) super.set(parameterName, value);
            }
          }

          /**
           * An accessor for creating requests from the CryptoKeyVersions collection.
           *
           * <p>The typical use is:</p>
           * <pre>
           *   {@code CloudKMS cloudkms = new CloudKMS(...);}
           *   {@code CloudKMS.CryptoKeyVersions.List request = cloudkms.cryptoKeyVersions().list(parameters ...)}
           * </pre>
           *
           * @return the resource collection
           */
          public CryptoKeyVersions cryptoKeyVersions() {
            return new CryptoKeyVersions();
          }

          /**
           * The "cryptoKeyVersions" collection of methods.
           */
          public class CryptoKeyVersions {

            /**
             * Decrypts data that was encrypted with a public key retrieved from GetPublicKey corresponding to a
             * CryptoKeyVersion with CryptoKey.purpose ASYMMETRIC_DECRYPT.
             *
             * Create a request for the method "cryptoKeyVersions.asymmetricDecrypt".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link AsymmetricDecrypt#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the CryptoKeyVersion to use for
            decryption.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.AsymmetricDecryptRequest}
             * @return the request
             */
            public AsymmetricDecrypt asymmetricDecrypt(java.lang.String name, com.google.api.services.cloudkms.v1.model.AsymmetricDecryptRequest content) throws java.io.IOException {
              AsymmetricDecrypt result = new AsymmetricDecrypt(name, content);
              initialize(result);
              return result;
            }

            public class AsymmetricDecrypt extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.AsymmetricDecryptResponse> {

              private static final String REST_PATH = "v1/{+name}:asymmetricDecrypt";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Decrypts data that was encrypted with a public key retrieved from GetPublicKey corresponding to
               * a CryptoKeyVersion with CryptoKey.purpose ASYMMETRIC_DECRYPT.
               *
               * Create a request for the method "cryptoKeyVersions.asymmetricDecrypt".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link AsymmetricDecrypt#execute()} method to invoke the remote
               * operation. <p> {@link AsymmetricDecrypt#initialize(com.google.api.client.googleapis.services.Ab
               * stractGoogleClientRequest)} must be called to initialize this instance immediately after
               * invoking the constructor. </p>
               *
               * @param name Required. The resource name of the CryptoKeyVersion to use for
            decryption.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.AsymmetricDecryptRequest}
               * @since 1.13
               */
              protected AsymmetricDecrypt(java.lang.String name, com.google.api.services.cloudkms.v1.model.AsymmetricDecryptRequest content) {
                super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.AsymmetricDecryptResponse.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public AsymmetricDecrypt set$Xgafv(java.lang.String $Xgafv) {
                return (AsymmetricDecrypt) super.set$Xgafv($Xgafv);
              }

              @Override
              public AsymmetricDecrypt setAccessToken(java.lang.String accessToken) {
                return (AsymmetricDecrypt) super.setAccessToken(accessToken);
              }

              @Override
              public AsymmetricDecrypt setAlt(java.lang.String alt) {
                return (AsymmetricDecrypt) super.setAlt(alt);
              }

              @Override
              public AsymmetricDecrypt setCallback(java.lang.String callback) {
                return (AsymmetricDecrypt) super.setCallback(callback);
              }

              @Override
              public AsymmetricDecrypt setFields(java.lang.String fields) {
                return (AsymmetricDecrypt) super.setFields(fields);
              }

              @Override
              public AsymmetricDecrypt setKey(java.lang.String key) {
                return (AsymmetricDecrypt) super.setKey(key);
              }

              @Override
              public AsymmetricDecrypt setOauthToken(java.lang.String oauthToken) {
                return (AsymmetricDecrypt) super.setOauthToken(oauthToken);
              }

              @Override
              public AsymmetricDecrypt setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (AsymmetricDecrypt) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public AsymmetricDecrypt setQuotaUser(java.lang.String quotaUser) {
                return (AsymmetricDecrypt) super.setQuotaUser(quotaUser);
              }

              @Override
              public AsymmetricDecrypt setUploadType(java.lang.String uploadType) {
                return (AsymmetricDecrypt) super.setUploadType(uploadType);
              }

              @Override
              public AsymmetricDecrypt setUploadProtocol(java.lang.String uploadProtocol) {
                return (AsymmetricDecrypt) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the CryptoKeyVersion to use for decryption.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the CryptoKeyVersion to use for decryption.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The resource name of the CryptoKeyVersion to use for decryption.
               */
              public AsymmetricDecrypt setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public AsymmetricDecrypt set(String parameterName, Object value) {
                return (AsymmetricDecrypt) super.set(parameterName, value);
              }
            }
            /**
             * Signs data using a CryptoKeyVersion with CryptoKey.purpose ASYMMETRIC_SIGN, producing a signature
             * that can be verified with the public key retrieved from GetPublicKey.
             *
             * Create a request for the method "cryptoKeyVersions.asymmetricSign".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link AsymmetricSign#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the CryptoKeyVersion to use for signing.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.AsymmetricSignRequest}
             * @return the request
             */
            public AsymmetricSign asymmetricSign(java.lang.String name, com.google.api.services.cloudkms.v1.model.AsymmetricSignRequest content) throws java.io.IOException {
              AsymmetricSign result = new AsymmetricSign(name, content);
              initialize(result);
              return result;
            }

            public class AsymmetricSign extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.AsymmetricSignResponse> {

              private static final String REST_PATH = "v1/{+name}:asymmetricSign";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Signs data using a CryptoKeyVersion with CryptoKey.purpose ASYMMETRIC_SIGN, producing a
               * signature that can be verified with the public key retrieved from GetPublicKey.
               *
               * Create a request for the method "cryptoKeyVersions.asymmetricSign".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link AsymmetricSign#execute()} method to invoke the remote
               * operation. <p> {@link AsymmetricSign#initialize(com.google.api.client.googleapis.services.Abstr
               * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param name Required. The resource name of the CryptoKeyVersion to use for signing.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.AsymmetricSignRequest}
               * @since 1.13
               */
              protected AsymmetricSign(java.lang.String name, com.google.api.services.cloudkms.v1.model.AsymmetricSignRequest content) {
                super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.AsymmetricSignResponse.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public AsymmetricSign set$Xgafv(java.lang.String $Xgafv) {
                return (AsymmetricSign) super.set$Xgafv($Xgafv);
              }

              @Override
              public AsymmetricSign setAccessToken(java.lang.String accessToken) {
                return (AsymmetricSign) super.setAccessToken(accessToken);
              }

              @Override
              public AsymmetricSign setAlt(java.lang.String alt) {
                return (AsymmetricSign) super.setAlt(alt);
              }

              @Override
              public AsymmetricSign setCallback(java.lang.String callback) {
                return (AsymmetricSign) super.setCallback(callback);
              }

              @Override
              public AsymmetricSign setFields(java.lang.String fields) {
                return (AsymmetricSign) super.setFields(fields);
              }

              @Override
              public AsymmetricSign setKey(java.lang.String key) {
                return (AsymmetricSign) super.setKey(key);
              }

              @Override
              public AsymmetricSign setOauthToken(java.lang.String oauthToken) {
                return (AsymmetricSign) super.setOauthToken(oauthToken);
              }

              @Override
              public AsymmetricSign setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (AsymmetricSign) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public AsymmetricSign setQuotaUser(java.lang.String quotaUser) {
                return (AsymmetricSign) super.setQuotaUser(quotaUser);
              }

              @Override
              public AsymmetricSign setUploadType(java.lang.String uploadType) {
                return (AsymmetricSign) super.setUploadType(uploadType);
              }

              @Override
              public AsymmetricSign setUploadProtocol(java.lang.String uploadProtocol) {
                return (AsymmetricSign) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the CryptoKeyVersion to use for signing. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the CryptoKeyVersion to use for signing.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the CryptoKeyVersion to use for signing. */
              public AsymmetricSign setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public AsymmetricSign set(String parameterName, Object value) {
                return (AsymmetricSign) super.set(parameterName, value);
              }
            }
            /**
             * Create a new CryptoKeyVersion in a CryptoKey.
             *
             * The server will assign the next sequential id. If unset, state will be set to ENABLED.
             *
             * Create a request for the method "cryptoKeyVersions.create".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link Create#execute()} method to invoke the remote operation.
             *
             * @param parent Required. The name of the CryptoKey associated with
            the CryptoKeyVersions.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKeyVersion}
             * @return the request
             */
            public Create create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion content) throws java.io.IOException {
              Create result = new Create(parent, content);
              initialize(result);
              return result;
            }

            public class Create extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKeyVersion> {

              private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

              /**
               * Create a new CryptoKeyVersion in a CryptoKey.
               *
               * The server will assign the next sequential id. If unset, state will be set to ENABLED.
               *
               * Create a request for the method "cryptoKeyVersions.create".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
               * <p> {@link
               * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. The name of the CryptoKey associated with
            the CryptoKeyVersions.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKeyVersion}
               * @since 1.13
               */
              protected Create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion content) {
                super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                }
              }

              @Override
              public Create set$Xgafv(java.lang.String $Xgafv) {
                return (Create) super.set$Xgafv($Xgafv);
              }

              @Override
              public Create setAccessToken(java.lang.String accessToken) {
                return (Create) super.setAccessToken(accessToken);
              }

              @Override
              public Create setAlt(java.lang.String alt) {
                return (Create) super.setAlt(alt);
              }

              @Override
              public Create setCallback(java.lang.String callback) {
                return (Create) super.setCallback(callback);
              }

              @Override
              public Create setFields(java.lang.String fields) {
                return (Create) super.setFields(fields);
              }

              @Override
              public Create setKey(java.lang.String key) {
                return (Create) super.setKey(key);
              }

              @Override
              public Create setOauthToken(java.lang.String oauthToken) {
                return (Create) super.setOauthToken(oauthToken);
              }

              @Override
              public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Create) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Create setQuotaUser(java.lang.String quotaUser) {
                return (Create) super.setQuotaUser(quotaUser);
              }

              @Override
              public Create setUploadType(java.lang.String uploadType) {
                return (Create) super.setUploadType(uploadType);
              }

              @Override
              public Create setUploadProtocol(java.lang.String uploadProtocol) {
                return (Create) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The name of the CryptoKey associated with the CryptoKeyVersions.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. The name of the CryptoKey associated with the CryptoKeyVersions.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * Required. The name of the CryptoKey associated with the CryptoKeyVersions.
               */
              public Create setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public Create set(String parameterName, Object value) {
                return (Create) super.set(parameterName, value);
              }
            }
            /**
             * Schedule a CryptoKeyVersion for destruction.
             *
             * Upon calling this method, CryptoKeyVersion.state will be set to DESTROY_SCHEDULED and
             * destroy_time will be set to a time 24 hours in the future, at which point the state will be
             * changed to DESTROYED, and the key material will be irrevocably destroyed.
             *
             * Before the destroy_time is reached, RestoreCryptoKeyVersion may be called to reverse the process.
             *
             * Create a request for the method "cryptoKeyVersions.destroy".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link Destroy#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the CryptoKeyVersion to destroy.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.DestroyCryptoKeyVersionRequest}
             * @return the request
             */
            public Destroy destroy(java.lang.String name, com.google.api.services.cloudkms.v1.model.DestroyCryptoKeyVersionRequest content) throws java.io.IOException {
              Destroy result = new Destroy(name, content);
              initialize(result);
              return result;
            }

            public class Destroy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKeyVersion> {

              private static final String REST_PATH = "v1/{+name}:destroy";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Schedule a CryptoKeyVersion for destruction.
               *
               * Upon calling this method, CryptoKeyVersion.state will be set to DESTROY_SCHEDULED and
               * destroy_time will be set to a time 24 hours in the future, at which point the state will be
               * changed to DESTROYED, and the key material will be irrevocably destroyed.
               *
               * Before the destroy_time is reached, RestoreCryptoKeyVersion may be called to reverse the
               * process.
               *
               * Create a request for the method "cryptoKeyVersions.destroy".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link Destroy#execute()} method to invoke the remote operation.
               * <p> {@link
               * Destroy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the CryptoKeyVersion to destroy.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.DestroyCryptoKeyVersionRequest}
               * @since 1.13
               */
              protected Destroy(java.lang.String name, com.google.api.services.cloudkms.v1.model.DestroyCryptoKeyVersionRequest content) {
                super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public Destroy set$Xgafv(java.lang.String $Xgafv) {
                return (Destroy) super.set$Xgafv($Xgafv);
              }

              @Override
              public Destroy setAccessToken(java.lang.String accessToken) {
                return (Destroy) super.setAccessToken(accessToken);
              }

              @Override
              public Destroy setAlt(java.lang.String alt) {
                return (Destroy) super.setAlt(alt);
              }

              @Override
              public Destroy setCallback(java.lang.String callback) {
                return (Destroy) super.setCallback(callback);
              }

              @Override
              public Destroy setFields(java.lang.String fields) {
                return (Destroy) super.setFields(fields);
              }

              @Override
              public Destroy setKey(java.lang.String key) {
                return (Destroy) super.setKey(key);
              }

              @Override
              public Destroy setOauthToken(java.lang.String oauthToken) {
                return (Destroy) super.setOauthToken(oauthToken);
              }

              @Override
              public Destroy setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Destroy) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Destroy setQuotaUser(java.lang.String quotaUser) {
                return (Destroy) super.setQuotaUser(quotaUser);
              }

              @Override
              public Destroy setUploadType(java.lang.String uploadType) {
                return (Destroy) super.setUploadType(uploadType);
              }

              @Override
              public Destroy setUploadProtocol(java.lang.String uploadProtocol) {
                return (Destroy) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the CryptoKeyVersion to destroy. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the CryptoKeyVersion to destroy.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the CryptoKeyVersion to destroy. */
              public Destroy setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Destroy set(String parameterName, Object value) {
                return (Destroy) super.set(parameterName, value);
              }
            }
            /**
             * Returns metadata for a given CryptoKeyVersion.
             *
             * Create a request for the method "cryptoKeyVersions.get".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link Get#execute()} method to invoke the remote operation.
             *
             * @param name Required. The name of the CryptoKeyVersion to get.
             * @return the request
             */
            public Get get(java.lang.String name) throws java.io.IOException {
              Get result = new Get(name);
              initialize(result);
              return result;
            }

            public class Get extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKeyVersion> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Returns metadata for a given CryptoKeyVersion.
               *
               * Create a request for the method "cryptoKeyVersions.get".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
               * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The name of the CryptoKeyVersion to get.
               * @since 1.13
               */
              protected Get(java.lang.String name) {
                super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public Get set$Xgafv(java.lang.String $Xgafv) {
                return (Get) super.set$Xgafv($Xgafv);
              }

              @Override
              public Get setAccessToken(java.lang.String accessToken) {
                return (Get) super.setAccessToken(accessToken);
              }

              @Override
              public Get setAlt(java.lang.String alt) {
                return (Get) super.setAlt(alt);
              }

              @Override
              public Get setCallback(java.lang.String callback) {
                return (Get) super.setCallback(callback);
              }

              @Override
              public Get setFields(java.lang.String fields) {
                return (Get) super.setFields(fields);
              }

              @Override
              public Get setKey(java.lang.String key) {
                return (Get) super.setKey(key);
              }

              @Override
              public Get setOauthToken(java.lang.String oauthToken) {
                return (Get) super.setOauthToken(oauthToken);
              }

              @Override
              public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Get) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Get setQuotaUser(java.lang.String quotaUser) {
                return (Get) super.setQuotaUser(quotaUser);
              }

              @Override
              public Get setUploadType(java.lang.String uploadType) {
                return (Get) super.setUploadType(uploadType);
              }

              @Override
              public Get setUploadProtocol(java.lang.String uploadProtocol) {
                return (Get) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The name of the CryptoKeyVersion to get. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The name of the CryptoKeyVersion to get.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The name of the CryptoKeyVersion to get. */
              public Get setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Get set(String parameterName, Object value) {
                return (Get) super.set(parameterName, value);
              }
            }
            /**
             * Returns the public key for the given CryptoKeyVersion. The CryptoKey.purpose must be
             * ASYMMETRIC_SIGN or ASYMMETRIC_DECRYPT.
             *
             * Create a request for the method "cryptoKeyVersions.getPublicKey".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link GetPublicKey#execute()} method to invoke the remote operation.
             *
             * @param name Required. The name of the CryptoKeyVersion public key to
            get.
             * @return the request
             */
            public GetPublicKey getPublicKey(java.lang.String name) throws java.io.IOException {
              GetPublicKey result = new GetPublicKey(name);
              initialize(result);
              return result;
            }

            public class GetPublicKey extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.PublicKey> {

              private static final String REST_PATH = "v1/{+name}/publicKey";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Returns the public key for the given CryptoKeyVersion. The CryptoKey.purpose must be
               * ASYMMETRIC_SIGN or ASYMMETRIC_DECRYPT.
               *
               * Create a request for the method "cryptoKeyVersions.getPublicKey".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link GetPublicKey#execute()} method to invoke the remote
               * operation. <p> {@link
               * GetPublicKey#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The name of the CryptoKeyVersion public key to
            get.
               * @since 1.13
               */
              protected GetPublicKey(java.lang.String name) {
                super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.PublicKey.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public GetPublicKey set$Xgafv(java.lang.String $Xgafv) {
                return (GetPublicKey) super.set$Xgafv($Xgafv);
              }

              @Override
              public GetPublicKey setAccessToken(java.lang.String accessToken) {
                return (GetPublicKey) super.setAccessToken(accessToken);
              }

              @Override
              public GetPublicKey setAlt(java.lang.String alt) {
                return (GetPublicKey) super.setAlt(alt);
              }

              @Override
              public GetPublicKey setCallback(java.lang.String callback) {
                return (GetPublicKey) super.setCallback(callback);
              }

              @Override
              public GetPublicKey setFields(java.lang.String fields) {
                return (GetPublicKey) super.setFields(fields);
              }

              @Override
              public GetPublicKey setKey(java.lang.String key) {
                return (GetPublicKey) super.setKey(key);
              }

              @Override
              public GetPublicKey setOauthToken(java.lang.String oauthToken) {
                return (GetPublicKey) super.setOauthToken(oauthToken);
              }

              @Override
              public GetPublicKey setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (GetPublicKey) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public GetPublicKey setQuotaUser(java.lang.String quotaUser) {
                return (GetPublicKey) super.setQuotaUser(quotaUser);
              }

              @Override
              public GetPublicKey setUploadType(java.lang.String uploadType) {
                return (GetPublicKey) super.setUploadType(uploadType);
              }

              @Override
              public GetPublicKey setUploadProtocol(java.lang.String uploadProtocol) {
                return (GetPublicKey) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The name of the CryptoKeyVersion public key to get.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The name of the CryptoKeyVersion public key to get.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Required. The name of the CryptoKeyVersion public key to get.
               */
              public GetPublicKey setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public GetPublicKey set(String parameterName, Object value) {
                return (GetPublicKey) super.set(parameterName, value);
              }
            }
            /**
             * Imports a new CryptoKeyVersion into an existing CryptoKey using the wrapped key material provided
             * in the request.
             *
             * The version ID will be assigned the next sequential id within the CryptoKey.
             *
             * Create a request for the method "cryptoKeyVersions.import".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link CloudKMSImport#execute()} method to invoke the remote operation.
             *
             * @param parent Required. The name of the CryptoKey to
            be imported into.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.ImportCryptoKeyVersionRequest}
             * @return the request
             */
            public CloudKMSImport cloudkmsImport(java.lang.String parent, com.google.api.services.cloudkms.v1.model.ImportCryptoKeyVersionRequest content) throws java.io.IOException {
              CloudKMSImport result = new CloudKMSImport(parent, content);
              initialize(result);
              return result;
            }

            public class CloudKMSImport extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKeyVersion> {

              private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions:import";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

              /**
               * Imports a new CryptoKeyVersion into an existing CryptoKey using the wrapped key material
               * provided in the request.
               *
               * The version ID will be assigned the next sequential id within the CryptoKey.
               *
               * Create a request for the method "cryptoKeyVersions.import".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link CloudKMSImport#execute()} method to invoke the remote
               * operation. <p> {@link CloudKMSImport#initialize(com.google.api.client.googleapis.services.Abstr
               * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
               * the constructor. </p>
               *
               * @param parent Required. The name of the CryptoKey to
            be imported into.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.ImportCryptoKeyVersionRequest}
               * @since 1.13
               */
              protected CloudKMSImport(java.lang.String parent, com.google.api.services.cloudkms.v1.model.ImportCryptoKeyVersionRequest content) {
                super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                }
              }

              @Override
              public CloudKMSImport set$Xgafv(java.lang.String $Xgafv) {
                return (CloudKMSImport) super.set$Xgafv($Xgafv);
              }

              @Override
              public CloudKMSImport setAccessToken(java.lang.String accessToken) {
                return (CloudKMSImport) super.setAccessToken(accessToken);
              }

              @Override
              public CloudKMSImport setAlt(java.lang.String alt) {
                return (CloudKMSImport) super.setAlt(alt);
              }

              @Override
              public CloudKMSImport setCallback(java.lang.String callback) {
                return (CloudKMSImport) super.setCallback(callback);
              }

              @Override
              public CloudKMSImport setFields(java.lang.String fields) {
                return (CloudKMSImport) super.setFields(fields);
              }

              @Override
              public CloudKMSImport setKey(java.lang.String key) {
                return (CloudKMSImport) super.setKey(key);
              }

              @Override
              public CloudKMSImport setOauthToken(java.lang.String oauthToken) {
                return (CloudKMSImport) super.setOauthToken(oauthToken);
              }

              @Override
              public CloudKMSImport setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (CloudKMSImport) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public CloudKMSImport setQuotaUser(java.lang.String quotaUser) {
                return (CloudKMSImport) super.setQuotaUser(quotaUser);
              }

              @Override
              public CloudKMSImport setUploadType(java.lang.String uploadType) {
                return (CloudKMSImport) super.setUploadType(uploadType);
              }

              @Override
              public CloudKMSImport setUploadProtocol(java.lang.String uploadProtocol) {
                return (CloudKMSImport) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The name of the CryptoKey to be imported into.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. The name of the CryptoKey to be imported into.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * Required. The name of the CryptoKey to be imported into.
               */
              public CloudKMSImport setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              @Override
              public CloudKMSImport set(String parameterName, Object value) {
                return (CloudKMSImport) super.set(parameterName, value);
              }
            }
            /**
             * Lists CryptoKeyVersions.
             *
             * Create a request for the method "cryptoKeyVersions.list".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link List#execute()} method to invoke the remote operation.
             *
             * @param parent Required. The resource name of the CryptoKey to list, in the format
             *        `projects/locations/keyRings/cryptoKeys`.
             * @return the request
             */
            public List list(java.lang.String parent) throws java.io.IOException {
              List result = new List(parent);
              initialize(result);
              return result;
            }

            public class List extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ListCryptoKeyVersionsResponse> {

              private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions";

              private final java.util.regex.Pattern PARENT_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");

              /**
               * Lists CryptoKeyVersions.
               *
               * Create a request for the method "cryptoKeyVersions.list".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
               * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
               * must be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param parent Required. The resource name of the CryptoKey to list, in the format
             *        `projects/locations/keyRings/cryptoKeys`.
               * @since 1.13
               */
              protected List(java.lang.String parent) {
                super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.ListCryptoKeyVersionsResponse.class);
                this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                }
              }

              @Override
              public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
                return super.executeUsingHead();
              }

              @Override
              public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
                return super.buildHttpRequestUsingHead();
              }

              @Override
              public List set$Xgafv(java.lang.String $Xgafv) {
                return (List) super.set$Xgafv($Xgafv);
              }

              @Override
              public List setAccessToken(java.lang.String accessToken) {
                return (List) super.setAccessToken(accessToken);
              }

              @Override
              public List setAlt(java.lang.String alt) {
                return (List) super.setAlt(alt);
              }

              @Override
              public List setCallback(java.lang.String callback) {
                return (List) super.setCallback(callback);
              }

              @Override
              public List setFields(java.lang.String fields) {
                return (List) super.setFields(fields);
              }

              @Override
              public List setKey(java.lang.String key) {
                return (List) super.setKey(key);
              }

              @Override
              public List setOauthToken(java.lang.String oauthToken) {
                return (List) super.setOauthToken(oauthToken);
              }

              @Override
              public List setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (List) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public List setQuotaUser(java.lang.String quotaUser) {
                return (List) super.setQuotaUser(quotaUser);
              }

              @Override
              public List setUploadType(java.lang.String uploadType) {
                return (List) super.setUploadType(uploadType);
              }

              @Override
              public List setUploadProtocol(java.lang.String uploadProtocol) {
                return (List) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Required. The resource name of the CryptoKey to list, in the format
               * `projects/locations/keyRings/cryptoKeys`.
               */
              @com.google.api.client.util.Key
              private java.lang.String parent;

              /** Required. The resource name of the CryptoKey to list, in the format
             `projects/locations/keyRings/cryptoKeys`.
               */
              public java.lang.String getParent() {
                return parent;
              }

              /**
               * Required. The resource name of the CryptoKey to list, in the format
               * `projects/locations/keyRings/cryptoKeys`.
               */
              public List setParent(java.lang.String parent) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                      "Parameter parent must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                }
                this.parent = parent;
                return this;
              }

              /**
               * Optional. Only include resources that match the filter in the response. For more
               * information, see [Sorting and filtering list
               * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
               */
              @com.google.api.client.util.Key
              private java.lang.String filter;

              /** Optional. Only include resources that match the filter in the response. For more information, see
             [Sorting and filtering list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
               */
              public java.lang.String getFilter() {
                return filter;
              }

              /**
               * Optional. Only include resources that match the filter in the response. For more
               * information, see [Sorting and filtering list
               * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
               */
              public List setFilter(java.lang.String filter) {
                this.filter = filter;
                return this;
              }

              /**
               * Optional. Specify how the results should be sorted. If not specified, the results
               * will be sorted in the default order. For more information, see [Sorting and
               * filtering list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
               */
              @com.google.api.client.util.Key
              private java.lang.String orderBy;

              /** Optional. Specify how the results should be sorted. If not specified, the results will be sorted in
             the default order. For more information, see [Sorting and filtering list
             results](https://cloud.google.com/kms/docs/sorting-and-filtering).
               */
              public java.lang.String getOrderBy() {
                return orderBy;
              }

              /**
               * Optional. Specify how the results should be sorted. If not specified, the results
               * will be sorted in the default order. For more information, see [Sorting and
               * filtering list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
               */
              public List setOrderBy(java.lang.String orderBy) {
                this.orderBy = orderBy;
                return this;
              }

              /**
               * Optional. Optional limit on the number of CryptoKeyVersions to include in the
               * response. Further CryptoKeyVersions can subsequently be obtained by including the
               * ListCryptoKeyVersionsResponse.next_page_token in a subsequent request. If
               * unspecified, the server will pick an appropriate default.
               */
              @com.google.api.client.util.Key
              private java.lang.Integer pageSize;

              /** Optional. Optional limit on the number of CryptoKeyVersions to include in the response. Further
             CryptoKeyVersions can subsequently be obtained by including the
             ListCryptoKeyVersionsResponse.next_page_token in a subsequent request. If unspecified, the server
             will pick an appropriate default.
               */
              public java.lang.Integer getPageSize() {
                return pageSize;
              }

              /**
               * Optional. Optional limit on the number of CryptoKeyVersions to include in the
               * response. Further CryptoKeyVersions can subsequently be obtained by including the
               * ListCryptoKeyVersionsResponse.next_page_token in a subsequent request. If
               * unspecified, the server will pick an appropriate default.
               */
              public List setPageSize(java.lang.Integer pageSize) {
                this.pageSize = pageSize;
                return this;
              }

              /**
               * Optional. Optional pagination token, returned earlier via
               * ListCryptoKeyVersionsResponse.next_page_token.
               */
              @com.google.api.client.util.Key
              private java.lang.String pageToken;

              /** Optional. Optional pagination token, returned earlier via
             ListCryptoKeyVersionsResponse.next_page_token.
               */
              public java.lang.String getPageToken() {
                return pageToken;
              }

              /**
               * Optional. Optional pagination token, returned earlier via
               * ListCryptoKeyVersionsResponse.next_page_token.
               */
              public List setPageToken(java.lang.String pageToken) {
                this.pageToken = pageToken;
                return this;
              }

              /** The fields to include in the response. */
              @com.google.api.client.util.Key
              private java.lang.String view;

              /** The fields to include in the response.
               */
              public java.lang.String getView() {
                return view;
              }

              /** The fields to include in the response. */
              public List setView(java.lang.String view) {
                this.view = view;
                return this;
              }

              @Override
              public List set(String parameterName, Object value) {
                return (List) super.set(parameterName, value);
              }
            }
            /**
             * Update a CryptoKeyVersion's metadata.
             *
             * state may be changed between ENABLED and DISABLED using this method. See DestroyCryptoKeyVersion
             * and RestoreCryptoKeyVersion to move between other states.
             *
             * Create a request for the method "cryptoKeyVersions.patch".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
             *
             * @param name Output only. The resource name for this CryptoKeyVersion in the format
             *        `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKeyVersion}
             * @return the request
             */
            public Patch patch(java.lang.String name, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion content) throws java.io.IOException {
              Patch result = new Patch(name, content);
              initialize(result);
              return result;
            }

            public class Patch extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKeyVersion> {

              private static final String REST_PATH = "v1/{+name}";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Update a CryptoKeyVersion's metadata.
               *
               * state may be changed between ENABLED and DISABLED using this method. See
               * DestroyCryptoKeyVersion and RestoreCryptoKeyVersion to move between other states.
               *
               * Create a request for the method "cryptoKeyVersions.patch".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
               * <p> {@link
               * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Output only. The resource name for this CryptoKeyVersion in the format
             *        `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.CryptoKeyVersion}
               * @since 1.13
               */
              protected Patch(java.lang.String name, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion content) {
                super(CloudKMS.this, "PATCH", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public Patch set$Xgafv(java.lang.String $Xgafv) {
                return (Patch) super.set$Xgafv($Xgafv);
              }

              @Override
              public Patch setAccessToken(java.lang.String accessToken) {
                return (Patch) super.setAccessToken(accessToken);
              }

              @Override
              public Patch setAlt(java.lang.String alt) {
                return (Patch) super.setAlt(alt);
              }

              @Override
              public Patch setCallback(java.lang.String callback) {
                return (Patch) super.setCallback(callback);
              }

              @Override
              public Patch setFields(java.lang.String fields) {
                return (Patch) super.setFields(fields);
              }

              @Override
              public Patch setKey(java.lang.String key) {
                return (Patch) super.setKey(key);
              }

              @Override
              public Patch setOauthToken(java.lang.String oauthToken) {
                return (Patch) super.setOauthToken(oauthToken);
              }

              @Override
              public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Patch) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Patch setQuotaUser(java.lang.String quotaUser) {
                return (Patch) super.setQuotaUser(quotaUser);
              }

              @Override
              public Patch setUploadType(java.lang.String uploadType) {
                return (Patch) super.setUploadType(uploadType);
              }

              @Override
              public Patch setUploadProtocol(java.lang.String uploadProtocol) {
                return (Patch) super.setUploadProtocol(uploadProtocol);
              }

              /**
               * Output only. The resource name for this CryptoKeyVersion in the format
               * `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
               */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Output only. The resource name for this CryptoKeyVersion in the format
             `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
               */
              public java.lang.String getName() {
                return name;
              }

              /**
               * Output only. The resource name for this CryptoKeyVersion in the format
               * `projects/locations/keyRings/cryptoKeys/cryptoKeyVersions`.
               */
              public Patch setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              /** Required. List of fields to be updated in this request. */
              @com.google.api.client.util.Key
              private String updateMask;

              /** Required. List of fields to be updated in this request.
               */
              public String getUpdateMask() {
                return updateMask;
              }

              /** Required. List of fields to be updated in this request. */
              public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
              }

              @Override
              public Patch set(String parameterName, Object value) {
                return (Patch) super.set(parameterName, value);
              }
            }
            /**
             * Restore a CryptoKeyVersion in the DESTROY_SCHEDULED state.
             *
             * Upon restoration of the CryptoKeyVersion, state will be set to DISABLED, and destroy_time will be
             * cleared.
             *
             * Create a request for the method "cryptoKeyVersions.restore".
             *
             * This request holds the parameters needed by the cloudkms server.  After setting any optional
             * parameters, call the {@link Restore#execute()} method to invoke the remote operation.
             *
             * @param name Required. The resource name of the CryptoKeyVersion to restore.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.RestoreCryptoKeyVersionRequest}
             * @return the request
             */
            public Restore restore(java.lang.String name, com.google.api.services.cloudkms.v1.model.RestoreCryptoKeyVersionRequest content) throws java.io.IOException {
              Restore result = new Restore(name, content);
              initialize(result);
              return result;
            }

            public class Restore extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.CryptoKeyVersion> {

              private static final String REST_PATH = "v1/{+name}:restore";

              private final java.util.regex.Pattern NAME_PATTERN =
                  java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");

              /**
               * Restore a CryptoKeyVersion in the DESTROY_SCHEDULED state.
               *
               * Upon restoration of the CryptoKeyVersion, state will be set to DISABLED, and destroy_time will
               * be cleared.
               *
               * Create a request for the method "cryptoKeyVersions.restore".
               *
               * This request holds the parameters needed by the the cloudkms server.  After setting any
               * optional parameters, call the {@link Restore#execute()} method to invoke the remote operation.
               * <p> {@link
               * Restore#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
               * be called to initialize this instance immediately after invoking the constructor. </p>
               *
               * @param name Required. The resource name of the CryptoKeyVersion to restore.
               * @param content the {@link com.google.api.services.cloudkms.v1.model.RestoreCryptoKeyVersionRequest}
               * @since 1.13
               */
              protected Restore(java.lang.String name, com.google.api.services.cloudkms.v1.model.RestoreCryptoKeyVersionRequest content) {
                super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.CryptoKeyVersion.class);
                this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
              }

              @Override
              public Restore set$Xgafv(java.lang.String $Xgafv) {
                return (Restore) super.set$Xgafv($Xgafv);
              }

              @Override
              public Restore setAccessToken(java.lang.String accessToken) {
                return (Restore) super.setAccessToken(accessToken);
              }

              @Override
              public Restore setAlt(java.lang.String alt) {
                return (Restore) super.setAlt(alt);
              }

              @Override
              public Restore setCallback(java.lang.String callback) {
                return (Restore) super.setCallback(callback);
              }

              @Override
              public Restore setFields(java.lang.String fields) {
                return (Restore) super.setFields(fields);
              }

              @Override
              public Restore setKey(java.lang.String key) {
                return (Restore) super.setKey(key);
              }

              @Override
              public Restore setOauthToken(java.lang.String oauthToken) {
                return (Restore) super.setOauthToken(oauthToken);
              }

              @Override
              public Restore setPrettyPrint(java.lang.Boolean prettyPrint) {
                return (Restore) super.setPrettyPrint(prettyPrint);
              }

              @Override
              public Restore setQuotaUser(java.lang.String quotaUser) {
                return (Restore) super.setQuotaUser(quotaUser);
              }

              @Override
              public Restore setUploadType(java.lang.String uploadType) {
                return (Restore) super.setUploadType(uploadType);
              }

              @Override
              public Restore setUploadProtocol(java.lang.String uploadProtocol) {
                return (Restore) super.setUploadProtocol(uploadProtocol);
              }

              /** Required. The resource name of the CryptoKeyVersion to restore. */
              @com.google.api.client.util.Key
              private java.lang.String name;

              /** Required. The resource name of the CryptoKeyVersion to restore.
               */
              public java.lang.String getName() {
                return name;
              }

              /** Required. The resource name of the CryptoKeyVersion to restore. */
              public Restore setName(java.lang.String name) {
                if (!getSuppressPatternChecks()) {
                  com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                      "Parameter name must conform to the pattern " +
                      "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                }
                this.name = name;
                return this;
              }

              @Override
              public Restore set(String parameterName, Object value) {
                return (Restore) super.set(parameterName, value);
              }
            }

          }
        }
        /**
         * An accessor for creating requests from the ImportJobs collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code CloudKMS cloudkms = new CloudKMS(...);}
         *   {@code CloudKMS.ImportJobs.List request = cloudkms.importJobs().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public ImportJobs importJobs() {
          return new ImportJobs();
        }

        /**
         * The "importJobs" collection of methods.
         */
        public class ImportJobs {

          /**
           * Create a new ImportJob within a KeyRing.
           *
           * ImportJob.import_method is required.
           *
           * Create a request for the method "importJobs.create".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Create#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The name of the KeyRing associated with the
          ImportJobs.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.ImportJob}
           * @return the request
           */
          public Create create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.ImportJob content) throws java.io.IOException {
            Create result = new Create(parent, content);
            initialize(result);
            return result;
          }

          public class Create extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ImportJob> {

            private static final String REST_PATH = "v1/{+parent}/importJobs";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

            /**
             * Create a new ImportJob within a KeyRing.
             *
             * ImportJob.import_method is required.
             *
             * Create a request for the method "importJobs.create".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
             * <p> {@link
             * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The name of the KeyRing associated with the
          ImportJobs.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.ImportJob}
             * @since 1.13
             */
            protected Create(java.lang.String parent, com.google.api.services.cloudkms.v1.model.ImportJob content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.ImportJob.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
            }

            @Override
            public Create set$Xgafv(java.lang.String $Xgafv) {
              return (Create) super.set$Xgafv($Xgafv);
            }

            @Override
            public Create setAccessToken(java.lang.String accessToken) {
              return (Create) super.setAccessToken(accessToken);
            }

            @Override
            public Create setAlt(java.lang.String alt) {
              return (Create) super.setAlt(alt);
            }

            @Override
            public Create setCallback(java.lang.String callback) {
              return (Create) super.setCallback(callback);
            }

            @Override
            public Create setFields(java.lang.String fields) {
              return (Create) super.setFields(fields);
            }

            @Override
            public Create setKey(java.lang.String key) {
              return (Create) super.setKey(key);
            }

            @Override
            public Create setOauthToken(java.lang.String oauthToken) {
              return (Create) super.setOauthToken(oauthToken);
            }

            @Override
            public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Create) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Create setQuotaUser(java.lang.String quotaUser) {
              return (Create) super.setQuotaUser(quotaUser);
            }

            @Override
            public Create setUploadType(java.lang.String uploadType) {
              return (Create) super.setUploadType(uploadType);
            }

            @Override
            public Create setUploadProtocol(java.lang.String uploadProtocol) {
              return (Create) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The name of the KeyRing associated with the ImportJobs.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The name of the KeyRing associated with the ImportJobs.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. The name of the KeyRing associated with the ImportJobs.
             */
            public Create setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Required. It must be unique within a KeyRing and match the regular expression
             * `[a-zA-Z0-9_-]{1,63}`
             */
            @com.google.api.client.util.Key
            private java.lang.String importJobId;

            /** Required. It must be unique within a KeyRing and match the regular expression `[a-zA-Z0-9_-]{1,63}`
             */
            public java.lang.String getImportJobId() {
              return importJobId;
            }

            /**
             * Required. It must be unique within a KeyRing and match the regular expression
             * `[a-zA-Z0-9_-]{1,63}`
             */
            public Create setImportJobId(java.lang.String importJobId) {
              this.importJobId = importJobId;
              return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
              return (Create) super.set(parameterName, value);
            }
          }
          /**
           * Returns metadata for a given ImportJob.
           *
           * Create a request for the method "importJobs.get".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name Required. The name of the ImportJob to get.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ImportJob> {

            private static final String REST_PATH = "v1/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");

            /**
             * Returns metadata for a given ImportJob.
             *
             * Create a request for the method "importJobs.get".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name Required. The name of the ImportJob to get.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.ImportJob.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** Required. The name of the ImportJob to get. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** Required. The name of the ImportJob to get.
             */
            public java.lang.String getName() {
              return name;
            }

            /** Required. The name of the ImportJob to get. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
           * does not have a policy set.
           *
           * Create a request for the method "importJobs.getIamPolicy".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being requested.
          See the operation documentation for
           *        the appropriate value for this field.
           * @return the request
           */
          public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
            GetIamPolicy result = new GetIamPolicy(resource);
            initialize(result);
            return result;
          }

          public class GetIamPolicy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");

            /**
             * Gets the access control policy for a resource. Returns an empty policy if the resource exists
             * and does not have a policy set.
             *
             * Create a request for the method "importJobs.getIamPolicy".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being requested.
          See the operation documentation for
           *        the appropriate value for this field.
             * @since 1.13
             */
            protected GetIamPolicy(java.lang.String resource) {
              super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (GetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public GetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (GetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public GetIamPolicy setAlt(java.lang.String alt) {
              return (GetIamPolicy) super.setAlt(alt);
            }

            @Override
            public GetIamPolicy setCallback(java.lang.String callback) {
              return (GetIamPolicy) super.setCallback(callback);
            }

            @Override
            public GetIamPolicy setFields(java.lang.String fields) {
              return (GetIamPolicy) super.setFields(fields);
            }

            @Override
            public GetIamPolicy setKey(java.lang.String key) {
              return (GetIamPolicy) super.setKey(key);
            }

            @Override
            public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (GetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (GetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public GetIamPolicy setUploadType(java.lang.String uploadType) {
              return (GetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being requested. See the operation
             * documentation for the appropriate value for this field.
             */
            public GetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            /**
             * Optional. The policy format version to be returned.
             *
             * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
             *
             * Requests for policies with any conditional bindings must specify version 3. Policies
             * without any conditional bindings may specify any valid value or leave the field
             * unset.
             *
             * To learn which resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            @com.google.api.client.util.Key("options.requestedPolicyVersion")
            private java.lang.Integer optionsRequestedPolicyVersion;

            /** Optional. The policy format version to be returned.

           Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.

           Requests for policies with any conditional bindings must specify version 3. Policies without any
           conditional bindings may specify any valid value or leave the field unset.

           To learn which resources support conditions in their IAM policies, see the [IAM
           documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public java.lang.Integer getOptionsRequestedPolicyVersion() {
              return optionsRequestedPolicyVersion;
            }

            /**
             * Optional. The policy format version to be returned.
             *
             * Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.
             *
             * Requests for policies with any conditional bindings must specify version 3. Policies
             * without any conditional bindings may specify any valid value or leave the field
             * unset.
             *
             * To learn which resources support conditions in their IAM policies, see the [IAM
             * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
             */
            public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
              this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
              return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
              return (GetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Lists ImportJobs.
           *
           * Create a request for the method "importJobs.list".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent Required. The resource name of the KeyRing to list, in the format
          `projects/locations/keyRings`.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.ListImportJobsResponse> {

            private static final String REST_PATH = "v1/{+parent}/importJobs";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");

            /**
             * Lists ImportJobs.
             *
             * Create a request for the method "importJobs.list".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent Required. The resource name of the KeyRing to list, in the format
          `projects/locations/keyRings`.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.ListImportJobsResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * Required. The resource name of the KeyRing to list, in the format
             * `projects/locations/keyRings`.
             */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** Required. The resource name of the KeyRing to list, in the format `projects/locations/keyRings`.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /**
             * Required. The resource name of the KeyRing to list, in the format
             * `projects/locations/keyRings`.
             */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /**
             * Optional. Only include resources that match the filter in the response. For more
             * information, see [Sorting and filtering list
             * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            @com.google.api.client.util.Key
            private java.lang.String filter;

            /** Optional. Only include resources that match the filter in the response. For more information, see
           [Sorting and filtering list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public java.lang.String getFilter() {
              return filter;
            }

            /**
             * Optional. Only include resources that match the filter in the response. For more
             * information, see [Sorting and filtering list
             * results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public List setFilter(java.lang.String filter) {
              this.filter = filter;
              return this;
            }

            /**
             * Optional. Specify how the results should be sorted. If not specified, the results
             * will be sorted in the default order. For more information, see [Sorting and filtering
             * list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            @com.google.api.client.util.Key
            private java.lang.String orderBy;

            /** Optional. Specify how the results should be sorted. If not specified, the results will be sorted in
           the default order. For more information, see [Sorting and filtering list
           results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public java.lang.String getOrderBy() {
              return orderBy;
            }

            /**
             * Optional. Specify how the results should be sorted. If not specified, the results
             * will be sorted in the default order. For more information, see [Sorting and filtering
             * list results](https://cloud.google.com/kms/docs/sorting-and-filtering).
             */
            public List setOrderBy(java.lang.String orderBy) {
              this.orderBy = orderBy;
              return this;
            }

            /**
             * Optional. Optional limit on the number of ImportJobs to include in the response.
             * Further ImportJobs can subsequently be obtained by including the
             * ListImportJobsResponse.next_page_token in a subsequent request. If unspecified, the
             * server will pick an appropriate default.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** Optional. Optional limit on the number of ImportJobs to include in the response. Further ImportJobs
           can subsequently be obtained by including the ListImportJobsResponse.next_page_token in a
           subsequent request. If unspecified, the server will pick an appropriate default.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * Optional. Optional limit on the number of ImportJobs to include in the response.
             * Further ImportJobs can subsequently be obtained by including the
             * ListImportJobsResponse.next_page_token in a subsequent request. If unspecified, the
             * server will pick an appropriate default.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            /**
             * Optional. Optional pagination token, returned earlier via
             * ListImportJobsResponse.next_page_token.
             */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** Optional. Optional pagination token, returned earlier via ListImportJobsResponse.next_page_token.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /**
             * Optional. Optional pagination token, returned earlier via
             * ListImportJobsResponse.next_page_token.
             */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy.
           *
           * Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "importJobs.setIamPolicy".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy is being specified.
          See the operation documentation for
           *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest}
           * @return the request
           */
          public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            initialize(result);
            return result;
          }

          public class SetIamPolicy extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.Policy> {

            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");

            /**
             * Sets the access control policy on the specified resource. Replaces any existing policy.
             *
             * Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
             *
             * Create a request for the method "importJobs.setIamPolicy".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
             * operation. <p> {@link
             * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy is being specified.
          See the operation documentation for
           *        the appropriate value for this field.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest}
             * @since 1.13
             */
            protected SetIamPolicy(java.lang.String resource, com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.Policy.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
            }

            @Override
            public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
              return (SetIamPolicy) super.set$Xgafv($Xgafv);
            }

            @Override
            public SetIamPolicy setAccessToken(java.lang.String accessToken) {
              return (SetIamPolicy) super.setAccessToken(accessToken);
            }

            @Override
            public SetIamPolicy setAlt(java.lang.String alt) {
              return (SetIamPolicy) super.setAlt(alt);
            }

            @Override
            public SetIamPolicy setCallback(java.lang.String callback) {
              return (SetIamPolicy) super.setCallback(callback);
            }

            @Override
            public SetIamPolicy setFields(java.lang.String fields) {
              return (SetIamPolicy) super.setFields(fields);
            }

            @Override
            public SetIamPolicy setKey(java.lang.String key) {
              return (SetIamPolicy) super.setKey(key);
            }

            @Override
            public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
              return (SetIamPolicy) super.setOauthToken(oauthToken);
            }

            @Override
            public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
              return (SetIamPolicy) super.setQuotaUser(quotaUser);
            }

            @Override
            public SetIamPolicy setUploadType(java.lang.String uploadType) {
              return (SetIamPolicy) super.setUploadType(uploadType);
            }

            @Override
            public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
              return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
           the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy is being specified. See the operation
             * documentation for the appropriate value for this field.
             */
            public SetIamPolicy setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
              return (SetIamPolicy) super.set(parameterName, value);
            }
          }
          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not exist,
           * this will return an empty set of permissions, not a `NOT_FOUND` error.
           *
           * Note: This operation is designed to be used for building permission-aware UIs and command-line
           * tools, not for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "importJobs.testIamPermissions".
           *
           * This request holds the parameters needed by the cloudkms server.  After setting any optional
           * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested.
          See the operation
           *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest}
           * @return the request
           */
          public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            initialize(result);
            return result;
          }

          public class TestIamPermissions extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse> {

            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

            private final java.util.regex.Pattern RESOURCE_PATTERN =
                java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");

            /**
             * Returns permissions that a caller has on the specified resource. If the resource does not
             * exist, this will return an empty set of permissions, not a `NOT_FOUND` error.
             *
             * Note: This operation is designed to be used for building permission-aware UIs and command-line
             * tools, not for authorization checking. This operation may "fail open" without warning.
             *
             * Create a request for the method "importJobs.testIamPermissions".
             *
             * This request holds the parameters needed by the the cloudkms server.  After setting any
             * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
             * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
             * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
             * invoking the constructor. </p>
             *
             * @param resource REQUIRED: The resource for which the policy detail is being requested.
          See the operation
           *        documentation for the appropriate value for this field.
             * @param content the {@link com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest}
             * @since 1.13
             */
            protected TestIamPermissions(java.lang.String resource, com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest content) {
              super(CloudKMS.this, "POST", REST_PATH, content, com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse.class);
              this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
            }

            @Override
            public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
              return (TestIamPermissions) super.set$Xgafv($Xgafv);
            }

            @Override
            public TestIamPermissions setAccessToken(java.lang.String accessToken) {
              return (TestIamPermissions) super.setAccessToken(accessToken);
            }

            @Override
            public TestIamPermissions setAlt(java.lang.String alt) {
              return (TestIamPermissions) super.setAlt(alt);
            }

            @Override
            public TestIamPermissions setCallback(java.lang.String callback) {
              return (TestIamPermissions) super.setCallback(callback);
            }

            @Override
            public TestIamPermissions setFields(java.lang.String fields) {
              return (TestIamPermissions) super.setFields(fields);
            }

            @Override
            public TestIamPermissions setKey(java.lang.String key) {
              return (TestIamPermissions) super.setKey(key);
            }

            @Override
            public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
              return (TestIamPermissions) super.setOauthToken(oauthToken);
            }

            @Override
            public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
              return (TestIamPermissions) super.setQuotaUser(quotaUser);
            }

            @Override
            public TestIamPermissions setUploadType(java.lang.String uploadType) {
              return (TestIamPermissions) super.setUploadType(uploadType);
            }

            @Override
            public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
              return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            @com.google.api.client.util.Key
            private java.lang.String resource;

            /** REQUIRED: The resource for which the policy detail is being requested. See the operation
           documentation for the appropriate value for this field.
             */
            public java.lang.String getResource() {
              return resource;
            }

            /**
             * REQUIRED: The resource for which the policy detail is being requested. See the
             * operation documentation for the appropriate value for this field.
             */
            public TestIamPermissions setResource(java.lang.String resource) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                    "Parameter resource must conform to the pattern " +
                    "^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
              }
              this.resource = resource;
              return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
              return (TestIamPermissions) super.set(parameterName, value);
            }
          }

        }
      }
    }
  }

  /**
   * Builder for {@link CloudKMS}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link CloudKMS}. */
    @Override
    public CloudKMS build() {
      return new CloudKMS(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CloudKMSRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCloudKMSRequestInitializer(
        CloudKMSRequestInitializer cloudkmsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(cloudkmsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
