/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * A CryptoKeyVersionTemplate specifies the properties to use when creating a new CryptoKeyVersion,
 * either manually with CreateCryptoKeyVersion or automatically as a result of auto-rotation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CryptoKeyVersionTemplate extends com.google.api.client.json.GenericJson {

  /**
   * Required. Algorithm to use when creating a CryptoKeyVersion based on this template.
   *
   * For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION is implied if both this field is
   * omitted and CryptoKey.purpose is ENCRYPT_DECRYPT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String algorithm;

  /**
   * ProtectionLevel to use when creating a CryptoKeyVersion based on this template. Immutable.
   * Defaults to SOFTWARE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protectionLevel;

  /**
   * Required. Algorithm to use when creating a CryptoKeyVersion based on this template.
   *
   * For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION is implied if both this field is
   * omitted and CryptoKey.purpose is ENCRYPT_DECRYPT.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlgorithm() {
    return algorithm;
  }

  /**
   * Required. Algorithm to use when creating a CryptoKeyVersion based on this template.
   *
   * For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION is implied if both this field is
   * omitted and CryptoKey.purpose is ENCRYPT_DECRYPT.
   * @param algorithm algorithm or {@code null} for none
   */
  public CryptoKeyVersionTemplate setAlgorithm(java.lang.String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  /**
   * ProtectionLevel to use when creating a CryptoKeyVersion based on this template. Immutable.
   * Defaults to SOFTWARE.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtectionLevel() {
    return protectionLevel;
  }

  /**
   * ProtectionLevel to use when creating a CryptoKeyVersion based on this template. Immutable.
   * Defaults to SOFTWARE.
   * @param protectionLevel protectionLevel or {@code null} for none
   */
  public CryptoKeyVersionTemplate setProtectionLevel(java.lang.String protectionLevel) {
    this.protectionLevel = protectionLevel;
    return this;
  }

  @Override
  public CryptoKeyVersionTemplate set(String fieldName, Object value) {
    return (CryptoKeyVersionTemplate) super.set(fieldName, value);
  }

  @Override
  public CryptoKeyVersionTemplate clone() {
    return (CryptoKeyVersionTemplate) super.clone();
  }

}
