/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Request message for KeyManagementService.ImportCryptoKeyVersion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImportCryptoKeyVersionRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The algorithm of the key being imported. This does not need to match the
   * version_template of the CryptoKey this version imports into.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String algorithm;

  /**
   * Required. The name of the ImportJob that was used to wrap this key material.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String importJob;

  /**
   * Wrapped key material produced with RSA_OAEP_3072_SHA1_AES_256 or RSA_OAEP_4096_SHA1_AES_256.
   *
   * This field contains the concatenation of two wrapped keys:
   *
   *   An ephemeral AES-256 wrapping key wrapped with the       public_key using RSAES-OAEP with
   * SHA-1,       MGF1 with SHA-1, and an empty label.      The key to be imported, wrapped with the
   * ephemeral AES-256 key       using AES-KWP (RFC 5649).
   *
   * If importing symmetric key material, it is expected that the unwrapped key contains plain
   * bytes. If importing asymmetric key material, it is expected that the unwrapped key is in
   * PKCS#8-encoded DER format (the PrivateKeyInfo structure from RFC 5208).
   *
   * This format is the same as the format produced by PKCS#11 mechanism CKM_RSA_AES_KEY_WRAP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rsaAesWrappedKey;

  /**
   * Required. The algorithm of the key being imported. This does not need to match the
   * version_template of the CryptoKey this version imports into.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlgorithm() {
    return algorithm;
  }

  /**
   * Required. The algorithm of the key being imported. This does not need to match the
   * version_template of the CryptoKey this version imports into.
   * @param algorithm algorithm or {@code null} for none
   */
  public ImportCryptoKeyVersionRequest setAlgorithm(java.lang.String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  /**
   * Required. The name of the ImportJob that was used to wrap this key material.
   * @return value or {@code null} for none
   */
  public java.lang.String getImportJob() {
    return importJob;
  }

  /**
   * Required. The name of the ImportJob that was used to wrap this key material.
   * @param importJob importJob or {@code null} for none
   */
  public ImportCryptoKeyVersionRequest setImportJob(java.lang.String importJob) {
    this.importJob = importJob;
    return this;
  }

  /**
   * Wrapped key material produced with RSA_OAEP_3072_SHA1_AES_256 or RSA_OAEP_4096_SHA1_AES_256.
   *
   * This field contains the concatenation of two wrapped keys:
   *
   *   An ephemeral AES-256 wrapping key wrapped with the       public_key using RSAES-OAEP with
   * SHA-1,       MGF1 with SHA-1, and an empty label.      The key to be imported, wrapped with the
   * ephemeral AES-256 key       using AES-KWP (RFC 5649).
   *
   * If importing symmetric key material, it is expected that the unwrapped key contains plain
   * bytes. If importing asymmetric key material, it is expected that the unwrapped key is in
   * PKCS#8-encoded DER format (the PrivateKeyInfo structure from RFC 5208).
   *
   * This format is the same as the format produced by PKCS#11 mechanism CKM_RSA_AES_KEY_WRAP.
   * @see #decodeRsaAesWrappedKey()
   * @return value or {@code null} for none
   */
  public java.lang.String getRsaAesWrappedKey() {
    return rsaAesWrappedKey;
  }

  /**
   * Wrapped key material produced with RSA_OAEP_3072_SHA1_AES_256 or RSA_OAEP_4096_SHA1_AES_256.
   *
   * This field contains the concatenation of two wrapped keys:
   *
   *   An ephemeral AES-256 wrapping key wrapped with the       public_key using RSAES-OAEP with
   * SHA-1,       MGF1 with SHA-1, and an empty label.      The key to be imported, wrapped with the
   * ephemeral AES-256 key       using AES-KWP (RFC 5649).
   *
   * If importing symmetric key material, it is expected that the unwrapped key contains plain
   * bytes. If importing asymmetric key material, it is expected that the unwrapped key is in
   * PKCS#8-encoded DER format (the PrivateKeyInfo structure from RFC 5208).
   *
   * This format is the same as the format produced by PKCS#11 mechanism CKM_RSA_AES_KEY_WRAP.
   * @see #getRsaAesWrappedKey()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeRsaAesWrappedKey() {
    return com.google.api.client.util.Base64.decodeBase64(rsaAesWrappedKey);
  }

  /**
   * Wrapped key material produced with RSA_OAEP_3072_SHA1_AES_256 or RSA_OAEP_4096_SHA1_AES_256.
   *
   * This field contains the concatenation of two wrapped keys:
   *
   *   An ephemeral AES-256 wrapping key wrapped with the       public_key using RSAES-OAEP with
   * SHA-1,       MGF1 with SHA-1, and an empty label.      The key to be imported, wrapped with the
   * ephemeral AES-256 key       using AES-KWP (RFC 5649).
   *
   * If importing symmetric key material, it is expected that the unwrapped key contains plain
   * bytes. If importing asymmetric key material, it is expected that the unwrapped key is in
   * PKCS#8-encoded DER format (the PrivateKeyInfo structure from RFC 5208).
   *
   * This format is the same as the format produced by PKCS#11 mechanism CKM_RSA_AES_KEY_WRAP.
   * @see #encodeRsaAesWrappedKey()
   * @param rsaAesWrappedKey rsaAesWrappedKey or {@code null} for none
   */
  public ImportCryptoKeyVersionRequest setRsaAesWrappedKey(java.lang.String rsaAesWrappedKey) {
    this.rsaAesWrappedKey = rsaAesWrappedKey;
    return this;
  }

  /**
   * Wrapped key material produced with RSA_OAEP_3072_SHA1_AES_256 or RSA_OAEP_4096_SHA1_AES_256.
   *
   * This field contains the concatenation of two wrapped keys:
   *
   *   An ephemeral AES-256 wrapping key wrapped with the       public_key using RSAES-OAEP with
   * SHA-1,       MGF1 with SHA-1, and an empty label.      The key to be imported, wrapped with the
   * ephemeral AES-256 key       using AES-KWP (RFC 5649).
   *
   * If importing symmetric key material, it is expected that the unwrapped key contains plain
   * bytes. If importing asymmetric key material, it is expected that the unwrapped key is in
   * PKCS#8-encoded DER format (the PrivateKeyInfo structure from RFC 5208).
   *
   * This format is the same as the format produced by PKCS#11 mechanism CKM_RSA_AES_KEY_WRAP.
   * @see #setRsaAesWrappedKey()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public ImportCryptoKeyVersionRequest encodeRsaAesWrappedKey(byte[] rsaAesWrappedKey) {
    this.rsaAesWrappedKey = com.google.api.client.util.Base64.encodeBase64URLSafeString(rsaAesWrappedKey);
    return this;
  }

  @Override
  public ImportCryptoKeyVersionRequest set(String fieldName, Object value) {
    return (ImportCryptoKeyVersionRequest) super.set(fieldName, value);
  }

  @Override
  public ImportCryptoKeyVersionRequest clone() {
    return (ImportCryptoKeyVersionRequest) super.clone();
  }

}
