/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * An ImportJob can be used to create CryptoKeys and CryptoKeyVersions using pre-existing key
 * material, generated outside of Cloud KMS.
 *
 * When an ImportJob is created, Cloud KMS will generate a "wrapping key", which is a public/private
 * key pair. You use the wrapping key to encrypt (also known as wrap) the pre-existing key material
 * to protect it during the import process. The nature of the wrapping key depends on the choice of
 * import_method. When the wrapping key generation is complete, the state will be set to ACTIVE and
 * the public_key can be fetched. The fetched public key can then be used to wrap your pre-existing
 * key material.
 *
 * Once the key material is wrapped, it can be imported into a new CryptoKeyVersion in an existing
 * CryptoKey by calling ImportCryptoKeyVersion. Multiple CryptoKeyVersions can be imported with a
 * single ImportJob. Cloud KMS uses the private key portion of the wrapping key to unwrap the key
 * material. Only Cloud KMS has access to the private key.
 *
 * An ImportJob expires 3 days after it is created. Once expired, Cloud KMS will no longer be able
 * to import or unwrap any key material that was wrapped with the ImportJob's public key.
 *
 * For more information, see [Importing a key](https://cloud.google.com/kms/docs/importing-a-key).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImportJob extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Statement that was generated and signed by the key creator (for example, an HSM)
   * at key creation time. Use this statement to verify attributes of the key as stored on the HSM,
   * independently of Google. Only present if the chosen ImportMethod is one with a protection level
   * of HSM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KeyOperationAttestation attestation;

  /**
   * Output only. The time at which this ImportJob was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The time this ImportJob expired. Only present if state is EXPIRED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireEventTime;

  /**
   * Output only. The time at which this ImportJob is scheduled for expiration and can no longer be
   * used to import key material.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Output only. The time this ImportJob's key material was generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String generateTime;

  /**
   * Required. Immutable. The wrapping method to be used for incoming key material.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String importMethod;

  /**
   * Output only. The resource name for this ImportJob in the format
   * `projects/locations/keyRings/importJobs`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. Immutable. The protection level of the ImportJob. This must match the
   * protection_level of the version_template on the CryptoKey you attempt to import into.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protectionLevel;

  /**
   * Output only. The public key with which to wrap key material prior to import. Only returned if
   * state is ACTIVE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WrappingPublicKey publicKey;

  /**
   * Output only. The current state of the ImportJob, indicating if it can be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. Statement that was generated and signed by the key creator (for example, an HSM)
   * at key creation time. Use this statement to verify attributes of the key as stored on the HSM,
   * independently of Google. Only present if the chosen ImportMethod is one with a protection level
   * of HSM.
   * @return value or {@code null} for none
   */
  public KeyOperationAttestation getAttestation() {
    return attestation;
  }

  /**
   * Output only. Statement that was generated and signed by the key creator (for example, an HSM)
   * at key creation time. Use this statement to verify attributes of the key as stored on the HSM,
   * independently of Google. Only present if the chosen ImportMethod is one with a protection level
   * of HSM.
   * @param attestation attestation or {@code null} for none
   */
  public ImportJob setAttestation(KeyOperationAttestation attestation) {
    this.attestation = attestation;
    return this;
  }

  /**
   * Output only. The time at which this ImportJob was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time at which this ImportJob was created.
   * @param createTime createTime or {@code null} for none
   */
  public ImportJob setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The time this ImportJob expired. Only present if state is EXPIRED.
   * @return value or {@code null} for none
   */
  public String getExpireEventTime() {
    return expireEventTime;
  }

  /**
   * Output only. The time this ImportJob expired. Only present if state is EXPIRED.
   * @param expireEventTime expireEventTime or {@code null} for none
   */
  public ImportJob setExpireEventTime(String expireEventTime) {
    this.expireEventTime = expireEventTime;
    return this;
  }

  /**
   * Output only. The time at which this ImportJob is scheduled for expiration and can no longer be
   * used to import key material.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Output only. The time at which this ImportJob is scheduled for expiration and can no longer be
   * used to import key material.
   * @param expireTime expireTime or {@code null} for none
   */
  public ImportJob setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Output only. The time this ImportJob's key material was generated.
   * @return value or {@code null} for none
   */
  public String getGenerateTime() {
    return generateTime;
  }

  /**
   * Output only. The time this ImportJob's key material was generated.
   * @param generateTime generateTime or {@code null} for none
   */
  public ImportJob setGenerateTime(String generateTime) {
    this.generateTime = generateTime;
    return this;
  }

  /**
   * Required. Immutable. The wrapping method to be used for incoming key material.
   * @return value or {@code null} for none
   */
  public java.lang.String getImportMethod() {
    return importMethod;
  }

  /**
   * Required. Immutable. The wrapping method to be used for incoming key material.
   * @param importMethod importMethod or {@code null} for none
   */
  public ImportJob setImportMethod(java.lang.String importMethod) {
    this.importMethod = importMethod;
    return this;
  }

  /**
   * Output only. The resource name for this ImportJob in the format
   * `projects/locations/keyRings/importJobs`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name for this ImportJob in the format
   * `projects/locations/keyRings/importJobs`.
   * @param name name or {@code null} for none
   */
  public ImportJob setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. Immutable. The protection level of the ImportJob. This must match the
   * protection_level of the version_template on the CryptoKey you attempt to import into.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtectionLevel() {
    return protectionLevel;
  }

  /**
   * Required. Immutable. The protection level of the ImportJob. This must match the
   * protection_level of the version_template on the CryptoKey you attempt to import into.
   * @param protectionLevel protectionLevel or {@code null} for none
   */
  public ImportJob setProtectionLevel(java.lang.String protectionLevel) {
    this.protectionLevel = protectionLevel;
    return this;
  }

  /**
   * Output only. The public key with which to wrap key material prior to import. Only returned if
   * state is ACTIVE.
   * @return value or {@code null} for none
   */
  public WrappingPublicKey getPublicKey() {
    return publicKey;
  }

  /**
   * Output only. The public key with which to wrap key material prior to import. Only returned if
   * state is ACTIVE.
   * @param publicKey publicKey or {@code null} for none
   */
  public ImportJob setPublicKey(WrappingPublicKey publicKey) {
    this.publicKey = publicKey;
    return this;
  }

  /**
   * Output only. The current state of the ImportJob, indicating if it can be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The current state of the ImportJob, indicating if it can be used.
   * @param state state or {@code null} for none
   */
  public ImportJob setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public ImportJob set(String fieldName, Object value) {
    return (ImportJob) super.set(fieldName, value);
  }

  @Override
  public ImportJob clone() {
    return (ImportJob) super.clone();
  }

}
