/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * A KeyRing is a toplevel logical grouping of CryptoKeys.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KeyRing extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time at which this KeyRing was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The resource name for the KeyRing in the format `projects/locations/keyRings`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The time at which this KeyRing was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time at which this KeyRing was created.
   * @param createTime createTime or {@code null} for none
   */
  public KeyRing setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The resource name for the KeyRing in the format `projects/locations/keyRings`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name for the KeyRing in the format `projects/locations/keyRings`.
   * @param name name or {@code null} for none
   */
  public KeyRing setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public KeyRing set(String fieldName, Object value) {
    return (KeyRing) super.set(fieldName, value);
  }

  @Override
  public KeyRing clone() {
    return (KeyRing) super.clone();
  }

}
