/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * A Certificate represents an X.509 certificate used to authenticate HTTPS connections to EKM
 * replicas.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Certificate extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The issuer distinguished name in RFC 2253 format. Only present if parsed is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuer;

  /**
   * Output only. The certificate is not valid after this time. Only present if parsed is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String notAfterTime;

  /**
   * Output only. The certificate is not valid before this time. Only present if parsed is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String notBeforeTime;

  /**
   * Output only. True if the certificate was parsed successfully.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean parsed;

  /**
   * Required. The raw certificate bytes in DER format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rawDer;

  /**
   * Output only. The certificate serial number as a hex string. Only present if parsed is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serialNumber;

  /**
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only present if parsed is
   * true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256Fingerprint;

  /**
   * Output only. The subject distinguished name in RFC 2253 format. Only present if parsed is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subject;

  /**
   * Output only. The subject Alternative DNS names. Only present if parsed is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> subjectAlternativeDnsNames;

  /**
   * Output only. The issuer distinguished name in RFC 2253 format. Only present if parsed is true.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuer() {
    return issuer;
  }

  /**
   * Output only. The issuer distinguished name in RFC 2253 format. Only present if parsed is true.
   * @param issuer issuer or {@code null} for none
   */
  public Certificate setIssuer(java.lang.String issuer) {
    this.issuer = issuer;
    return this;
  }

  /**
   * Output only. The certificate is not valid after this time. Only present if parsed is true.
   * @return value or {@code null} for none
   */
  public String getNotAfterTime() {
    return notAfterTime;
  }

  /**
   * Output only. The certificate is not valid after this time. Only present if parsed is true.
   * @param notAfterTime notAfterTime or {@code null} for none
   */
  public Certificate setNotAfterTime(String notAfterTime) {
    this.notAfterTime = notAfterTime;
    return this;
  }

  /**
   * Output only. The certificate is not valid before this time. Only present if parsed is true.
   * @return value or {@code null} for none
   */
  public String getNotBeforeTime() {
    return notBeforeTime;
  }

  /**
   * Output only. The certificate is not valid before this time. Only present if parsed is true.
   * @param notBeforeTime notBeforeTime or {@code null} for none
   */
  public Certificate setNotBeforeTime(String notBeforeTime) {
    this.notBeforeTime = notBeforeTime;
    return this;
  }

  /**
   * Output only. True if the certificate was parsed successfully.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getParsed() {
    return parsed;
  }

  /**
   * Output only. True if the certificate was parsed successfully.
   * @param parsed parsed or {@code null} for none
   */
  public Certificate setParsed(java.lang.Boolean parsed) {
    this.parsed = parsed;
    return this;
  }

  /**
   * Required. The raw certificate bytes in DER format.
   * @see #decodeRawDer()
   * @return value or {@code null} for none
   */
  public java.lang.String getRawDer() {
    return rawDer;
  }

  /**
   * Required. The raw certificate bytes in DER format.
   * @see #getRawDer()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeRawDer() {
    return com.google.api.client.util.Base64.decodeBase64(rawDer);
  }

  /**
   * Required. The raw certificate bytes in DER format.
   * @see #encodeRawDer()
   * @param rawDer rawDer or {@code null} for none
   */
  public Certificate setRawDer(java.lang.String rawDer) {
    this.rawDer = rawDer;
    return this;
  }

  /**
   * Required. The raw certificate bytes in DER format.
   * @see #setRawDer()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Certificate encodeRawDer(byte[] rawDer) {
    this.rawDer = com.google.api.client.util.Base64.encodeBase64URLSafeString(rawDer);
    return this;
  }

  /**
   * Output only. The certificate serial number as a hex string. Only present if parsed is true.
   * @return value or {@code null} for none
   */
  public java.lang.String getSerialNumber() {
    return serialNumber;
  }

  /**
   * Output only. The certificate serial number as a hex string. Only present if parsed is true.
   * @param serialNumber serialNumber or {@code null} for none
   */
  public Certificate setSerialNumber(java.lang.String serialNumber) {
    this.serialNumber = serialNumber;
    return this;
  }

  /**
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only present if parsed is
   * true.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256Fingerprint() {
    return sha256Fingerprint;
  }

  /**
   * Output only. The SHA-256 certificate fingerprint as a hex string. Only present if parsed is
   * true.
   * @param sha256Fingerprint sha256Fingerprint or {@code null} for none
   */
  public Certificate setSha256Fingerprint(java.lang.String sha256Fingerprint) {
    this.sha256Fingerprint = sha256Fingerprint;
    return this;
  }

  /**
   * Output only. The subject distinguished name in RFC 2253 format. Only present if parsed is true.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubject() {
    return subject;
  }

  /**
   * Output only. The subject distinguished name in RFC 2253 format. Only present if parsed is true.
   * @param subject subject or {@code null} for none
   */
  public Certificate setSubject(java.lang.String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * Output only. The subject Alternative DNS names. Only present if parsed is true.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSubjectAlternativeDnsNames() {
    return subjectAlternativeDnsNames;
  }

  /**
   * Output only. The subject Alternative DNS names. Only present if parsed is true.
   * @param subjectAlternativeDnsNames subjectAlternativeDnsNames or {@code null} for none
   */
  public Certificate setSubjectAlternativeDnsNames(java.util.List<java.lang.String> subjectAlternativeDnsNames) {
    this.subjectAlternativeDnsNames = subjectAlternativeDnsNames;
    return this;
  }

  @Override
  public Certificate set(String fieldName, Object value) {
    return (Certificate) super.set(fieldName, value);
  }

  @Override
  public Certificate clone() {
    return (Certificate) super.clone();
  }

}
