/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Certificate chains needed to verify the attestation. Certificates in chains are PEM-encoded and
 * are ordered based on https://tools.ietf.org/html/rfc5246#section-7.4.2.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CertificateChains extends com.google.api.client.json.GenericJson {

  /**
   * Cavium certificate chain corresponding to the attestation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> caviumCerts;

  /**
   * Google card certificate chain corresponding to the attestation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> googleCardCerts;

  /**
   * Google partition certificate chain corresponding to the attestation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> googlePartitionCerts;

  /**
   * Cavium certificate chain corresponding to the attestation.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCaviumCerts() {
    return caviumCerts;
  }

  /**
   * Cavium certificate chain corresponding to the attestation.
   * @param caviumCerts caviumCerts or {@code null} for none
   */
  public CertificateChains setCaviumCerts(java.util.List<java.lang.String> caviumCerts) {
    this.caviumCerts = caviumCerts;
    return this;
  }

  /**
   * Google card certificate chain corresponding to the attestation.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getGoogleCardCerts() {
    return googleCardCerts;
  }

  /**
   * Google card certificate chain corresponding to the attestation.
   * @param googleCardCerts googleCardCerts or {@code null} for none
   */
  public CertificateChains setGoogleCardCerts(java.util.List<java.lang.String> googleCardCerts) {
    this.googleCardCerts = googleCardCerts;
    return this;
  }

  /**
   * Google partition certificate chain corresponding to the attestation.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getGooglePartitionCerts() {
    return googlePartitionCerts;
  }

  /**
   * Google partition certificate chain corresponding to the attestation.
   * @param googlePartitionCerts googlePartitionCerts or {@code null} for none
   */
  public CertificateChains setGooglePartitionCerts(java.util.List<java.lang.String> googlePartitionCerts) {
    this.googlePartitionCerts = googlePartitionCerts;
    return this;
  }

  @Override
  public CertificateChains set(String fieldName, Object value) {
    return (CertificateChains) super.set(fieldName, value);
  }

  @Override
  public CertificateChains clone() {
    return (CertificateChains) super.clone();
  }

}
