/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Response message for KeyManagementService.Decrypt.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DecryptResponse extends com.google.api.client.json.GenericJson {

  /**
   * The decrypted data originally supplied in EncryptRequest.plaintext.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String plaintext;

  /**
   * Integrity verification field. A CRC32C checksum of the returned DecryptResponse.plaintext. An
   * integrity check of DecryptResponse.plaintext can be performed by computing the CRC32C checksum
   * of DecryptResponse.plaintext and comparing your results to this field. Discard the response in
   * case of non-matching checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: receiving this
   * response message indicates that KeyManagementService is able to successfully decrypt the
   * ciphertext. Note: This field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed 2^32-1, and can be
   * safely downconverted to uint32 in languages that support this type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long plaintextCrc32c;

  /**
   * The ProtectionLevel of the CryptoKeyVersion used in decryption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protectionLevel;

  /**
   * Whether the Decryption was performed using the primary key version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean usedPrimary;

  /**
   * The decrypted data originally supplied in EncryptRequest.plaintext.
   * @see #decodePlaintext()
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaintext() {
    return plaintext;
  }

  /**
   * The decrypted data originally supplied in EncryptRequest.plaintext.
   * @see #getPlaintext()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodePlaintext() {
    return com.google.api.client.util.Base64.decodeBase64(plaintext);
  }

  /**
   * The decrypted data originally supplied in EncryptRequest.plaintext.
   * @see #encodePlaintext()
   * @param plaintext plaintext or {@code null} for none
   */
  public DecryptResponse setPlaintext(java.lang.String plaintext) {
    this.plaintext = plaintext;
    return this;
  }

  /**
   * The decrypted data originally supplied in EncryptRequest.plaintext.
   * @see #setPlaintext()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public DecryptResponse encodePlaintext(byte[] plaintext) {
    this.plaintext = com.google.api.client.util.Base64.encodeBase64URLSafeString(plaintext);
    return this;
  }

  /**
   * Integrity verification field. A CRC32C checksum of the returned DecryptResponse.plaintext. An
   * integrity check of DecryptResponse.plaintext can be performed by computing the CRC32C checksum
   * of DecryptResponse.plaintext and comparing your results to this field. Discard the response in
   * case of non-matching checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: receiving this
   * response message indicates that KeyManagementService is able to successfully decrypt the
   * ciphertext. Note: This field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed 2^32-1, and can be
   * safely downconverted to uint32 in languages that support this type.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPlaintextCrc32c() {
    return plaintextCrc32c;
  }

  /**
   * Integrity verification field. A CRC32C checksum of the returned DecryptResponse.plaintext. An
   * integrity check of DecryptResponse.plaintext can be performed by computing the CRC32C checksum
   * of DecryptResponse.plaintext and comparing your results to this field. Discard the response in
   * case of non-matching checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: receiving this
   * response message indicates that KeyManagementService is able to successfully decrypt the
   * ciphertext. Note: This field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed 2^32-1, and can be
   * safely downconverted to uint32 in languages that support this type.
   * @param plaintextCrc32c plaintextCrc32c or {@code null} for none
   */
  public DecryptResponse setPlaintextCrc32c(java.lang.Long plaintextCrc32c) {
    this.plaintextCrc32c = plaintextCrc32c;
    return this;
  }

  /**
   * The ProtectionLevel of the CryptoKeyVersion used in decryption.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtectionLevel() {
    return protectionLevel;
  }

  /**
   * The ProtectionLevel of the CryptoKeyVersion used in decryption.
   * @param protectionLevel protectionLevel or {@code null} for none
   */
  public DecryptResponse setProtectionLevel(java.lang.String protectionLevel) {
    this.protectionLevel = protectionLevel;
    return this;
  }

  /**
   * Whether the Decryption was performed using the primary key version.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUsedPrimary() {
    return usedPrimary;
  }

  /**
   * Whether the Decryption was performed using the primary key version.
   * @param usedPrimary usedPrimary or {@code null} for none
   */
  public DecryptResponse setUsedPrimary(java.lang.Boolean usedPrimary) {
    this.usedPrimary = usedPrimary;
    return this;
  }

  @Override
  public DecryptResponse set(String fieldName, Object value) {
    return (DecryptResponse) super.set(fieldName, value);
  }

  @Override
  public DecryptResponse clone() {
    return (DecryptResponse) super.clone();
  }

}
