/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * A Digest holds a cryptographic message digest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Digest extends com.google.api.client.json.GenericJson {

  /**
   * A message digest produced with the SHA-256 algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256;

  /**
   * A message digest produced with the SHA-384 algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha384;

  /**
   * A message digest produced with the SHA-512 algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha512;

  /**
   * A message digest produced with the SHA-256 algorithm.
   * @see #decodeSha256()
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256() {
    return sha256;
  }

  /**
   * A message digest produced with the SHA-256 algorithm.
   * @see #getSha256()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSha256() {
    return com.google.api.client.util.Base64.decodeBase64(sha256);
  }

  /**
   * A message digest produced with the SHA-256 algorithm.
   * @see #encodeSha256()
   * @param sha256 sha256 or {@code null} for none
   */
  public Digest setSha256(java.lang.String sha256) {
    this.sha256 = sha256;
    return this;
  }

  /**
   * A message digest produced with the SHA-256 algorithm.
   * @see #setSha256()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Digest encodeSha256(byte[] sha256) {
    this.sha256 = com.google.api.client.util.Base64.encodeBase64URLSafeString(sha256);
    return this;
  }

  /**
   * A message digest produced with the SHA-384 algorithm.
   * @see #decodeSha384()
   * @return value or {@code null} for none
   */
  public java.lang.String getSha384() {
    return sha384;
  }

  /**
   * A message digest produced with the SHA-384 algorithm.
   * @see #getSha384()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSha384() {
    return com.google.api.client.util.Base64.decodeBase64(sha384);
  }

  /**
   * A message digest produced with the SHA-384 algorithm.
   * @see #encodeSha384()
   * @param sha384 sha384 or {@code null} for none
   */
  public Digest setSha384(java.lang.String sha384) {
    this.sha384 = sha384;
    return this;
  }

  /**
   * A message digest produced with the SHA-384 algorithm.
   * @see #setSha384()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Digest encodeSha384(byte[] sha384) {
    this.sha384 = com.google.api.client.util.Base64.encodeBase64URLSafeString(sha384);
    return this;
  }

  /**
   * A message digest produced with the SHA-512 algorithm.
   * @see #decodeSha512()
   * @return value or {@code null} for none
   */
  public java.lang.String getSha512() {
    return sha512;
  }

  /**
   * A message digest produced with the SHA-512 algorithm.
   * @see #getSha512()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSha512() {
    return com.google.api.client.util.Base64.decodeBase64(sha512);
  }

  /**
   * A message digest produced with the SHA-512 algorithm.
   * @see #encodeSha512()
   * @param sha512 sha512 or {@code null} for none
   */
  public Digest setSha512(java.lang.String sha512) {
    this.sha512 = sha512;
    return this;
  }

  /**
   * A message digest produced with the SHA-512 algorithm.
   * @see #setSha512()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Digest encodeSha512(byte[] sha512) {
    this.sha512 = com.google.api.client.util.Base64.encodeBase64URLSafeString(sha512);
    return this;
  }

  @Override
  public Digest set(String fieldName, Object value) {
    return (Digest) super.set(fieldName, value);
  }

  @Override
  public Digest clone() {
    return (Digest) super.clone();
  }

}
