/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * An EkmConnection represents an individual EKM connection. It can be used for creating CryptoKeys
 * and CryptoKeyVersions with a ProtectionLevel of EXTERNAL_VPC, as well as performing cryptographic
 * operations using keys created within the EkmConnection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EkmConnection extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time at which the EkmConnection was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Optional. Etag of the currently stored EkmConnection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Output only. The resource name for the EkmConnection in the format
   * `projects/locations/ekmConnections`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver
   * per EKM replica. Currently, only a single ServiceResolver is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceResolver> serviceResolvers;

  /**
   * Output only. The time at which the EkmConnection was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time at which the EkmConnection was created.
   * @param createTime createTime or {@code null} for none
   */
  public EkmConnection setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Optional. Etag of the currently stored EkmConnection.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Optional. Etag of the currently stored EkmConnection.
   * @param etag etag or {@code null} for none
   */
  public EkmConnection setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Output only. The resource name for the EkmConnection in the format
   * `projects/locations/ekmConnections`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name for the EkmConnection in the format
   * `projects/locations/ekmConnections`.
   * @param name name or {@code null} for none
   */
  public EkmConnection setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver
   * per EKM replica. Currently, only a single ServiceResolver is supported.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceResolver> getServiceResolvers() {
    return serviceResolvers;
  }

  /**
   * A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver
   * per EKM replica. Currently, only a single ServiceResolver is supported.
   * @param serviceResolvers serviceResolvers or {@code null} for none
   */
  public EkmConnection setServiceResolvers(java.util.List<ServiceResolver> serviceResolvers) {
    this.serviceResolvers = serviceResolvers;
    return this;
  }

  @Override
  public EkmConnection set(String fieldName, Object value) {
    return (EkmConnection) super.set(fieldName, value);
  }

  @Override
  public EkmConnection clone() {
    return (EkmConnection) super.clone();
  }

}
