/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Response message for KeyManagementService.Encrypt.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EncryptResponse extends com.google.api.client.json.GenericJson {

  /**
   * The encrypted data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ciphertext;

  /**
   * Integrity verification field. A CRC32C checksum of the returned EncryptResponse.ciphertext. An
   * integrity check of EncryptResponse.ciphertext can be performed by computing the CRC32C checksum
   * of EncryptResponse.ciphertext and comparing your results to this field. Discard the response in
   * case of non-matching checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long ciphertextCrc32c;

  /**
   * The resource name of the CryptoKeyVersion used in encryption. Check this field to verify that
   * the intended resource was used for encryption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ProtectionLevel of the CryptoKeyVersion used in encryption.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protectionLevel;

  /**
   * Integrity verification field. A flag indicating whether
   * EncryptRequest.additional_authenticated_data_crc32c was received by KeyManagementService and
   * used for the integrity verification of the AAD. A false value of this field indicates either
   * that EncryptRequest.additional_authenticated_data_crc32c was left unset or that it was not
   * delivered to KeyManagementService. If you've set
   * EncryptRequest.additional_authenticated_data_crc32c but this field is still false, discard the
   * response and perform a limited number of retries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean verifiedAdditionalAuthenticatedDataCrc32c;

  /**
   * Integrity verification field. A flag indicating whether EncryptRequest.plaintext_crc32c was
   * received by KeyManagementService and used for the integrity verification of the plaintext. A
   * false value of this field indicates either that EncryptRequest.plaintext_crc32c was left unset
   * or that it was not delivered to KeyManagementService. If you've set
   * EncryptRequest.plaintext_crc32c but this field is still false, discard the response and perform
   * a limited number of retries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean verifiedPlaintextCrc32c;

  /**
   * The encrypted data.
   * @see #decodeCiphertext()
   * @return value or {@code null} for none
   */
  public java.lang.String getCiphertext() {
    return ciphertext;
  }

  /**
   * The encrypted data.
   * @see #getCiphertext()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeCiphertext() {
    return com.google.api.client.util.Base64.decodeBase64(ciphertext);
  }

  /**
   * The encrypted data.
   * @see #encodeCiphertext()
   * @param ciphertext ciphertext or {@code null} for none
   */
  public EncryptResponse setCiphertext(java.lang.String ciphertext) {
    this.ciphertext = ciphertext;
    return this;
  }

  /**
   * The encrypted data.
   * @see #setCiphertext()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public EncryptResponse encodeCiphertext(byte[] ciphertext) {
    this.ciphertext = com.google.api.client.util.Base64.encodeBase64URLSafeString(ciphertext);
    return this;
  }

  /**
   * Integrity verification field. A CRC32C checksum of the returned EncryptResponse.ciphertext. An
   * integrity check of EncryptResponse.ciphertext can be performed by computing the CRC32C checksum
   * of EncryptResponse.ciphertext and comparing your results to this field. Discard the response in
   * case of non-matching checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCiphertextCrc32c() {
    return ciphertextCrc32c;
  }

  /**
   * Integrity verification field. A CRC32C checksum of the returned EncryptResponse.ciphertext. An
   * integrity check of EncryptResponse.ciphertext can be performed by computing the CRC32C checksum
   * of EncryptResponse.ciphertext and comparing your results to this field. Discard the response in
   * case of non-matching checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * @param ciphertextCrc32c ciphertextCrc32c or {@code null} for none
   */
  public EncryptResponse setCiphertextCrc32c(java.lang.Long ciphertextCrc32c) {
    this.ciphertextCrc32c = ciphertextCrc32c;
    return this;
  }

  /**
   * The resource name of the CryptoKeyVersion used in encryption. Check this field to verify that
   * the intended resource was used for encryption.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the CryptoKeyVersion used in encryption. Check this field to verify that
   * the intended resource was used for encryption.
   * @param name name or {@code null} for none
   */
  public EncryptResponse setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ProtectionLevel of the CryptoKeyVersion used in encryption.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtectionLevel() {
    return protectionLevel;
  }

  /**
   * The ProtectionLevel of the CryptoKeyVersion used in encryption.
   * @param protectionLevel protectionLevel or {@code null} for none
   */
  public EncryptResponse setProtectionLevel(java.lang.String protectionLevel) {
    this.protectionLevel = protectionLevel;
    return this;
  }

  /**
   * Integrity verification field. A flag indicating whether
   * EncryptRequest.additional_authenticated_data_crc32c was received by KeyManagementService and
   * used for the integrity verification of the AAD. A false value of this field indicates either
   * that EncryptRequest.additional_authenticated_data_crc32c was left unset or that it was not
   * delivered to KeyManagementService. If you've set
   * EncryptRequest.additional_authenticated_data_crc32c but this field is still false, discard the
   * response and perform a limited number of retries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedAdditionalAuthenticatedDataCrc32c() {
    return verifiedAdditionalAuthenticatedDataCrc32c;
  }

  /**
   * Integrity verification field. A flag indicating whether
   * EncryptRequest.additional_authenticated_data_crc32c was received by KeyManagementService and
   * used for the integrity verification of the AAD. A false value of this field indicates either
   * that EncryptRequest.additional_authenticated_data_crc32c was left unset or that it was not
   * delivered to KeyManagementService. If you've set
   * EncryptRequest.additional_authenticated_data_crc32c but this field is still false, discard the
   * response and perform a limited number of retries.
   * @param verifiedAdditionalAuthenticatedDataCrc32c verifiedAdditionalAuthenticatedDataCrc32c or {@code null} for none
   */
  public EncryptResponse setVerifiedAdditionalAuthenticatedDataCrc32c(java.lang.Boolean verifiedAdditionalAuthenticatedDataCrc32c) {
    this.verifiedAdditionalAuthenticatedDataCrc32c = verifiedAdditionalAuthenticatedDataCrc32c;
    return this;
  }

  /**
   * Integrity verification field. A flag indicating whether EncryptRequest.plaintext_crc32c was
   * received by KeyManagementService and used for the integrity verification of the plaintext. A
   * false value of this field indicates either that EncryptRequest.plaintext_crc32c was left unset
   * or that it was not delivered to KeyManagementService. If you've set
   * EncryptRequest.plaintext_crc32c but this field is still false, discard the response and perform
   * a limited number of retries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedPlaintextCrc32c() {
    return verifiedPlaintextCrc32c;
  }

  /**
   * Integrity verification field. A flag indicating whether EncryptRequest.plaintext_crc32c was
   * received by KeyManagementService and used for the integrity verification of the plaintext. A
   * false value of this field indicates either that EncryptRequest.plaintext_crc32c was left unset
   * or that it was not delivered to KeyManagementService. If you've set
   * EncryptRequest.plaintext_crc32c but this field is still false, discard the response and perform
   * a limited number of retries.
   * @param verifiedPlaintextCrc32c verifiedPlaintextCrc32c or {@code null} for none
   */
  public EncryptResponse setVerifiedPlaintextCrc32c(java.lang.Boolean verifiedPlaintextCrc32c) {
    this.verifiedPlaintextCrc32c = verifiedPlaintextCrc32c;
    return this;
  }

  @Override
  public EncryptResponse set(String fieldName, Object value) {
    return (EncryptResponse) super.set(fieldName, value);
  }

  @Override
  public EncryptResponse clone() {
    return (EncryptResponse) super.clone();
  }

}
