/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * ExternalProtectionLevelOptions stores a group of additional fields for configuring a
 * CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection
 * levels.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExternalProtectionLevelOptions extends com.google.api.client.json.GenericJson {

  /**
   * The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key".
   * Set this field instead of external_key_uri when using an EkmConnection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ekmConnectionKeyPath;

  /**
   * The URI for an external resource that this CryptoKeyVersion represents.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalKeyUri;

  /**
   * The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key".
   * Set this field instead of external_key_uri when using an EkmConnection.
   * @return value or {@code null} for none
   */
  public java.lang.String getEkmConnectionKeyPath() {
    return ekmConnectionKeyPath;
  }

  /**
   * The path to the external key material on the EKM when using EkmConnection e.g., "v0/my/key".
   * Set this field instead of external_key_uri when using an EkmConnection.
   * @param ekmConnectionKeyPath ekmConnectionKeyPath or {@code null} for none
   */
  public ExternalProtectionLevelOptions setEkmConnectionKeyPath(java.lang.String ekmConnectionKeyPath) {
    this.ekmConnectionKeyPath = ekmConnectionKeyPath;
    return this;
  }

  /**
   * The URI for an external resource that this CryptoKeyVersion represents.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalKeyUri() {
    return externalKeyUri;
  }

  /**
   * The URI for an external resource that this CryptoKeyVersion represents.
   * @param externalKeyUri externalKeyUri or {@code null} for none
   */
  public ExternalProtectionLevelOptions setExternalKeyUri(java.lang.String externalKeyUri) {
    this.externalKeyUri = externalKeyUri;
    return this;
  }

  @Override
  public ExternalProtectionLevelOptions set(String fieldName, Object value) {
    return (ExternalProtectionLevelOptions) super.set(fieldName, value);
  }

  @Override
  public ExternalProtectionLevelOptions clone() {
    return (ExternalProtectionLevelOptions) super.clone();
  }

}
