/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Cloud KMS metadata for the given google.cloud.location.Location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocationMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether CryptoKeys with protection_level EXTERNAL can be created in this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ekmAvailable;

  /**
   * Indicates whether CryptoKeys with protection_level HSM can be created in this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hsmAvailable;

  /**
   * Indicates whether CryptoKeys with protection_level EXTERNAL can be created in this location.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEkmAvailable() {
    return ekmAvailable;
  }

  /**
   * Indicates whether CryptoKeys with protection_level EXTERNAL can be created in this location.
   * @param ekmAvailable ekmAvailable or {@code null} for none
   */
  public LocationMetadata setEkmAvailable(java.lang.Boolean ekmAvailable) {
    this.ekmAvailable = ekmAvailable;
    return this;
  }

  /**
   * Indicates whether CryptoKeys with protection_level HSM can be created in this location.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHsmAvailable() {
    return hsmAvailable;
  }

  /**
   * Indicates whether CryptoKeys with protection_level HSM can be created in this location.
   * @param hsmAvailable hsmAvailable or {@code null} for none
   */
  public LocationMetadata setHsmAvailable(java.lang.Boolean hsmAvailable) {
    this.hsmAvailable = hsmAvailable;
    return this;
  }

  @Override
  public LocationMetadata set(String fieldName, Object value) {
    return (LocationMetadata) super.set(fieldName, value);
  }

  @Override
  public LocationMetadata clone() {
    return (LocationMetadata) super.clone();
  }

}
