/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Request message for KeyManagementService.MacVerify.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MacVerifyRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The data used previously as a MacSignRequest.data to generate the MAC tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String data;

  /**
   * Optional. An optional CRC32C checksum of the MacVerifyRequest.data. If specified,
   * KeyManagementService will verify the integrity of the received MacVerifyRequest.data using this
   * checksum. KeyManagementService will report an error if the checksum verification fails. If you
   * receive a checksum error, your client should verify that CRC32C(MacVerifyRequest.data) is equal
   * to MacVerifyRequest.data_crc32c, and if so, perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dataCrc32c;

  /**
   * Required. The signature to verify.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mac;

  /**
   * Optional. An optional CRC32C checksum of the MacVerifyRequest.mac. If specified,
   * KeyManagementService will verify the integrity of the received MacVerifyRequest.mac using this
   * checksum. KeyManagementService will report an error if the checksum verification fails. If you
   * receive a checksum error, your client should verify that CRC32C(MacVerifyRequest.tag) is equal
   * to MacVerifyRequest.mac_crc32c, and if so, perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long macCrc32c;

  /**
   * Required. The data used previously as a MacSignRequest.data to generate the MAC tag.
   * @see #decodeData()
   * @return value or {@code null} for none
   */
  public java.lang.String getData() {
    return data;
  }

  /**
   * Required. The data used previously as a MacSignRequest.data to generate the MAC tag.
   * @see #getData()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeData() {
    return com.google.api.client.util.Base64.decodeBase64(data);
  }

  /**
   * Required. The data used previously as a MacSignRequest.data to generate the MAC tag.
   * @see #encodeData()
   * @param data data or {@code null} for none
   */
  public MacVerifyRequest setData(java.lang.String data) {
    this.data = data;
    return this;
  }

  /**
   * Required. The data used previously as a MacSignRequest.data to generate the MAC tag.
   * @see #setData()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public MacVerifyRequest encodeData(byte[] data) {
    this.data = com.google.api.client.util.Base64.encodeBase64URLSafeString(data);
    return this;
  }

  /**
   * Optional. An optional CRC32C checksum of the MacVerifyRequest.data. If specified,
   * KeyManagementService will verify the integrity of the received MacVerifyRequest.data using this
   * checksum. KeyManagementService will report an error if the checksum verification fails. If you
   * receive a checksum error, your client should verify that CRC32C(MacVerifyRequest.data) is equal
   * to MacVerifyRequest.data_crc32c, and if so, perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDataCrc32c() {
    return dataCrc32c;
  }

  /**
   * Optional. An optional CRC32C checksum of the MacVerifyRequest.data. If specified,
   * KeyManagementService will verify the integrity of the received MacVerifyRequest.data using this
   * checksum. KeyManagementService will report an error if the checksum verification fails. If you
   * receive a checksum error, your client should verify that CRC32C(MacVerifyRequest.data) is equal
   * to MacVerifyRequest.data_crc32c, and if so, perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * @param dataCrc32c dataCrc32c or {@code null} for none
   */
  public MacVerifyRequest setDataCrc32c(java.lang.Long dataCrc32c) {
    this.dataCrc32c = dataCrc32c;
    return this;
  }

  /**
   * Required. The signature to verify.
   * @see #decodeMac()
   * @return value or {@code null} for none
   */
  public java.lang.String getMac() {
    return mac;
  }

  /**
   * Required. The signature to verify.
   * @see #getMac()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeMac() {
    return com.google.api.client.util.Base64.decodeBase64(mac);
  }

  /**
   * Required. The signature to verify.
   * @see #encodeMac()
   * @param mac mac or {@code null} for none
   */
  public MacVerifyRequest setMac(java.lang.String mac) {
    this.mac = mac;
    return this;
  }

  /**
   * Required. The signature to verify.
   * @see #setMac()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public MacVerifyRequest encodeMac(byte[] mac) {
    this.mac = com.google.api.client.util.Base64.encodeBase64URLSafeString(mac);
    return this;
  }

  /**
   * Optional. An optional CRC32C checksum of the MacVerifyRequest.mac. If specified,
   * KeyManagementService will verify the integrity of the received MacVerifyRequest.mac using this
   * checksum. KeyManagementService will report an error if the checksum verification fails. If you
   * receive a checksum error, your client should verify that CRC32C(MacVerifyRequest.tag) is equal
   * to MacVerifyRequest.mac_crc32c, and if so, perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMacCrc32c() {
    return macCrc32c;
  }

  /**
   * Optional. An optional CRC32C checksum of the MacVerifyRequest.mac. If specified,
   * KeyManagementService will verify the integrity of the received MacVerifyRequest.mac using this
   * checksum. KeyManagementService will report an error if the checksum verification fails. If you
   * receive a checksum error, your client should verify that CRC32C(MacVerifyRequest.tag) is equal
   * to MacVerifyRequest.mac_crc32c, and if so, perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum. Note: This field is
   * defined as int64 for reasons of compatibility across different languages. However, it is a non-
   * negative integer, which will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * @param macCrc32c macCrc32c or {@code null} for none
   */
  public MacVerifyRequest setMacCrc32c(java.lang.Long macCrc32c) {
    this.macCrc32c = macCrc32c;
    return this;
  }

  @Override
  public MacVerifyRequest set(String fieldName, Object value) {
    return (MacVerifyRequest) super.set(fieldName, value);
  }

  @Override
  public MacVerifyRequest clone() {
    return (MacVerifyRequest) super.clone();
  }

}
