/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.cloudkms.v1.model;

/**
 * Response message for KeyManagementService.MacVerify.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Key Management Service (KMS) API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MacVerifyResponse extends com.google.api.client.json.GenericJson {

  /**
   * The resource name of the CryptoKeyVersion used for verification. Check this field to verify
   * that the intended resource was used for verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ProtectionLevel of the CryptoKeyVersion used for verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protectionLevel;

  /**
   * This field indicates whether or not the verification operation for MacVerifyRequest.mac over
   * MacVerifyRequest.data was successful.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean success;

  /**
   * Integrity verification field. A flag indicating whether MacVerifyRequest.data_crc32c was
   * received by KeyManagementService and used for the integrity verification of the data. A false
   * value of this field indicates either that MacVerifyRequest.data_crc32c was left unset or that
   * it was not delivered to KeyManagementService. If you've set MacVerifyRequest.data_crc32c but
   * this field is still false, discard the response and perform a limited number of retries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean verifiedDataCrc32c;

  /**
   * Integrity verification field. A flag indicating whether MacVerifyRequest.mac_crc32c was
   * received by KeyManagementService and used for the integrity verification of the data. A false
   * value of this field indicates either that MacVerifyRequest.mac_crc32c was left unset or that it
   * was not delivered to KeyManagementService. If you've set MacVerifyRequest.mac_crc32c but this
   * field is still false, discard the response and perform a limited number of retries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean verifiedMacCrc32c;

  /**
   * Integrity verification field. This value is used for the integrity verification of
   * [MacVerifyResponse.success]. If the value of this field contradicts the value of
   * [MacVerifyResponse.success], discard the response and perform a limited number of retries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean verifiedSuccessIntegrity;

  /**
   * The resource name of the CryptoKeyVersion used for verification. Check this field to verify
   * that the intended resource was used for verification.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the CryptoKeyVersion used for verification. Check this field to verify
   * that the intended resource was used for verification.
   * @param name name or {@code null} for none
   */
  public MacVerifyResponse setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ProtectionLevel of the CryptoKeyVersion used for verification.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtectionLevel() {
    return protectionLevel;
  }

  /**
   * The ProtectionLevel of the CryptoKeyVersion used for verification.
   * @param protectionLevel protectionLevel or {@code null} for none
   */
  public MacVerifyResponse setProtectionLevel(java.lang.String protectionLevel) {
    this.protectionLevel = protectionLevel;
    return this;
  }

  /**
   * This field indicates whether or not the verification operation for MacVerifyRequest.mac over
   * MacVerifyRequest.data was successful.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSuccess() {
    return success;
  }

  /**
   * This field indicates whether or not the verification operation for MacVerifyRequest.mac over
   * MacVerifyRequest.data was successful.
   * @param success success or {@code null} for none
   */
  public MacVerifyResponse setSuccess(java.lang.Boolean success) {
    this.success = success;
    return this;
  }

  /**
   * Integrity verification field. A flag indicating whether MacVerifyRequest.data_crc32c was
   * received by KeyManagementService and used for the integrity verification of the data. A false
   * value of this field indicates either that MacVerifyRequest.data_crc32c was left unset or that
   * it was not delivered to KeyManagementService. If you've set MacVerifyRequest.data_crc32c but
   * this field is still false, discard the response and perform a limited number of retries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedDataCrc32c() {
    return verifiedDataCrc32c;
  }

  /**
   * Integrity verification field. A flag indicating whether MacVerifyRequest.data_crc32c was
   * received by KeyManagementService and used for the integrity verification of the data. A false
   * value of this field indicates either that MacVerifyRequest.data_crc32c was left unset or that
   * it was not delivered to KeyManagementService. If you've set MacVerifyRequest.data_crc32c but
   * this field is still false, discard the response and perform a limited number of retries.
   * @param verifiedDataCrc32c verifiedDataCrc32c or {@code null} for none
   */
  public MacVerifyResponse setVerifiedDataCrc32c(java.lang.Boolean verifiedDataCrc32c) {
    this.verifiedDataCrc32c = verifiedDataCrc32c;
    return this;
  }

  /**
   * Integrity verification field. A flag indicating whether MacVerifyRequest.mac_crc32c was
   * received by KeyManagementService and used for the integrity verification of the data. A false
   * value of this field indicates either that MacVerifyRequest.mac_crc32c was left unset or that it
   * was not delivered to KeyManagementService. If you've set MacVerifyRequest.mac_crc32c but this
   * field is still false, discard the response and perform a limited number of retries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedMacCrc32c() {
    return verifiedMacCrc32c;
  }

  /**
   * Integrity verification field. A flag indicating whether MacVerifyRequest.mac_crc32c was
   * received by KeyManagementService and used for the integrity verification of the data. A false
   * value of this field indicates either that MacVerifyRequest.mac_crc32c was left unset or that it
   * was not delivered to KeyManagementService. If you've set MacVerifyRequest.mac_crc32c but this
   * field is still false, discard the response and perform a limited number of retries.
   * @param verifiedMacCrc32c verifiedMacCrc32c or {@code null} for none
   */
  public MacVerifyResponse setVerifiedMacCrc32c(java.lang.Boolean verifiedMacCrc32c) {
    this.verifiedMacCrc32c = verifiedMacCrc32c;
    return this;
  }

  /**
   * Integrity verification field. This value is used for the integrity verification of
   * [MacVerifyResponse.success]. If the value of this field contradicts the value of
   * [MacVerifyResponse.success], discard the response and perform a limited number of retries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedSuccessIntegrity() {
    return verifiedSuccessIntegrity;
  }

  /**
   * Integrity verification field. This value is used for the integrity verification of
   * [MacVerifyResponse.success]. If the value of this field contradicts the value of
   * [MacVerifyResponse.success], discard the response and perform a limited number of retries.
   * @param verifiedSuccessIntegrity verifiedSuccessIntegrity or {@code null} for none
   */
  public MacVerifyResponse setVerifiedSuccessIntegrity(java.lang.Boolean verifiedSuccessIntegrity) {
    this.verifiedSuccessIntegrity = verifiedSuccessIntegrity;
    return this;
  }

  @Override
  public MacVerifyResponse set(String fieldName, Object value) {
    return (MacVerifyResponse) super.set(fieldName, value);
  }

  @Override
  public MacVerifyResponse clone() {
    return (MacVerifyResponse) super.clone();
  }

}
