/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudkms.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudkms.v1.CloudKMSRequest;
import com.google.api.services.cloudkms.v1.CloudKMSRequestInitializer;
import com.google.api.services.cloudkms.v1.model.AsymmetricDecryptRequest;
import com.google.api.services.cloudkms.v1.model.AsymmetricDecryptResponse;
import com.google.api.services.cloudkms.v1.model.AsymmetricSignRequest;
import com.google.api.services.cloudkms.v1.model.AsymmetricSignResponse;
import com.google.api.services.cloudkms.v1.model.AutokeyConfig;
import com.google.api.services.cloudkms.v1.model.CryptoKey;
import com.google.api.services.cloudkms.v1.model.CryptoKeyVersion;
import com.google.api.services.cloudkms.v1.model.DecryptRequest;
import com.google.api.services.cloudkms.v1.model.DecryptResponse;
import com.google.api.services.cloudkms.v1.model.DestroyCryptoKeyVersionRequest;
import com.google.api.services.cloudkms.v1.model.EkmConfig;
import com.google.api.services.cloudkms.v1.model.EkmConnection;
import com.google.api.services.cloudkms.v1.model.EncryptRequest;
import com.google.api.services.cloudkms.v1.model.EncryptResponse;
import com.google.api.services.cloudkms.v1.model.GenerateRandomBytesRequest;
import com.google.api.services.cloudkms.v1.model.GenerateRandomBytesResponse;
import com.google.api.services.cloudkms.v1.model.ImportCryptoKeyVersionRequest;
import com.google.api.services.cloudkms.v1.model.ImportJob;
import com.google.api.services.cloudkms.v1.model.KeyHandle;
import com.google.api.services.cloudkms.v1.model.KeyRing;
import com.google.api.services.cloudkms.v1.model.ListCryptoKeyVersionsResponse;
import com.google.api.services.cloudkms.v1.model.ListCryptoKeysResponse;
import com.google.api.services.cloudkms.v1.model.ListEkmConnectionsResponse;
import com.google.api.services.cloudkms.v1.model.ListImportJobsResponse;
import com.google.api.services.cloudkms.v1.model.ListKeyHandlesResponse;
import com.google.api.services.cloudkms.v1.model.ListKeyRingsResponse;
import com.google.api.services.cloudkms.v1.model.ListLocationsResponse;
import com.google.api.services.cloudkms.v1.model.Location;
import com.google.api.services.cloudkms.v1.model.MacSignRequest;
import com.google.api.services.cloudkms.v1.model.MacSignResponse;
import com.google.api.services.cloudkms.v1.model.MacVerifyRequest;
import com.google.api.services.cloudkms.v1.model.MacVerifyResponse;
import com.google.api.services.cloudkms.v1.model.Operation;
import com.google.api.services.cloudkms.v1.model.Policy;
import com.google.api.services.cloudkms.v1.model.PublicKey;
import com.google.api.services.cloudkms.v1.model.RawDecryptRequest;
import com.google.api.services.cloudkms.v1.model.RawDecryptResponse;
import com.google.api.services.cloudkms.v1.model.RawEncryptRequest;
import com.google.api.services.cloudkms.v1.model.RawEncryptResponse;
import com.google.api.services.cloudkms.v1.model.RestoreCryptoKeyVersionRequest;
import com.google.api.services.cloudkms.v1.model.SetIamPolicyRequest;
import com.google.api.services.cloudkms.v1.model.ShowEffectiveAutokeyConfigResponse;
import com.google.api.services.cloudkms.v1.model.TestIamPermissionsRequest;
import com.google.api.services.cloudkms.v1.model.TestIamPermissionsResponse;
import com.google.api.services.cloudkms.v1.model.UpdateCryptoKeyPrimaryVersionRequest;
import com.google.api.services.cloudkms.v1.model.VerifyConnectivityResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudKMS
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudkms.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://cloudkms.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudkms.googleapis.com/";

    public CloudKMS(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudKMS(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Folders folders() {
        return new Folders();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Key Management Service (KMS) API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudKMS.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://cloudkms.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudKMS.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudKMS.DEFAULT_BATCH_PATH);
        }

        public CloudKMS build() {
            return new CloudKMS(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudKMSRequestInitializer(CloudKMSRequestInitializer cloudkmsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudkmsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Projects {
        public ShowEffectiveAutokeyConfig showEffectiveAutokeyConfig(String parent) throws IOException {
            ShowEffectiveAutokeyConfig result = new ShowEffectiveAutokeyConfig(parent);
            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public GenerateRandomBytes generateRandomBytes(String location, GenerateRandomBytesRequest content) throws IOException {
                GenerateRandomBytes result = new GenerateRandomBytes(location, content);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetEkmConfig getEkmConfig(String name) throws IOException {
                GetEkmConfig result = new GetEkmConfig(name);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateEkmConfig updateEkmConfig(String name, com.google.api.services.cloudkms.v1.model.EkmConfig content) throws IOException {
                UpdateEkmConfig result = new UpdateEkmConfig(name, content);
                CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public EkmConfig ekmConfig() {
                return new EkmConfig();
            }

            public EkmConnections ekmConnections() {
                return new EkmConnections();
            }

            public KeyHandles keyHandles() {
                return new KeyHandles();
            }

            public KeyRings keyRings() {
                return new KeyRings();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Get
                extends CloudKMSRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudKMS.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class KeyRings {
                public Create create(String parent, KeyRing content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public CryptoKeys cryptoKeys() {
                    return new CryptoKeys();
                }

                public ImportJobs importJobs() {
                    return new ImportJobs();
                }

                public class ImportJobs {
                    public Create create(String parent, ImportJob content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class TestIamPermissions
                    extends CloudKMSRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends CloudKMSRequest<Policy> {
                        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudKMSRequest<ListImportJobsResponse> {
                        private static final String REST_PATH = "v1/{+parent}/importJobs";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(CloudKMS.this, "GET", REST_PATH, null, ListImportJobsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends CloudKMSRequest<Policy> {
                        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;
                        @Key(value="options.requestedPolicyVersion")
                        private Integer optionsRequestedPolicyVersion;

                        protected GetIamPolicy(String resource) {
                            super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        public Integer getOptionsRequestedPolicyVersion() {
                            return this.optionsRequestedPolicyVersion;
                        }

                        public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudKMSRequest<ImportJob> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudKMS.this, "GET", REST_PATH, null, ImportJob.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/importJobs/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudKMSRequest<ImportJob> {
                        private static final String REST_PATH = "v1/{+parent}/importJobs";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String importJobId;

                        protected Create(String parent, ImportJob content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, ImportJob.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getImportJobId() {
                            return this.importJobId;
                        }

                        public Create setImportJobId(String importJobId) {
                            this.importJobId = importJobId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class CryptoKeys {
                    public Create create(String parent, CryptoKey content) throws IOException {
                        Create result = new Create(parent, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Decrypt decrypt(String name, DecryptRequest content) throws IOException {
                        Decrypt result = new Decrypt(name, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Encrypt encrypt(String name, EncryptRequest content) throws IOException {
                        Encrypt result = new Encrypt(name, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, CryptoKey content) throws IOException {
                        Patch result = new Patch(name, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public UpdatePrimaryVersion updatePrimaryVersion(String name, UpdateCryptoKeyPrimaryVersionRequest content) throws IOException {
                        UpdatePrimaryVersion result = new UpdatePrimaryVersion(name, content);
                        CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public CryptoKeyVersions cryptoKeyVersions() {
                        return new CryptoKeyVersions();
                    }

                    public class CryptoKeyVersions {
                        public AsymmetricDecrypt asymmetricDecrypt(String name, AsymmetricDecryptRequest content) throws IOException {
                            AsymmetricDecrypt result = new AsymmetricDecrypt(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public AsymmetricSign asymmetricSign(String name, AsymmetricSignRequest content) throws IOException {
                            AsymmetricSign result = new AsymmetricSign(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Create create(String parent, CryptoKeyVersion content) throws IOException {
                            Create result = new Create(parent, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Destroy destroy(String name, DestroyCryptoKeyVersionRequest content) throws IOException {
                            Destroy result = new Destroy(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Get get(String name) throws IOException {
                            Get result = new Get(name);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public GetPublicKey getPublicKey(String name) throws IOException {
                            GetPublicKey result = new GetPublicKey(name);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public CloudKMSImport cloudkmsImport(String parent, ImportCryptoKeyVersionRequest content) throws IOException {
                            CloudKMSImport result = new CloudKMSImport(parent, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String parent) throws IOException {
                            List result = new List(parent);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public MacSign macSign(String name, MacSignRequest content) throws IOException {
                            MacSign result = new MacSign(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public MacVerify macVerify(String name, MacVerifyRequest content) throws IOException {
                            MacVerify result = new MacVerify(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Patch patch(String name, CryptoKeyVersion content) throws IOException {
                            Patch result = new Patch(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public RawDecrypt rawDecrypt(String name, RawDecryptRequest content) throws IOException {
                            RawDecrypt result = new RawDecrypt(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public RawEncrypt rawEncrypt(String name, RawEncryptRequest content) throws IOException {
                            RawEncrypt result = new RawEncrypt(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Restore restore(String name, RestoreCryptoKeyVersionRequest content) throws IOException {
                            Restore result = new Restore(name, content);
                            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Restore
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}:restore";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Restore(String name, RestoreCryptoKeyVersionRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public Restore set$Xgafv(String $Xgafv) {
                                return (Restore)super.set$Xgafv($Xgafv);
                            }

                            public Restore setAccessToken(String accessToken) {
                                return (Restore)super.setAccessToken(accessToken);
                            }

                            public Restore setAlt(String alt) {
                                return (Restore)super.setAlt(alt);
                            }

                            public Restore setCallback(String callback) {
                                return (Restore)super.setCallback(callback);
                            }

                            public Restore setFields(String fields) {
                                return (Restore)super.setFields(fields);
                            }

                            public Restore setKey(String key) {
                                return (Restore)super.setKey(key);
                            }

                            public Restore setOauthToken(String oauthToken) {
                                return (Restore)super.setOauthToken(oauthToken);
                            }

                            public Restore setPrettyPrint(Boolean prettyPrint) {
                                return (Restore)super.setPrettyPrint(prettyPrint);
                            }

                            public Restore setQuotaUser(String quotaUser) {
                                return (Restore)super.setQuotaUser(quotaUser);
                            }

                            public Restore setUploadType(String uploadType) {
                                return (Restore)super.setUploadType(uploadType);
                            }

                            public Restore setUploadProtocol(String uploadProtocol) {
                                return (Restore)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Restore setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Restore set(String parameterName, Object value) {
                                return (Restore)super.set(parameterName, value);
                            }
                        }

                        public class RawEncrypt
                        extends CloudKMSRequest<RawEncryptResponse> {
                            private static final String REST_PATH = "v1/{+name}:rawEncrypt";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected RawEncrypt(String name, RawEncryptRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, RawEncryptResponse.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public RawEncrypt set$Xgafv(String $Xgafv) {
                                return (RawEncrypt)super.set$Xgafv($Xgafv);
                            }

                            public RawEncrypt setAccessToken(String accessToken) {
                                return (RawEncrypt)super.setAccessToken(accessToken);
                            }

                            public RawEncrypt setAlt(String alt) {
                                return (RawEncrypt)super.setAlt(alt);
                            }

                            public RawEncrypt setCallback(String callback) {
                                return (RawEncrypt)super.setCallback(callback);
                            }

                            public RawEncrypt setFields(String fields) {
                                return (RawEncrypt)super.setFields(fields);
                            }

                            public RawEncrypt setKey(String key) {
                                return (RawEncrypt)super.setKey(key);
                            }

                            public RawEncrypt setOauthToken(String oauthToken) {
                                return (RawEncrypt)super.setOauthToken(oauthToken);
                            }

                            public RawEncrypt setPrettyPrint(Boolean prettyPrint) {
                                return (RawEncrypt)super.setPrettyPrint(prettyPrint);
                            }

                            public RawEncrypt setQuotaUser(String quotaUser) {
                                return (RawEncrypt)super.setQuotaUser(quotaUser);
                            }

                            public RawEncrypt setUploadType(String uploadType) {
                                return (RawEncrypt)super.setUploadType(uploadType);
                            }

                            public RawEncrypt setUploadProtocol(String uploadProtocol) {
                                return (RawEncrypt)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public RawEncrypt setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public RawEncrypt set(String parameterName, Object value) {
                                return (RawEncrypt)super.set(parameterName, value);
                            }
                        }

                        public class RawDecrypt
                        extends CloudKMSRequest<RawDecryptResponse> {
                            private static final String REST_PATH = "v1/{+name}:rawDecrypt";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected RawDecrypt(String name, RawDecryptRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, RawDecryptResponse.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public RawDecrypt set$Xgafv(String $Xgafv) {
                                return (RawDecrypt)super.set$Xgafv($Xgafv);
                            }

                            public RawDecrypt setAccessToken(String accessToken) {
                                return (RawDecrypt)super.setAccessToken(accessToken);
                            }

                            public RawDecrypt setAlt(String alt) {
                                return (RawDecrypt)super.setAlt(alt);
                            }

                            public RawDecrypt setCallback(String callback) {
                                return (RawDecrypt)super.setCallback(callback);
                            }

                            public RawDecrypt setFields(String fields) {
                                return (RawDecrypt)super.setFields(fields);
                            }

                            public RawDecrypt setKey(String key) {
                                return (RawDecrypt)super.setKey(key);
                            }

                            public RawDecrypt setOauthToken(String oauthToken) {
                                return (RawDecrypt)super.setOauthToken(oauthToken);
                            }

                            public RawDecrypt setPrettyPrint(Boolean prettyPrint) {
                                return (RawDecrypt)super.setPrettyPrint(prettyPrint);
                            }

                            public RawDecrypt setQuotaUser(String quotaUser) {
                                return (RawDecrypt)super.setQuotaUser(quotaUser);
                            }

                            public RawDecrypt setUploadType(String uploadType) {
                                return (RawDecrypt)super.setUploadType(uploadType);
                            }

                            public RawDecrypt setUploadProtocol(String uploadProtocol) {
                                return (RawDecrypt)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public RawDecrypt setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public RawDecrypt set(String parameterName, Object value) {
                                return (RawDecrypt)super.set(parameterName, value);
                            }
                        }

                        public class Patch
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;
                            @Key
                            private String updateMask;

                            protected Patch(String name, CryptoKeyVersion content) {
                                super(CloudKMS.this, "PATCH", REST_PATH, (Object)content, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public Patch set$Xgafv(String $Xgafv) {
                                return (Patch)super.set$Xgafv($Xgafv);
                            }

                            public Patch setAccessToken(String accessToken) {
                                return (Patch)super.setAccessToken(accessToken);
                            }

                            public Patch setAlt(String alt) {
                                return (Patch)super.setAlt(alt);
                            }

                            public Patch setCallback(String callback) {
                                return (Patch)super.setCallback(callback);
                            }

                            public Patch setFields(String fields) {
                                return (Patch)super.setFields(fields);
                            }

                            public Patch setKey(String key) {
                                return (Patch)super.setKey(key);
                            }

                            public Patch setOauthToken(String oauthToken) {
                                return (Patch)super.setOauthToken(oauthToken);
                            }

                            public Patch setPrettyPrint(Boolean prettyPrint) {
                                return (Patch)super.setPrettyPrint(prettyPrint);
                            }

                            public Patch setQuotaUser(String quotaUser) {
                                return (Patch)super.setQuotaUser(quotaUser);
                            }

                            public Patch setUploadType(String uploadType) {
                                return (Patch)super.setUploadType(uploadType);
                            }

                            public Patch setUploadProtocol(String uploadProtocol) {
                                return (Patch)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Patch setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            public String getUpdateMask() {
                                return this.updateMask;
                            }

                            public Patch setUpdateMask(String updateMask) {
                                this.updateMask = updateMask;
                                return this;
                            }

                            @Override
                            public Patch set(String parameterName, Object value) {
                                return (Patch)super.set(parameterName, value);
                            }
                        }

                        public class MacVerify
                        extends CloudKMSRequest<MacVerifyResponse> {
                            private static final String REST_PATH = "v1/{+name}:macVerify";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected MacVerify(String name, MacVerifyRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, MacVerifyResponse.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public MacVerify set$Xgafv(String $Xgafv) {
                                return (MacVerify)super.set$Xgafv($Xgafv);
                            }

                            public MacVerify setAccessToken(String accessToken) {
                                return (MacVerify)super.setAccessToken(accessToken);
                            }

                            public MacVerify setAlt(String alt) {
                                return (MacVerify)super.setAlt(alt);
                            }

                            public MacVerify setCallback(String callback) {
                                return (MacVerify)super.setCallback(callback);
                            }

                            public MacVerify setFields(String fields) {
                                return (MacVerify)super.setFields(fields);
                            }

                            public MacVerify setKey(String key) {
                                return (MacVerify)super.setKey(key);
                            }

                            public MacVerify setOauthToken(String oauthToken) {
                                return (MacVerify)super.setOauthToken(oauthToken);
                            }

                            public MacVerify setPrettyPrint(Boolean prettyPrint) {
                                return (MacVerify)super.setPrettyPrint(prettyPrint);
                            }

                            public MacVerify setQuotaUser(String quotaUser) {
                                return (MacVerify)super.setQuotaUser(quotaUser);
                            }

                            public MacVerify setUploadType(String uploadType) {
                                return (MacVerify)super.setUploadType(uploadType);
                            }

                            public MacVerify setUploadProtocol(String uploadProtocol) {
                                return (MacVerify)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public MacVerify setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public MacVerify set(String parameterName, Object value) {
                                return (MacVerify)super.set(parameterName, value);
                            }
                        }

                        public class MacSign
                        extends CloudKMSRequest<MacSignResponse> {
                            private static final String REST_PATH = "v1/{+name}:macSign";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected MacSign(String name, MacSignRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, MacSignResponse.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public MacSign set$Xgafv(String $Xgafv) {
                                return (MacSign)super.set$Xgafv($Xgafv);
                            }

                            public MacSign setAccessToken(String accessToken) {
                                return (MacSign)super.setAccessToken(accessToken);
                            }

                            public MacSign setAlt(String alt) {
                                return (MacSign)super.setAlt(alt);
                            }

                            public MacSign setCallback(String callback) {
                                return (MacSign)super.setCallback(callback);
                            }

                            public MacSign setFields(String fields) {
                                return (MacSign)super.setFields(fields);
                            }

                            public MacSign setKey(String key) {
                                return (MacSign)super.setKey(key);
                            }

                            public MacSign setOauthToken(String oauthToken) {
                                return (MacSign)super.setOauthToken(oauthToken);
                            }

                            public MacSign setPrettyPrint(Boolean prettyPrint) {
                                return (MacSign)super.setPrettyPrint(prettyPrint);
                            }

                            public MacSign setQuotaUser(String quotaUser) {
                                return (MacSign)super.setQuotaUser(quotaUser);
                            }

                            public MacSign setUploadType(String uploadType) {
                                return (MacSign)super.setUploadType(uploadType);
                            }

                            public MacSign setUploadProtocol(String uploadProtocol) {
                                return (MacSign)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public MacSign setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public MacSign set(String parameterName, Object value) {
                                return (MacSign)super.set(parameterName, value);
                            }
                        }

                        public class List
                        extends CloudKMSRequest<ListCryptoKeyVersionsResponse> {
                            private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;
                            @Key
                            private String filter;
                            @Key
                            private String orderBy;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;
                            @Key
                            private String view;

                            protected List(String parent) {
                                super(CloudKMS.this, "GET", REST_PATH, null, ListCryptoKeyVersionsResponse.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public List setParent(String parent) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            public String getFilter() {
                                return this.filter;
                            }

                            public List setFilter(String filter) {
                                this.filter = filter;
                                return this;
                            }

                            public String getOrderBy() {
                                return this.orderBy;
                            }

                            public List setOrderBy(String orderBy) {
                                this.orderBy = orderBy;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            public String getView() {
                                return this.view;
                            }

                            public List setView(String view) {
                                this.view = view;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class CloudKMSImport
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions:import";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected CloudKMSImport(String parent, ImportCryptoKeyVersionRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, CryptoKeyVersion.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                            }

                            public CloudKMSImport set$Xgafv(String $Xgafv) {
                                return (CloudKMSImport)super.set$Xgafv($Xgafv);
                            }

                            public CloudKMSImport setAccessToken(String accessToken) {
                                return (CloudKMSImport)super.setAccessToken(accessToken);
                            }

                            public CloudKMSImport setAlt(String alt) {
                                return (CloudKMSImport)super.setAlt(alt);
                            }

                            public CloudKMSImport setCallback(String callback) {
                                return (CloudKMSImport)super.setCallback(callback);
                            }

                            public CloudKMSImport setFields(String fields) {
                                return (CloudKMSImport)super.setFields(fields);
                            }

                            public CloudKMSImport setKey(String key) {
                                return (CloudKMSImport)super.setKey(key);
                            }

                            public CloudKMSImport setOauthToken(String oauthToken) {
                                return (CloudKMSImport)super.setOauthToken(oauthToken);
                            }

                            public CloudKMSImport setPrettyPrint(Boolean prettyPrint) {
                                return (CloudKMSImport)super.setPrettyPrint(prettyPrint);
                            }

                            public CloudKMSImport setQuotaUser(String quotaUser) {
                                return (CloudKMSImport)super.setQuotaUser(quotaUser);
                            }

                            public CloudKMSImport setUploadType(String uploadType) {
                                return (CloudKMSImport)super.setUploadType(uploadType);
                            }

                            public CloudKMSImport setUploadProtocol(String uploadProtocol) {
                                return (CloudKMSImport)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public CloudKMSImport setParent(String parent) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public CloudKMSImport set(String parameterName, Object value) {
                                return (CloudKMSImport)super.set(parameterName, value);
                            }
                        }

                        public class GetPublicKey
                        extends CloudKMSRequest<PublicKey> {
                            private static final String REST_PATH = "v1/{+name}/publicKey";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected GetPublicKey(String name) {
                                super(CloudKMS.this, "GET", REST_PATH, null, PublicKey.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public GetPublicKey set$Xgafv(String $Xgafv) {
                                return (GetPublicKey)super.set$Xgafv($Xgafv);
                            }

                            public GetPublicKey setAccessToken(String accessToken) {
                                return (GetPublicKey)super.setAccessToken(accessToken);
                            }

                            public GetPublicKey setAlt(String alt) {
                                return (GetPublicKey)super.setAlt(alt);
                            }

                            public GetPublicKey setCallback(String callback) {
                                return (GetPublicKey)super.setCallback(callback);
                            }

                            public GetPublicKey setFields(String fields) {
                                return (GetPublicKey)super.setFields(fields);
                            }

                            public GetPublicKey setKey(String key) {
                                return (GetPublicKey)super.setKey(key);
                            }

                            public GetPublicKey setOauthToken(String oauthToken) {
                                return (GetPublicKey)super.setOauthToken(oauthToken);
                            }

                            public GetPublicKey setPrettyPrint(Boolean prettyPrint) {
                                return (GetPublicKey)super.setPrettyPrint(prettyPrint);
                            }

                            public GetPublicKey setQuotaUser(String quotaUser) {
                                return (GetPublicKey)super.setQuotaUser(quotaUser);
                            }

                            public GetPublicKey setUploadType(String uploadType) {
                                return (GetPublicKey)super.setUploadType(uploadType);
                            }

                            public GetPublicKey setUploadProtocol(String uploadProtocol) {
                                return (GetPublicKey)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public GetPublicKey setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public GetPublicKey set(String parameterName, Object value) {
                                return (GetPublicKey)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Get(String name) {
                                super(CloudKMS.this, "GET", REST_PATH, null, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Get setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }

                        public class Destroy
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+name}:destroy";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected Destroy(String name, DestroyCryptoKeyVersionRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, CryptoKeyVersion.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public Destroy set$Xgafv(String $Xgafv) {
                                return (Destroy)super.set$Xgafv($Xgafv);
                            }

                            public Destroy setAccessToken(String accessToken) {
                                return (Destroy)super.setAccessToken(accessToken);
                            }

                            public Destroy setAlt(String alt) {
                                return (Destroy)super.setAlt(alt);
                            }

                            public Destroy setCallback(String callback) {
                                return (Destroy)super.setCallback(callback);
                            }

                            public Destroy setFields(String fields) {
                                return (Destroy)super.setFields(fields);
                            }

                            public Destroy setKey(String key) {
                                return (Destroy)super.setKey(key);
                            }

                            public Destroy setOauthToken(String oauthToken) {
                                return (Destroy)super.setOauthToken(oauthToken);
                            }

                            public Destroy setPrettyPrint(Boolean prettyPrint) {
                                return (Destroy)super.setPrettyPrint(prettyPrint);
                            }

                            public Destroy setQuotaUser(String quotaUser) {
                                return (Destroy)super.setQuotaUser(quotaUser);
                            }

                            public Destroy setUploadType(String uploadType) {
                                return (Destroy)super.setUploadType(uploadType);
                            }

                            public Destroy setUploadProtocol(String uploadProtocol) {
                                return (Destroy)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public Destroy setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public Destroy set(String parameterName, Object value) {
                                return (Destroy)super.set(parameterName, value);
                            }
                        }

                        public class Create
                        extends CloudKMSRequest<CryptoKeyVersion> {
                            private static final String REST_PATH = "v1/{+parent}/cryptoKeyVersions";
                            private final Pattern PARENT_PATTERN;
                            @Key
                            private String parent;

                            protected Create(String parent, CryptoKeyVersion content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, CryptoKeyVersion.class);
                                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getParent() {
                                return this.parent;
                            }

                            public Create setParent(String parent) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                                }
                                this.parent = parent;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }

                        public class AsymmetricSign
                        extends CloudKMSRequest<AsymmetricSignResponse> {
                            private static final String REST_PATH = "v1/{+name}:asymmetricSign";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected AsymmetricSign(String name, AsymmetricSignRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, AsymmetricSignResponse.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public AsymmetricSign set$Xgafv(String $Xgafv) {
                                return (AsymmetricSign)super.set$Xgafv($Xgafv);
                            }

                            public AsymmetricSign setAccessToken(String accessToken) {
                                return (AsymmetricSign)super.setAccessToken(accessToken);
                            }

                            public AsymmetricSign setAlt(String alt) {
                                return (AsymmetricSign)super.setAlt(alt);
                            }

                            public AsymmetricSign setCallback(String callback) {
                                return (AsymmetricSign)super.setCallback(callback);
                            }

                            public AsymmetricSign setFields(String fields) {
                                return (AsymmetricSign)super.setFields(fields);
                            }

                            public AsymmetricSign setKey(String key) {
                                return (AsymmetricSign)super.setKey(key);
                            }

                            public AsymmetricSign setOauthToken(String oauthToken) {
                                return (AsymmetricSign)super.setOauthToken(oauthToken);
                            }

                            public AsymmetricSign setPrettyPrint(Boolean prettyPrint) {
                                return (AsymmetricSign)super.setPrettyPrint(prettyPrint);
                            }

                            public AsymmetricSign setQuotaUser(String quotaUser) {
                                return (AsymmetricSign)super.setQuotaUser(quotaUser);
                            }

                            public AsymmetricSign setUploadType(String uploadType) {
                                return (AsymmetricSign)super.setUploadType(uploadType);
                            }

                            public AsymmetricSign setUploadProtocol(String uploadProtocol) {
                                return (AsymmetricSign)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public AsymmetricSign setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public AsymmetricSign set(String parameterName, Object value) {
                                return (AsymmetricSign)super.set(parameterName, value);
                            }
                        }

                        public class AsymmetricDecrypt
                        extends CloudKMSRequest<AsymmetricDecryptResponse> {
                            private static final String REST_PATH = "v1/{+name}:asymmetricDecrypt";
                            private final Pattern NAME_PATTERN;
                            @Key
                            private String name;

                            protected AsymmetricDecrypt(String name, AsymmetricDecryptRequest content) {
                                super(CloudKMS.this, "POST", REST_PATH, (Object)content, AsymmetricDecryptResponse.class);
                                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                            }

                            public AsymmetricDecrypt set$Xgafv(String $Xgafv) {
                                return (AsymmetricDecrypt)super.set$Xgafv($Xgafv);
                            }

                            public AsymmetricDecrypt setAccessToken(String accessToken) {
                                return (AsymmetricDecrypt)super.setAccessToken(accessToken);
                            }

                            public AsymmetricDecrypt setAlt(String alt) {
                                return (AsymmetricDecrypt)super.setAlt(alt);
                            }

                            public AsymmetricDecrypt setCallback(String callback) {
                                return (AsymmetricDecrypt)super.setCallback(callback);
                            }

                            public AsymmetricDecrypt setFields(String fields) {
                                return (AsymmetricDecrypt)super.setFields(fields);
                            }

                            public AsymmetricDecrypt setKey(String key) {
                                return (AsymmetricDecrypt)super.setKey(key);
                            }

                            public AsymmetricDecrypt setOauthToken(String oauthToken) {
                                return (AsymmetricDecrypt)super.setOauthToken(oauthToken);
                            }

                            public AsymmetricDecrypt setPrettyPrint(Boolean prettyPrint) {
                                return (AsymmetricDecrypt)super.setPrettyPrint(prettyPrint);
                            }

                            public AsymmetricDecrypt setQuotaUser(String quotaUser) {
                                return (AsymmetricDecrypt)super.setQuotaUser(quotaUser);
                            }

                            public AsymmetricDecrypt setUploadType(String uploadType) {
                                return (AsymmetricDecrypt)super.setUploadType(uploadType);
                            }

                            public AsymmetricDecrypt setUploadProtocol(String uploadProtocol) {
                                return (AsymmetricDecrypt)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getName() {
                                return this.name;
                            }

                            public AsymmetricDecrypt setName(String name) {
                                if (!CloudKMS.this.getSuppressPatternChecks()) {
                                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+/cryptoKeyVersions/[^/]+$");
                                }
                                this.name = name;
                                return this;
                            }

                            @Override
                            public AsymmetricDecrypt set(String parameterName, Object value) {
                                return (AsymmetricDecrypt)super.set(parameterName, value);
                            }
                        }
                    }

                    public class UpdatePrimaryVersion
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+name}:updatePrimaryVersion";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected UpdatePrimaryVersion(String name, UpdateCryptoKeyPrimaryVersionRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, CryptoKey.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public UpdatePrimaryVersion set$Xgafv(String $Xgafv) {
                            return (UpdatePrimaryVersion)super.set$Xgafv($Xgafv);
                        }

                        public UpdatePrimaryVersion setAccessToken(String accessToken) {
                            return (UpdatePrimaryVersion)super.setAccessToken(accessToken);
                        }

                        public UpdatePrimaryVersion setAlt(String alt) {
                            return (UpdatePrimaryVersion)super.setAlt(alt);
                        }

                        public UpdatePrimaryVersion setCallback(String callback) {
                            return (UpdatePrimaryVersion)super.setCallback(callback);
                        }

                        public UpdatePrimaryVersion setFields(String fields) {
                            return (UpdatePrimaryVersion)super.setFields(fields);
                        }

                        public UpdatePrimaryVersion setKey(String key) {
                            return (UpdatePrimaryVersion)super.setKey(key);
                        }

                        public UpdatePrimaryVersion setOauthToken(String oauthToken) {
                            return (UpdatePrimaryVersion)super.setOauthToken(oauthToken);
                        }

                        public UpdatePrimaryVersion setPrettyPrint(Boolean prettyPrint) {
                            return (UpdatePrimaryVersion)super.setPrettyPrint(prettyPrint);
                        }

                        public UpdatePrimaryVersion setQuotaUser(String quotaUser) {
                            return (UpdatePrimaryVersion)super.setQuotaUser(quotaUser);
                        }

                        public UpdatePrimaryVersion setUploadType(String uploadType) {
                            return (UpdatePrimaryVersion)super.setUploadType(uploadType);
                        }

                        public UpdatePrimaryVersion setUploadProtocol(String uploadProtocol) {
                            return (UpdatePrimaryVersion)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public UpdatePrimaryVersion setName(String name) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public UpdatePrimaryVersion set(String parameterName, Object value) {
                            return (UpdatePrimaryVersion)super.set(parameterName, value);
                        }
                    }

                    public class TestIamPermissions
                    extends CloudKMSRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends CloudKMSRequest<Policy> {
                        private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, CryptoKey content) {
                            super(CloudKMS.this, "PATCH", REST_PATH, (Object)content, CryptoKey.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends CloudKMSRequest<ListCryptoKeysResponse> {
                        private static final String REST_PATH = "v1/{+parent}/cryptoKeys";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;
                        @Key
                        private String versionView;

                        protected List(String parent) {
                            super(CloudKMS.this, "GET", REST_PATH, null, ListCryptoKeysResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public String getVersionView() {
                            return this.versionView;
                        }

                        public List setVersionView(String versionView) {
                            this.versionView = versionView;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends CloudKMSRequest<Policy> {
                        private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;
                        @Key(value="options.requestedPolicyVersion")
                        private Integer optionsRequestedPolicyVersion;

                        protected GetIamPolicy(String resource) {
                            super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        public Integer getOptionsRequestedPolicyVersion() {
                            return this.optionsRequestedPolicyVersion;
                        }

                        public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(CloudKMS.this, "GET", REST_PATH, null, CryptoKey.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Encrypt
                    extends CloudKMSRequest<EncryptResponse> {
                        private static final String REST_PATH = "v1/{+name}:encrypt";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Encrypt(String name, EncryptRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, EncryptResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.*$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.*$");
                            }
                        }

                        public Encrypt set$Xgafv(String $Xgafv) {
                            return (Encrypt)super.set$Xgafv($Xgafv);
                        }

                        public Encrypt setAccessToken(String accessToken) {
                            return (Encrypt)super.setAccessToken(accessToken);
                        }

                        public Encrypt setAlt(String alt) {
                            return (Encrypt)super.setAlt(alt);
                        }

                        public Encrypt setCallback(String callback) {
                            return (Encrypt)super.setCallback(callback);
                        }

                        public Encrypt setFields(String fields) {
                            return (Encrypt)super.setFields(fields);
                        }

                        public Encrypt setKey(String key) {
                            return (Encrypt)super.setKey(key);
                        }

                        public Encrypt setOauthToken(String oauthToken) {
                            return (Encrypt)super.setOauthToken(oauthToken);
                        }

                        public Encrypt setPrettyPrint(Boolean prettyPrint) {
                            return (Encrypt)super.setPrettyPrint(prettyPrint);
                        }

                        public Encrypt setQuotaUser(String quotaUser) {
                            return (Encrypt)super.setQuotaUser(quotaUser);
                        }

                        public Encrypt setUploadType(String uploadType) {
                            return (Encrypt)super.setUploadType(uploadType);
                        }

                        public Encrypt setUploadProtocol(String uploadProtocol) {
                            return (Encrypt)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Encrypt setName(String name) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/.*$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Encrypt set(String parameterName, Object value) {
                            return (Encrypt)super.set(parameterName, value);
                        }
                    }

                    public class Decrypt
                    extends CloudKMSRequest<DecryptResponse> {
                        private static final String REST_PATH = "v1/{+name}:decrypt";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Decrypt(String name, DecryptRequest content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, DecryptResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                        }

                        public Decrypt set$Xgafv(String $Xgafv) {
                            return (Decrypt)super.set$Xgafv($Xgafv);
                        }

                        public Decrypt setAccessToken(String accessToken) {
                            return (Decrypt)super.setAccessToken(accessToken);
                        }

                        public Decrypt setAlt(String alt) {
                            return (Decrypt)super.setAlt(alt);
                        }

                        public Decrypt setCallback(String callback) {
                            return (Decrypt)super.setCallback(callback);
                        }

                        public Decrypt setFields(String fields) {
                            return (Decrypt)super.setFields(fields);
                        }

                        public Decrypt setKey(String key) {
                            return (Decrypt)super.setKey(key);
                        }

                        public Decrypt setOauthToken(String oauthToken) {
                            return (Decrypt)super.setOauthToken(oauthToken);
                        }

                        public Decrypt setPrettyPrint(Boolean prettyPrint) {
                            return (Decrypt)super.setPrettyPrint(prettyPrint);
                        }

                        public Decrypt setQuotaUser(String quotaUser) {
                            return (Decrypt)super.setQuotaUser(quotaUser);
                        }

                        public Decrypt setUploadType(String uploadType) {
                            return (Decrypt)super.setUploadType(uploadType);
                        }

                        public Decrypt setUploadProtocol(String uploadProtocol) {
                            return (Decrypt)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Decrypt setName(String name) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+/cryptoKeys/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Decrypt set(String parameterName, Object value) {
                            return (Decrypt)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends CloudKMSRequest<CryptoKey> {
                        private static final String REST_PATH = "v1/{+parent}/cryptoKeys";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String cryptoKeyId;
                        @Key
                        private Boolean skipInitialVersionCreation;

                        protected Create(String parent, CryptoKey content) {
                            super(CloudKMS.this, "POST", REST_PATH, (Object)content, CryptoKey.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!CloudKMS.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getCryptoKeyId() {
                            return this.cryptoKeyId;
                        }

                        public Create setCryptoKeyId(String cryptoKeyId) {
                            this.cryptoKeyId = cryptoKeyId;
                            return this;
                        }

                        public Boolean getSkipInitialVersionCreation() {
                            return this.skipInitialVersionCreation;
                        }

                        public Create setSkipInitialVersionCreation(Boolean skipInitialVersionCreation) {
                            this.skipInitialVersionCreation = skipInitialVersionCreation;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class TestIamPermissions
                extends CloudKMSRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudKMSRequest<ListKeyRingsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/keyRings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudKMS.this, "GET", REST_PATH, null, ListKeyRingsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudKMSRequest<KeyRing> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudKMS.this, "GET", REST_PATH, null, KeyRing.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyRings/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudKMSRequest<KeyRing> {
                    private static final String REST_PATH = "v1/{+parent}/keyRings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String keyRingId;

                    protected Create(String parent, KeyRing content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, KeyRing.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getKeyRingId() {
                        return this.keyRingId;
                    }

                    public Create setKeyRingId(String keyRingId) {
                        this.keyRingId = keyRingId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class KeyHandles {
                public Create create(String parent, KeyHandle content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudKMSRequest<ListKeyHandlesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/keyHandles";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;

                    protected List(String parent) {
                        super(CloudKMS.this, "GET", REST_PATH, null, ListKeyHandlesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudKMSRequest<KeyHandle> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudKMS.this, "GET", REST_PATH, null, KeyHandle.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/keyHandles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyHandles/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/keyHandles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudKMSRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/keyHandles";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String keyHandleId;

                    protected Create(String parent, KeyHandle content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getKeyHandleId() {
                        return this.keyHandleId;
                    }

                    public Create setKeyHandleId(String keyHandleId) {
                        this.keyHandleId = keyHandleId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class EkmConnections {
                public Create create(String parent, EkmConnection content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, EkmConnection content) throws IOException {
                    Patch result = new Patch(name, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public VerifyConnectivity verifyConnectivity(String name) throws IOException {
                    VerifyConnectivity result = new VerifyConnectivity(name);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class VerifyConnectivity
                extends CloudKMSRequest<VerifyConnectivityResponse> {
                    private static final String REST_PATH = "v1/{+name}:verifyConnectivity";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected VerifyConnectivity(String name) {
                        super(CloudKMS.this, "GET", REST_PATH, null, VerifyConnectivityResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public VerifyConnectivity set$Xgafv(String $Xgafv) {
                        return (VerifyConnectivity)super.set$Xgafv($Xgafv);
                    }

                    public VerifyConnectivity setAccessToken(String accessToken) {
                        return (VerifyConnectivity)super.setAccessToken(accessToken);
                    }

                    public VerifyConnectivity setAlt(String alt) {
                        return (VerifyConnectivity)super.setAlt(alt);
                    }

                    public VerifyConnectivity setCallback(String callback) {
                        return (VerifyConnectivity)super.setCallback(callback);
                    }

                    public VerifyConnectivity setFields(String fields) {
                        return (VerifyConnectivity)super.setFields(fields);
                    }

                    public VerifyConnectivity setKey(String key) {
                        return (VerifyConnectivity)super.setKey(key);
                    }

                    public VerifyConnectivity setOauthToken(String oauthToken) {
                        return (VerifyConnectivity)super.setOauthToken(oauthToken);
                    }

                    public VerifyConnectivity setPrettyPrint(Boolean prettyPrint) {
                        return (VerifyConnectivity)super.setPrettyPrint(prettyPrint);
                    }

                    public VerifyConnectivity setQuotaUser(String quotaUser) {
                        return (VerifyConnectivity)super.setQuotaUser(quotaUser);
                    }

                    public VerifyConnectivity setUploadType(String uploadType) {
                        return (VerifyConnectivity)super.setUploadType(uploadType);
                    }

                    public VerifyConnectivity setUploadProtocol(String uploadProtocol) {
                        return (VerifyConnectivity)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public VerifyConnectivity setName(String name) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public VerifyConnectivity set(String parameterName, Object value) {
                        return (VerifyConnectivity)super.set(parameterName, value);
                    }
                }

                public class TestIamPermissions
                extends CloudKMSRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends CloudKMSRequest<EkmConnection> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, EkmConnection content) {
                        super(CloudKMS.this, "PATCH", REST_PATH, (Object)content, EkmConnection.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudKMSRequest<ListEkmConnectionsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/ekmConnections";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudKMS.this, "GET", REST_PATH, null, ListEkmConnectionsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudKMSRequest<EkmConnection> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudKMS.this, "GET", REST_PATH, null, EkmConnection.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConnections/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudKMSRequest<EkmConnection> {
                    private static final String REST_PATH = "v1/{+parent}/ekmConnections";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String ekmConnectionId;

                    protected Create(String parent, EkmConnection content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, EkmConnection.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getEkmConnectionId() {
                        return this.ekmConnectionId;
                    }

                    public Create setEkmConnectionId(String ekmConnectionId) {
                        this.ekmConnectionId = ekmConnectionId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class EkmConfig {
                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class TestIamPermissions
                extends CloudKMSRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(CloudKMS.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends CloudKMSRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(CloudKMS.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!CloudKMS.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }
            }

            public class UpdateEkmConfig
            extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.EkmConfig> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateEkmConfig(String name, com.google.api.services.cloudkms.v1.model.EkmConfig content) {
                    super(CloudKMS.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.cloudkms.v1.model.EkmConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConfig$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                    }
                }

                public UpdateEkmConfig set$Xgafv(String $Xgafv) {
                    return (UpdateEkmConfig)super.set$Xgafv($Xgafv);
                }

                public UpdateEkmConfig setAccessToken(String accessToken) {
                    return (UpdateEkmConfig)super.setAccessToken(accessToken);
                }

                public UpdateEkmConfig setAlt(String alt) {
                    return (UpdateEkmConfig)super.setAlt(alt);
                }

                public UpdateEkmConfig setCallback(String callback) {
                    return (UpdateEkmConfig)super.setCallback(callback);
                }

                public UpdateEkmConfig setFields(String fields) {
                    return (UpdateEkmConfig)super.setFields(fields);
                }

                public UpdateEkmConfig setKey(String key) {
                    return (UpdateEkmConfig)super.setKey(key);
                }

                public UpdateEkmConfig setOauthToken(String oauthToken) {
                    return (UpdateEkmConfig)super.setOauthToken(oauthToken);
                }

                public UpdateEkmConfig setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateEkmConfig)super.setPrettyPrint(prettyPrint);
                }

                public UpdateEkmConfig setQuotaUser(String quotaUser) {
                    return (UpdateEkmConfig)super.setQuotaUser(quotaUser);
                }

                public UpdateEkmConfig setUploadType(String uploadType) {
                    return (UpdateEkmConfig)super.setUploadType(uploadType);
                }

                public UpdateEkmConfig setUploadProtocol(String uploadProtocol) {
                    return (UpdateEkmConfig)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateEkmConfig setName(String name) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateEkmConfig setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public UpdateEkmConfig set(String parameterName, Object value) {
                    return (UpdateEkmConfig)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudKMSRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(CloudKMS.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetEkmConfig
            extends CloudKMSRequest<com.google.api.services.cloudkms.v1.model.EkmConfig> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetEkmConfig(String name) {
                    super(CloudKMS.this, "GET", REST_PATH, null, com.google.api.services.cloudkms.v1.model.EkmConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/ekmConfig$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetEkmConfig set$Xgafv(String $Xgafv) {
                    return (GetEkmConfig)super.set$Xgafv($Xgafv);
                }

                public GetEkmConfig setAccessToken(String accessToken) {
                    return (GetEkmConfig)super.setAccessToken(accessToken);
                }

                public GetEkmConfig setAlt(String alt) {
                    return (GetEkmConfig)super.setAlt(alt);
                }

                public GetEkmConfig setCallback(String callback) {
                    return (GetEkmConfig)super.setCallback(callback);
                }

                public GetEkmConfig setFields(String fields) {
                    return (GetEkmConfig)super.setFields(fields);
                }

                public GetEkmConfig setKey(String key) {
                    return (GetEkmConfig)super.setKey(key);
                }

                public GetEkmConfig setOauthToken(String oauthToken) {
                    return (GetEkmConfig)super.setOauthToken(oauthToken);
                }

                public GetEkmConfig setPrettyPrint(Boolean prettyPrint) {
                    return (GetEkmConfig)super.setPrettyPrint(prettyPrint);
                }

                public GetEkmConfig setQuotaUser(String quotaUser) {
                    return (GetEkmConfig)super.setQuotaUser(quotaUser);
                }

                public GetEkmConfig setUploadType(String uploadType) {
                    return (GetEkmConfig)super.setUploadType(uploadType);
                }

                public GetEkmConfig setUploadProtocol(String uploadProtocol) {
                    return (GetEkmConfig)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetEkmConfig setName(String name) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/ekmConfig$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GetEkmConfig set(String parameterName, Object value) {
                    return (GetEkmConfig)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudKMSRequest<Location> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudKMS.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class GenerateRandomBytes
            extends CloudKMSRequest<GenerateRandomBytesResponse> {
                private static final String REST_PATH = "v1/{+location}:generateRandomBytes";
                private final Pattern LOCATION_PATTERN;
                @Key
                private String location;

                protected GenerateRandomBytes(String location, GenerateRandomBytesRequest content) {
                    super(CloudKMS.this, "POST", REST_PATH, (Object)content, GenerateRandomBytesResponse.class);
                    this.LOCATION_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.location = (String)Preconditions.checkNotNull((Object)location, (Object)"Required parameter location must be specified.");
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOCATION_PATTERN.matcher(location).matches(), (Object)"Parameter location must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public GenerateRandomBytes set$Xgafv(String $Xgafv) {
                    return (GenerateRandomBytes)super.set$Xgafv($Xgafv);
                }

                public GenerateRandomBytes setAccessToken(String accessToken) {
                    return (GenerateRandomBytes)super.setAccessToken(accessToken);
                }

                public GenerateRandomBytes setAlt(String alt) {
                    return (GenerateRandomBytes)super.setAlt(alt);
                }

                public GenerateRandomBytes setCallback(String callback) {
                    return (GenerateRandomBytes)super.setCallback(callback);
                }

                public GenerateRandomBytes setFields(String fields) {
                    return (GenerateRandomBytes)super.setFields(fields);
                }

                public GenerateRandomBytes setKey(String key) {
                    return (GenerateRandomBytes)super.setKey(key);
                }

                public GenerateRandomBytes setOauthToken(String oauthToken) {
                    return (GenerateRandomBytes)super.setOauthToken(oauthToken);
                }

                public GenerateRandomBytes setPrettyPrint(Boolean prettyPrint) {
                    return (GenerateRandomBytes)super.setPrettyPrint(prettyPrint);
                }

                public GenerateRandomBytes setQuotaUser(String quotaUser) {
                    return (GenerateRandomBytes)super.setQuotaUser(quotaUser);
                }

                public GenerateRandomBytes setUploadType(String uploadType) {
                    return (GenerateRandomBytes)super.setUploadType(uploadType);
                }

                public GenerateRandomBytes setUploadProtocol(String uploadProtocol) {
                    return (GenerateRandomBytes)super.setUploadProtocol(uploadProtocol);
                }

                public String getLocation() {
                    return this.location;
                }

                public GenerateRandomBytes setLocation(String location) {
                    if (!CloudKMS.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOCATION_PATTERN.matcher(location).matches(), (Object)"Parameter location must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.location = location;
                    return this;
                }

                @Override
                public GenerateRandomBytes set(String parameterName, Object value) {
                    return (GenerateRandomBytes)super.set(parameterName, value);
                }
            }
        }

        public class ShowEffectiveAutokeyConfig
        extends CloudKMSRequest<ShowEffectiveAutokeyConfigResponse> {
            private static final String REST_PATH = "v1/{+parent}:showEffectiveAutokeyConfig";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected ShowEffectiveAutokeyConfig(String parent) {
                super(CloudKMS.this, "GET", REST_PATH, null, ShowEffectiveAutokeyConfigResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!CloudKMS.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ShowEffectiveAutokeyConfig set$Xgafv(String $Xgafv) {
                return (ShowEffectiveAutokeyConfig)super.set$Xgafv($Xgafv);
            }

            public ShowEffectiveAutokeyConfig setAccessToken(String accessToken) {
                return (ShowEffectiveAutokeyConfig)super.setAccessToken(accessToken);
            }

            public ShowEffectiveAutokeyConfig setAlt(String alt) {
                return (ShowEffectiveAutokeyConfig)super.setAlt(alt);
            }

            public ShowEffectiveAutokeyConfig setCallback(String callback) {
                return (ShowEffectiveAutokeyConfig)super.setCallback(callback);
            }

            public ShowEffectiveAutokeyConfig setFields(String fields) {
                return (ShowEffectiveAutokeyConfig)super.setFields(fields);
            }

            public ShowEffectiveAutokeyConfig setKey(String key) {
                return (ShowEffectiveAutokeyConfig)super.setKey(key);
            }

            public ShowEffectiveAutokeyConfig setOauthToken(String oauthToken) {
                return (ShowEffectiveAutokeyConfig)super.setOauthToken(oauthToken);
            }

            public ShowEffectiveAutokeyConfig setPrettyPrint(Boolean prettyPrint) {
                return (ShowEffectiveAutokeyConfig)super.setPrettyPrint(prettyPrint);
            }

            public ShowEffectiveAutokeyConfig setQuotaUser(String quotaUser) {
                return (ShowEffectiveAutokeyConfig)super.setQuotaUser(quotaUser);
            }

            public ShowEffectiveAutokeyConfig setUploadType(String uploadType) {
                return (ShowEffectiveAutokeyConfig)super.setUploadType(uploadType);
            }

            public ShowEffectiveAutokeyConfig setUploadProtocol(String uploadProtocol) {
                return (ShowEffectiveAutokeyConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public ShowEffectiveAutokeyConfig setParent(String parent) {
                if (!CloudKMS.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public ShowEffectiveAutokeyConfig set(String parameterName, Object value) {
                return (ShowEffectiveAutokeyConfig)super.set(parameterName, value);
            }
        }
    }

    public class Folders {
        public GetAutokeyConfig getAutokeyConfig(String name) throws IOException {
            GetAutokeyConfig result = new GetAutokeyConfig(name);
            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateAutokeyConfig updateAutokeyConfig(String name, AutokeyConfig content) throws IOException {
            UpdateAutokeyConfig result = new UpdateAutokeyConfig(name, content);
            CloudKMS.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class UpdateAutokeyConfig
        extends CloudKMSRequest<AutokeyConfig> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String updateMask;

            protected UpdateAutokeyConfig(String name, AutokeyConfig content) {
                super(CloudKMS.this, "PATCH", REST_PATH, (Object)content, AutokeyConfig.class);
                this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/autokeyConfig$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudKMS.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/autokeyConfig$");
                }
            }

            public UpdateAutokeyConfig set$Xgafv(String $Xgafv) {
                return (UpdateAutokeyConfig)super.set$Xgafv($Xgafv);
            }

            public UpdateAutokeyConfig setAccessToken(String accessToken) {
                return (UpdateAutokeyConfig)super.setAccessToken(accessToken);
            }

            public UpdateAutokeyConfig setAlt(String alt) {
                return (UpdateAutokeyConfig)super.setAlt(alt);
            }

            public UpdateAutokeyConfig setCallback(String callback) {
                return (UpdateAutokeyConfig)super.setCallback(callback);
            }

            public UpdateAutokeyConfig setFields(String fields) {
                return (UpdateAutokeyConfig)super.setFields(fields);
            }

            public UpdateAutokeyConfig setKey(String key) {
                return (UpdateAutokeyConfig)super.setKey(key);
            }

            public UpdateAutokeyConfig setOauthToken(String oauthToken) {
                return (UpdateAutokeyConfig)super.setOauthToken(oauthToken);
            }

            public UpdateAutokeyConfig setPrettyPrint(Boolean prettyPrint) {
                return (UpdateAutokeyConfig)super.setPrettyPrint(prettyPrint);
            }

            public UpdateAutokeyConfig setQuotaUser(String quotaUser) {
                return (UpdateAutokeyConfig)super.setQuotaUser(quotaUser);
            }

            public UpdateAutokeyConfig setUploadType(String uploadType) {
                return (UpdateAutokeyConfig)super.setUploadType(uploadType);
            }

            public UpdateAutokeyConfig setUploadProtocol(String uploadProtocol) {
                return (UpdateAutokeyConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateAutokeyConfig setName(String name) {
                if (!CloudKMS.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/autokeyConfig$");
                }
                this.name = name;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public UpdateAutokeyConfig setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public UpdateAutokeyConfig set(String parameterName, Object value) {
                return (UpdateAutokeyConfig)super.set(parameterName, value);
            }
        }

        public class GetAutokeyConfig
        extends CloudKMSRequest<AutokeyConfig> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetAutokeyConfig(String name) {
                super(CloudKMS.this, "GET", REST_PATH, null, AutokeyConfig.class);
                this.NAME_PATTERN = Pattern.compile("^folders/[^/]+/autokeyConfig$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudKMS.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/autokeyConfig$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetAutokeyConfig set$Xgafv(String $Xgafv) {
                return (GetAutokeyConfig)super.set$Xgafv($Xgafv);
            }

            public GetAutokeyConfig setAccessToken(String accessToken) {
                return (GetAutokeyConfig)super.setAccessToken(accessToken);
            }

            public GetAutokeyConfig setAlt(String alt) {
                return (GetAutokeyConfig)super.setAlt(alt);
            }

            public GetAutokeyConfig setCallback(String callback) {
                return (GetAutokeyConfig)super.setCallback(callback);
            }

            public GetAutokeyConfig setFields(String fields) {
                return (GetAutokeyConfig)super.setFields(fields);
            }

            public GetAutokeyConfig setKey(String key) {
                return (GetAutokeyConfig)super.setKey(key);
            }

            public GetAutokeyConfig setOauthToken(String oauthToken) {
                return (GetAutokeyConfig)super.setOauthToken(oauthToken);
            }

            public GetAutokeyConfig setPrettyPrint(Boolean prettyPrint) {
                return (GetAutokeyConfig)super.setPrettyPrint(prettyPrint);
            }

            public GetAutokeyConfig setQuotaUser(String quotaUser) {
                return (GetAutokeyConfig)super.setQuotaUser(quotaUser);
            }

            public GetAutokeyConfig setUploadType(String uploadType) {
                return (GetAutokeyConfig)super.setUploadType(uploadType);
            }

            public GetAutokeyConfig setUploadProtocol(String uploadProtocol) {
                return (GetAutokeyConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetAutokeyConfig setName(String name) {
                if (!CloudKMS.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^folders/[^/]+/autokeyConfig$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetAutokeyConfig set(String parameterName, Object value) {
                return (GetAutokeyConfig)super.set(parameterName, value);
            }
        }
    }
}

