/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-07-27 at 23:54:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RouterStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterStatus extends com.google.api.client.json.GenericJson {

  /**
   * Best routes for this router's network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Route> bestRoutes;

  static {
    // hack to force ProGuard to consider Route used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Route.class);
  }

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RouterStatusBgpPeerStatus> bgpPeerStatus;

  /**
   * URI of the network to which this router belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Best routes for this router's network.
   * @return value or {@code null} for none
   */
  public java.util.List<Route> getBestRoutes() {
    return bestRoutes;
  }

  /**
   * Best routes for this router's network.
   * @param bestRoutes bestRoutes or {@code null} for none
   */
  public RouterStatus setBestRoutes(java.util.List<Route> bestRoutes) {
    this.bestRoutes = bestRoutes;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<RouterStatusBgpPeerStatus> getBgpPeerStatus() {
    return bgpPeerStatus;
  }

  /**
   * @param bgpPeerStatus bgpPeerStatus or {@code null} for none
   */
  public RouterStatus setBgpPeerStatus(java.util.List<RouterStatusBgpPeerStatus> bgpPeerStatus) {
    this.bgpPeerStatus = bgpPeerStatus;
    return this;
  }

  /**
   * URI of the network to which this router belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * URI of the network to which this router belongs.
   * @param network network or {@code null} for none
   */
  public RouterStatus setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  @Override
  public RouterStatus set(String fieldName, Object value) {
    return (RouterStatus) super.set(fieldName, value);
  }

  @Override
  public RouterStatus clone() {
    return (RouterStatus) super.clone();
  }

}
