/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains information of NAT Mappings provided by a NAT Rule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings extends com.google.api.client.json.GenericJson {

  /**
   * List of all drain IP:port-range mappings assigned to this interface by this rule. These ranges
   * are inclusive, that is, both the first and the last ports can be used for NAT. Example:
   * ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> drainNatIpPortRanges;

  /**
   * A list of all IP:port-range mappings assigned to this interface by this rule. These ranges are
   * inclusive, that is, both the first and the last ports can be used for NAT. Example:
   * ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> natIpPortRanges;

  /**
   * Total number of drain ports across all NAT IPs allocated to this interface by this rule. It
   * equals the aggregated port number in the field drain_nat_ip_port_ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numTotalDrainNatPorts;

  /**
   * Total number of ports across all NAT IPs allocated to this interface by this rule. It equals
   * the aggregated port number in the field nat_ip_port_ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numTotalNatPorts;

  /**
   * Rule number of the NAT Rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ruleNumber;

  /**
   * List of all drain IP:port-range mappings assigned to this interface by this rule. These ranges
   * are inclusive, that is, both the first and the last ports can be used for NAT. Example:
   * ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDrainNatIpPortRanges() {
    return drainNatIpPortRanges;
  }

  /**
   * List of all drain IP:port-range mappings assigned to this interface by this rule. These ranges
   * are inclusive, that is, both the first and the last ports can be used for NAT. Example:
   * ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * @param drainNatIpPortRanges drainNatIpPortRanges or {@code null} for none
   */
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings setDrainNatIpPortRanges(java.util.List<java.lang.String> drainNatIpPortRanges) {
    this.drainNatIpPortRanges = drainNatIpPortRanges;
    return this;
  }

  /**
   * A list of all IP:port-range mappings assigned to this interface by this rule. These ranges are
   * inclusive, that is, both the first and the last ports can be used for NAT. Example:
   * ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNatIpPortRanges() {
    return natIpPortRanges;
  }

  /**
   * A list of all IP:port-range mappings assigned to this interface by this rule. These ranges are
   * inclusive, that is, both the first and the last ports can be used for NAT. Example:
   * ["2.2.2.2:12345-12355", "1.1.1.1:2234-2234"].
   * @param natIpPortRanges natIpPortRanges or {@code null} for none
   */
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings setNatIpPortRanges(java.util.List<java.lang.String> natIpPortRanges) {
    this.natIpPortRanges = natIpPortRanges;
    return this;
  }

  /**
   * Total number of drain ports across all NAT IPs allocated to this interface by this rule. It
   * equals the aggregated port number in the field drain_nat_ip_port_ranges.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumTotalDrainNatPorts() {
    return numTotalDrainNatPorts;
  }

  /**
   * Total number of drain ports across all NAT IPs allocated to this interface by this rule. It
   * equals the aggregated port number in the field drain_nat_ip_port_ranges.
   * @param numTotalDrainNatPorts numTotalDrainNatPorts or {@code null} for none
   */
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings setNumTotalDrainNatPorts(java.lang.Integer numTotalDrainNatPorts) {
    this.numTotalDrainNatPorts = numTotalDrainNatPorts;
    return this;
  }

  /**
   * Total number of ports across all NAT IPs allocated to this interface by this rule. It equals
   * the aggregated port number in the field nat_ip_port_ranges.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumTotalNatPorts() {
    return numTotalNatPorts;
  }

  /**
   * Total number of ports across all NAT IPs allocated to this interface by this rule. It equals
   * the aggregated port number in the field nat_ip_port_ranges.
   * @param numTotalNatPorts numTotalNatPorts or {@code null} for none
   */
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings setNumTotalNatPorts(java.lang.Integer numTotalNatPorts) {
    this.numTotalNatPorts = numTotalNatPorts;
    return this;
  }

  /**
   * Rule number of the NAT Rule.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRuleNumber() {
    return ruleNumber;
  }

  /**
   * Rule number of the NAT Rule.
   * @param ruleNumber ruleNumber or {@code null} for none
   */
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings setRuleNumber(java.lang.Integer ruleNumber) {
    this.ruleNumber = ruleNumber;
    return this;
  }

  @Override
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings set(String fieldName, Object value) {
    return (VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings) super.set(fieldName, value);
  }

  @Override
  public VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings clone() {
    return (VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings) super.clone();
  }

}
