/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for PerInstanceConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PerInstanceConfig extends com.google.api.client.json.GenericJson {

  /**
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is
   * ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in
   * order to update an existing per-instance config or the field needs to be unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The name of a per-instance config and its corresponding instance. Serves as a merge key during
   * UpdatePerInstanceConfigs operations, that is, if a per-instance config with the same name
   * exists then it will be updated, otherwise a new one will be created for the VM instance with
   * the same name. An attempt to create a per-instance config for a VM instance that either doesn't
   * exist or is not part of the group will result in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The intended preserved state for the given instance. Does not contain preserved state generated
   * from a stateful policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PreservedState preservedState;

  /**
   * The status of applying this per-instance config on the corresponding managed instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is
   * ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in
   * order to update an existing per-instance config or the field needs to be unset.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is
   * ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in
   * order to update an existing per-instance config or the field needs to be unset.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is
   * ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in
   * order to update an existing per-instance config or the field needs to be unset.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public PerInstanceConfig setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is
   * ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in
   * order to update an existing per-instance config or the field needs to be unset.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public PerInstanceConfig encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * The name of a per-instance config and its corresponding instance. Serves as a merge key during
   * UpdatePerInstanceConfigs operations, that is, if a per-instance config with the same name
   * exists then it will be updated, otherwise a new one will be created for the VM instance with
   * the same name. An attempt to create a per-instance config for a VM instance that either doesn't
   * exist or is not part of the group will result in an error.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of a per-instance config and its corresponding instance. Serves as a merge key during
   * UpdatePerInstanceConfigs operations, that is, if a per-instance config with the same name
   * exists then it will be updated, otherwise a new one will be created for the VM instance with
   * the same name. An attempt to create a per-instance config for a VM instance that either doesn't
   * exist or is not part of the group will result in an error.
   * @param name name or {@code null} for none
   */
  public PerInstanceConfig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The intended preserved state for the given instance. Does not contain preserved state generated
   * from a stateful policy.
   * @return value or {@code null} for none
   */
  public PreservedState getPreservedState() {
    return preservedState;
  }

  /**
   * The intended preserved state for the given instance. Does not contain preserved state generated
   * from a stateful policy.
   * @param preservedState preservedState or {@code null} for none
   */
  public PerInstanceConfig setPreservedState(PreservedState preservedState) {
    this.preservedState = preservedState;
    return this;
  }

  /**
   * The status of applying this per-instance config on the corresponding managed instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * The status of applying this per-instance config on the corresponding managed instance.
   * @param status status or {@code null} for none
   */
  public PerInstanceConfig setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public PerInstanceConfig set(String fieldName, Object value) {
    return (PerInstanceConfig) super.set(fieldName, value);
  }

  @Override
  public PerInstanceConfig clone() {
    return (PerInstanceConfig) super.clone();
  }

}
