/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A transient resource used in compute.instances.bulkInsert and compute.regionInstances.bulkInsert
 * and compute.regionInstances.recommendLocations. This resource is not persisted anywhere, it is
 * used only for processing the requests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BulkInsertInstanceResource extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of instances to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * DEPRECATED: Please use instance_properties instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Instance instance;

  /**
   * The instance properties defining the VM instances to be created. Required if
   * sourceInstanceTemplate is not provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceProperties instanceProperties;

  /**
   * Policy for chosing target zone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationPolicy locationPolicy;

  /**
   * The minimum number of instances to create. If no min_count is specified then count is used as
   * the default value. If min_count instances cannot be created, then no instances will be created
   * and instances already created will be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long minCount;

  /**
   * The string pattern used for the names of the VMs. Either name_pattern or
   * per_instance_properties must be set. The pattern should contain one continuous sequence of
   * placeholder hash characters (#) with each character corresponding to one digit of the generated
   * instance name. Example: name_pattern of inst-#### will generate instance names such as
   * inst-0001, inst-0002, ... . If there already exist instance(s) whose names match the name
   * pattern in the same project and zone, then the generated instance numbers will start after the
   * biggest existing number. For example, if there exists an instance with name inst-0050, then
   * instance names generated using the pattern inst-#### will be inst-0051, inst-0052, etc. The
   * name pattern placeholder #...# can contain up to 18 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namePattern;

  /**
   * Per-instance properties to be set on individual instances. Keys of this map specify requested
   * instance names. Can be empty if name_pattern is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, BulkInsertInstanceResourcePerInstanceProperties> perInstanceProperties;

  /**
   * DEPRECATED: Please use per_instance_properties instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> predefinedNames;

  /**
   * DEPRECATED: Please use instance_properties.secure_tag instead. Secure tags to apply to this
   * instance. These can be later modified by the update method. Maximum number of secure tags
   * allowed is 50.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> secureTags;

  /**
   * Specifies the instance template from which to create instances. You may combine
   * sourceInstanceTemplate with instanceProperties to override specific values from an existing
   * instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396.
   *
   * It can be a full or partial URL. For example, the following are all valid URLs to an instance
   * template:   - https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/i
   * nstanceTemplate  - projects/project/global/instanceTemplates/instanceTemplate  -
   * global/instanceTemplates/instanceTemplate
   *
   * This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceInstanceTemplate;

  /**
   * The maximum number of instances to create.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * The maximum number of instances to create.
   * @param count count or {@code null} for none
   */
  public BulkInsertInstanceResource setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * DEPRECATED: Please use instance_properties instead.
   * @return value or {@code null} for none
   */
  public Instance getInstance() {
    return instance;
  }

  /**
   * DEPRECATED: Please use instance_properties instead.
   * @param instance instance or {@code null} for none
   */
  public BulkInsertInstanceResource setInstance(Instance instance) {
    this.instance = instance;
    return this;
  }

  /**
   * The instance properties defining the VM instances to be created. Required if
   * sourceInstanceTemplate is not provided.
   * @return value or {@code null} for none
   */
  public InstanceProperties getInstanceProperties() {
    return instanceProperties;
  }

  /**
   * The instance properties defining the VM instances to be created. Required if
   * sourceInstanceTemplate is not provided.
   * @param instanceProperties instanceProperties or {@code null} for none
   */
  public BulkInsertInstanceResource setInstanceProperties(InstanceProperties instanceProperties) {
    this.instanceProperties = instanceProperties;
    return this;
  }

  /**
   * Policy for chosing target zone.
   * @return value or {@code null} for none
   */
  public LocationPolicy getLocationPolicy() {
    return locationPolicy;
  }

  /**
   * Policy for chosing target zone.
   * @param locationPolicy locationPolicy or {@code null} for none
   */
  public BulkInsertInstanceResource setLocationPolicy(LocationPolicy locationPolicy) {
    this.locationPolicy = locationPolicy;
    return this;
  }

  /**
   * The minimum number of instances to create. If no min_count is specified then count is used as
   * the default value. If min_count instances cannot be created, then no instances will be created
   * and instances already created will be deleted.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinCount() {
    return minCount;
  }

  /**
   * The minimum number of instances to create. If no min_count is specified then count is used as
   * the default value. If min_count instances cannot be created, then no instances will be created
   * and instances already created will be deleted.
   * @param minCount minCount or {@code null} for none
   */
  public BulkInsertInstanceResource setMinCount(java.lang.Long minCount) {
    this.minCount = minCount;
    return this;
  }

  /**
   * The string pattern used for the names of the VMs. Either name_pattern or
   * per_instance_properties must be set. The pattern should contain one continuous sequence of
   * placeholder hash characters (#) with each character corresponding to one digit of the generated
   * instance name. Example: name_pattern of inst-#### will generate instance names such as
   * inst-0001, inst-0002, ... . If there already exist instance(s) whose names match the name
   * pattern in the same project and zone, then the generated instance numbers will start after the
   * biggest existing number. For example, if there exists an instance with name inst-0050, then
   * instance names generated using the pattern inst-#### will be inst-0051, inst-0052, etc. The
   * name pattern placeholder #...# can contain up to 18 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamePattern() {
    return namePattern;
  }

  /**
   * The string pattern used for the names of the VMs. Either name_pattern or
   * per_instance_properties must be set. The pattern should contain one continuous sequence of
   * placeholder hash characters (#) with each character corresponding to one digit of the generated
   * instance name. Example: name_pattern of inst-#### will generate instance names such as
   * inst-0001, inst-0002, ... . If there already exist instance(s) whose names match the name
   * pattern in the same project and zone, then the generated instance numbers will start after the
   * biggest existing number. For example, if there exists an instance with name inst-0050, then
   * instance names generated using the pattern inst-#### will be inst-0051, inst-0052, etc. The
   * name pattern placeholder #...# can contain up to 18 characters.
   * @param namePattern namePattern or {@code null} for none
   */
  public BulkInsertInstanceResource setNamePattern(java.lang.String namePattern) {
    this.namePattern = namePattern;
    return this;
  }

  /**
   * Per-instance properties to be set on individual instances. Keys of this map specify requested
   * instance names. Can be empty if name_pattern is used.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, BulkInsertInstanceResourcePerInstanceProperties> getPerInstanceProperties() {
    return perInstanceProperties;
  }

  /**
   * Per-instance properties to be set on individual instances. Keys of this map specify requested
   * instance names. Can be empty if name_pattern is used.
   * @param perInstanceProperties perInstanceProperties or {@code null} for none
   */
  public BulkInsertInstanceResource setPerInstanceProperties(java.util.Map<String, BulkInsertInstanceResourcePerInstanceProperties> perInstanceProperties) {
    this.perInstanceProperties = perInstanceProperties;
    return this;
  }

  /**
   * DEPRECATED: Please use per_instance_properties instead.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPredefinedNames() {
    return predefinedNames;
  }

  /**
   * DEPRECATED: Please use per_instance_properties instead.
   * @param predefinedNames predefinedNames or {@code null} for none
   */
  public BulkInsertInstanceResource setPredefinedNames(java.util.List<java.lang.String> predefinedNames) {
    this.predefinedNames = predefinedNames;
    return this;
  }

  /**
   * DEPRECATED: Please use instance_properties.secure_tag instead. Secure tags to apply to this
   * instance. These can be later modified by the update method. Maximum number of secure tags
   * allowed is 50.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSecureTags() {
    return secureTags;
  }

  /**
   * DEPRECATED: Please use instance_properties.secure_tag instead. Secure tags to apply to this
   * instance. These can be later modified by the update method. Maximum number of secure tags
   * allowed is 50.
   * @param secureTags secureTags or {@code null} for none
   */
  public BulkInsertInstanceResource setSecureTags(java.util.List<java.lang.String> secureTags) {
    this.secureTags = secureTags;
    return this;
  }

  /**
   * Specifies the instance template from which to create instances. You may combine
   * sourceInstanceTemplate with instanceProperties to override specific values from an existing
   * instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396.
   *
   * It can be a full or partial URL. For example, the following are all valid URLs to an instance
   * template:   - https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/i
   * nstanceTemplate  - projects/project/global/instanceTemplates/instanceTemplate  -
   * global/instanceTemplates/instanceTemplate
   *
   * This field is optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceInstanceTemplate() {
    return sourceInstanceTemplate;
  }

  /**
   * Specifies the instance template from which to create instances. You may combine
   * sourceInstanceTemplate with instanceProperties to override specific values from an existing
   * instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396.
   *
   * It can be a full or partial URL. For example, the following are all valid URLs to an instance
   * template:   - https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/i
   * nstanceTemplate  - projects/project/global/instanceTemplates/instanceTemplate  -
   * global/instanceTemplates/instanceTemplate
   *
   * This field is optional.
   * @param sourceInstanceTemplate sourceInstanceTemplate or {@code null} for none
   */
  public BulkInsertInstanceResource setSourceInstanceTemplate(java.lang.String sourceInstanceTemplate) {
    this.sourceInstanceTemplate = sourceInstanceTemplate;
    return this;
  }

  @Override
  public BulkInsertInstanceResource set(String fieldName, Object value) {
    return (BulkInsertInstanceResource) super.set(fieldName, value);
  }

  @Override
  public BulkInsertInstanceResource clone() {
    return (BulkInsertInstanceResource) super.clone();
  }

}
