/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration for a serverless network endpoint group (NEG). The platform must be provided.
 *
 * Note: The target backend service must be in the same project and located in the same region as
 * the Serverless NEG.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkEndpointGroupServerlessDeployment extends com.google.api.client.json.GenericJson {

  /**
   * The platform of the backend target(s) of this NEG. Possible values include:
   *
   *   - API Gateway: apigateway.googleapis.com  - App Engine: appengine.googleapis.com  - Cloud
   * Functions: cloudfunctions.googleapis.com  - Cloud Run: run.googleapis.com
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * The user-defined name of the workload/instance. This value must be provided explicitly or in
   * the urlMask. The resource identified by this value is platform-specific and is as follows:
   *
   *   - API Gateway: The gateway ID  - App Engine: The service name  - Cloud Functions: The
   * function name  - Cloud Run: The service name
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resource;

  /**
   * A template to parse platform-specific fields from a request URL. URL mask allows for routing to
   * multiple resources on the same serverless platform without having to create multiple Network
   * Endpoint Groups and backend resources. The fields parsed by this template are platform-specific
   * and are as follows:
   *
   *   - API Gateway: The gateway ID  - App Engine: The service and version  - Cloud Functions: The
   * function name  - Cloud Run: The service and tag
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String urlMask;

  /**
   * The optional resource version. The version identified by this value is platform-specific and is
   * follows:
   *
   *   - API Gateway: Unused  - App Engine: The service version  - Cloud Functions: Unused  - Cloud
   * Run: The service tag
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String version;

  /**
   * The platform of the backend target(s) of this NEG. Possible values include:
   *
   *   - API Gateway: apigateway.googleapis.com  - App Engine: appengine.googleapis.com  - Cloud
   * Functions: cloudfunctions.googleapis.com  - Cloud Run: run.googleapis.com
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * The platform of the backend target(s) of this NEG. Possible values include:
   *
   *   - API Gateway: apigateway.googleapis.com  - App Engine: appengine.googleapis.com  - Cloud
   * Functions: cloudfunctions.googleapis.com  - Cloud Run: run.googleapis.com
   * @param platform platform or {@code null} for none
   */
  public NetworkEndpointGroupServerlessDeployment setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  /**
   * The user-defined name of the workload/instance. This value must be provided explicitly or in
   * the urlMask. The resource identified by this value is platform-specific and is as follows:
   *
   *   - API Gateway: The gateway ID  - App Engine: The service name  - Cloud Functions: The
   * function name  - Cloud Run: The service name
   * @return value or {@code null} for none
   */
  public java.lang.String getResource() {
    return resource;
  }

  /**
   * The user-defined name of the workload/instance. This value must be provided explicitly or in
   * the urlMask. The resource identified by this value is platform-specific and is as follows:
   *
   *   - API Gateway: The gateway ID  - App Engine: The service name  - Cloud Functions: The
   * function name  - Cloud Run: The service name
   * @param resource resource or {@code null} for none
   */
  public NetworkEndpointGroupServerlessDeployment setResource(java.lang.String resource) {
    this.resource = resource;
    return this;
  }

  /**
   * A template to parse platform-specific fields from a request URL. URL mask allows for routing to
   * multiple resources on the same serverless platform without having to create multiple Network
   * Endpoint Groups and backend resources. The fields parsed by this template are platform-specific
   * and are as follows:
   *
   *   - API Gateway: The gateway ID  - App Engine: The service and version  - Cloud Functions: The
   * function name  - Cloud Run: The service and tag
   * @return value or {@code null} for none
   */
  public java.lang.String getUrlMask() {
    return urlMask;
  }

  /**
   * A template to parse platform-specific fields from a request URL. URL mask allows for routing to
   * multiple resources on the same serverless platform without having to create multiple Network
   * Endpoint Groups and backend resources. The fields parsed by this template are platform-specific
   * and are as follows:
   *
   *   - API Gateway: The gateway ID  - App Engine: The service and version  - Cloud Functions: The
   * function name  - Cloud Run: The service and tag
   * @param urlMask urlMask or {@code null} for none
   */
  public NetworkEndpointGroupServerlessDeployment setUrlMask(java.lang.String urlMask) {
    this.urlMask = urlMask;
    return this;
  }

  /**
   * The optional resource version. The version identified by this value is platform-specific and is
   * follows:
   *
   *   - API Gateway: Unused  - App Engine: The service version  - Cloud Functions: Unused  - Cloud
   * Run: The service tag
   * @return value or {@code null} for none
   */
  public java.lang.String getVersion() {
    return version;
  }

  /**
   * The optional resource version. The version identified by this value is platform-specific and is
   * follows:
   *
   *   - API Gateway: Unused  - App Engine: The service version  - Cloud Functions: Unused  - Cloud
   * Run: The service tag
   * @param version version or {@code null} for none
   */
  public NetworkEndpointGroupServerlessDeployment setVersion(java.lang.String version) {
    this.version = version;
    return this;
  }

  @Override
  public NetworkEndpointGroupServerlessDeployment set(String fieldName, Object value) {
    return (NetworkEndpointGroupServerlessDeployment) super.set(fieldName, value);
  }

  @Override
  public NetworkEndpointGroupServerlessDeployment clone() {
    return (NetworkEndpointGroupServerlessDeployment) super.clone();
  }

}
