/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A rollout policy configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RolloutPolicy extends com.google.api.client.json.GenericJson {

  /**
   * An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone
   * that is not explicitly stated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultRolloutTime;

  /**
   * Location based rollout policies to apply to the resource.
   *
   * Currently only zone names are supported and must be represented as valid URLs, like: zones/us-
   * central1-a.
   *
   * The value expects an RFC3339 timestamp on or after which the update is considered rolled out to
   * the specified location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> locationRolloutPolicies;

  /**
   * An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone
   * that is not explicitly stated.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultRolloutTime() {
    return defaultRolloutTime;
  }

  /**
   * An optional RFC3339 timestamp on or after which the update is considered rolled out to any zone
   * that is not explicitly stated.
   * @param defaultRolloutTime defaultRolloutTime or {@code null} for none
   */
  public RolloutPolicy setDefaultRolloutTime(java.lang.String defaultRolloutTime) {
    this.defaultRolloutTime = defaultRolloutTime;
    return this;
  }

  /**
   * Location based rollout policies to apply to the resource.
   *
   * Currently only zone names are supported and must be represented as valid URLs, like: zones/us-
   * central1-a.
   *
   * The value expects an RFC3339 timestamp on or after which the update is considered rolled out to
   * the specified location.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLocationRolloutPolicies() {
    return locationRolloutPolicies;
  }

  /**
   * Location based rollout policies to apply to the resource.
   *
   * Currently only zone names are supported and must be represented as valid URLs, like: zones/us-
   * central1-a.
   *
   * The value expects an RFC3339 timestamp on or after which the update is considered rolled out to
   * the specified location.
   * @param locationRolloutPolicies locationRolloutPolicies or {@code null} for none
   */
  public RolloutPolicy setLocationRolloutPolicies(java.util.Map<String, java.lang.String> locationRolloutPolicies) {
    this.locationRolloutPolicies = locationRolloutPolicies;
    return this;
  }

  @Override
  public RolloutPolicy set(String fieldName, Object value) {
    return (RolloutPolicy) super.set(fieldName, value);
  }

  @Override
  public RolloutPolicy clone() {
    return (RolloutPolicy) super.clone();
  }

}
