/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The request and response header transformations that take effect before the request is passed
 * along to the selected backendService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpHeaderAction extends com.google.api.client.json.GenericJson {

  /**
   * Headers to add to a matching request prior to forwarding the request to the backendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HttpHeaderOption> requestHeadersToAdd;

  /**
   * A list of header names for headers that need to be removed from the request prior to forwarding
   * the request to the backendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> requestHeadersToRemove;

  /**
   * Headers to add the response prior to sending the response back to the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HttpHeaderOption> responseHeadersToAdd;

  /**
   * A list of header names for headers that need to be removed from the response prior to sending
   * the response back to the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> responseHeadersToRemove;

  /**
   * Headers to add to a matching request prior to forwarding the request to the backendService.
   * @return value or {@code null} for none
   */
  public java.util.List<HttpHeaderOption> getRequestHeadersToAdd() {
    return requestHeadersToAdd;
  }

  /**
   * Headers to add to a matching request prior to forwarding the request to the backendService.
   * @param requestHeadersToAdd requestHeadersToAdd or {@code null} for none
   */
  public HttpHeaderAction setRequestHeadersToAdd(java.util.List<HttpHeaderOption> requestHeadersToAdd) {
    this.requestHeadersToAdd = requestHeadersToAdd;
    return this;
  }

  /**
   * A list of header names for headers that need to be removed from the request prior to forwarding
   * the request to the backendService.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRequestHeadersToRemove() {
    return requestHeadersToRemove;
  }

  /**
   * A list of header names for headers that need to be removed from the request prior to forwarding
   * the request to the backendService.
   * @param requestHeadersToRemove requestHeadersToRemove or {@code null} for none
   */
  public HttpHeaderAction setRequestHeadersToRemove(java.util.List<java.lang.String> requestHeadersToRemove) {
    this.requestHeadersToRemove = requestHeadersToRemove;
    return this;
  }

  /**
   * Headers to add the response prior to sending the response back to the client.
   * @return value or {@code null} for none
   */
  public java.util.List<HttpHeaderOption> getResponseHeadersToAdd() {
    return responseHeadersToAdd;
  }

  /**
   * Headers to add the response prior to sending the response back to the client.
   * @param responseHeadersToAdd responseHeadersToAdd or {@code null} for none
   */
  public HttpHeaderAction setResponseHeadersToAdd(java.util.List<HttpHeaderOption> responseHeadersToAdd) {
    this.responseHeadersToAdd = responseHeadersToAdd;
    return this;
  }

  /**
   * A list of header names for headers that need to be removed from the response prior to sending
   * the response back to the client.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getResponseHeadersToRemove() {
    return responseHeadersToRemove;
  }

  /**
   * A list of header names for headers that need to be removed from the response prior to sending
   * the response back to the client.
   * @param responseHeadersToRemove responseHeadersToRemove or {@code null} for none
   */
  public HttpHeaderAction setResponseHeadersToRemove(java.util.List<java.lang.String> responseHeadersToRemove) {
    this.responseHeadersToRemove = responseHeadersToRemove;
    return this;
  }

  @Override
  public HttpHeaderAction set(String fieldName, Object value) {
    return (HttpHeaderAction) super.set(fieldName, value);
  }

  @Override
  public HttpHeaderAction clone() {
    return (HttpHeaderAction) super.clone();
  }

}
