/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Describes a pre-shared key used to setup MACsec in static connectivity association key (CAK)
 * mode.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InterconnectMacsecConfigPreSharedKey extends com.google.api.client.json.GenericJson {

  /**
   * An auto-generated Connectivity Association Key (CAK) for this key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cak;

  /**
   * An auto-generated Connectivity Association Key Name (CKN) for this key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ckn;

  /**
   * User provided name for this pre-shared key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * User provided timestamp on or after which this key is valid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTime;

  /**
   * An auto-generated Connectivity Association Key (CAK) for this key.
   * @return value or {@code null} for none
   */
  public java.lang.String getCak() {
    return cak;
  }

  /**
   * An auto-generated Connectivity Association Key (CAK) for this key.
   * @param cak cak or {@code null} for none
   */
  public InterconnectMacsecConfigPreSharedKey setCak(java.lang.String cak) {
    this.cak = cak;
    return this;
  }

  /**
   * An auto-generated Connectivity Association Key Name (CKN) for this key.
   * @return value or {@code null} for none
   */
  public java.lang.String getCkn() {
    return ckn;
  }

  /**
   * An auto-generated Connectivity Association Key Name (CKN) for this key.
   * @param ckn ckn or {@code null} for none
   */
  public InterconnectMacsecConfigPreSharedKey setCkn(java.lang.String ckn) {
    this.ckn = ckn;
    return this;
  }

  /**
   * User provided name for this pre-shared key.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * User provided name for this pre-shared key.
   * @param name name or {@code null} for none
   */
  public InterconnectMacsecConfigPreSharedKey setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * User provided timestamp on or after which this key is valid.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTime() {
    return startTime;
  }

  /**
   * User provided timestamp on or after which this key is valid.
   * @param startTime startTime or {@code null} for none
   */
  public InterconnectMacsecConfigPreSharedKey setStartTime(java.lang.String startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public InterconnectMacsecConfigPreSharedKey set(String fieldName, Object value) {
    return (InterconnectMacsecConfigPreSharedKey) super.set(fieldName, value);
  }

  @Override
  public InterconnectMacsecConfigPreSharedKey clone() {
    return (InterconnectMacsecConfigPreSharedKey) super.clone();
  }

}
