/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A concurrency control configuration. Defines a group config that, when attached to an instance,
 * recognizes that instance as part of a group of instances where only up the concurrency_limit of
 * instances in that group can undergo simultaneous maintenance. For more information: go
 * /concurrency-control-design-doc
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyVmMaintenancePolicyConcurrencyControl extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer concurrencyLimit;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getConcurrencyLimit() {
    return concurrencyLimit;
  }

  /**
   * @param concurrencyLimit concurrencyLimit or {@code null} for none
   */
  public ResourcePolicyVmMaintenancePolicyConcurrencyControl setConcurrencyLimit(java.lang.Integer concurrencyLimit) {
    this.concurrencyLimit = concurrencyLimit;
    return this;
  }

  @Override
  public ResourcePolicyVmMaintenancePolicyConcurrencyControl set(String fieldName, Object value) {
    return (ResourcePolicyVmMaintenancePolicyConcurrencyControl) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyVmMaintenancePolicyConcurrencyControl clone() {
    return (ResourcePolicyVmMaintenancePolicyConcurrencyControl) super.clone();
  }

}
